/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.listeners;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.MDC;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.mgt.listeners.utils.ListenerUtils;

public class UserManagementAuditLogger
extends AbstractIdentityUserOperationEventListener {
    private static final Log audit = CarbonConstants.AUDIT_LOG;
    private static final String SUCCESS = "Success";
    private static final String IN_PROGRESS = "In-Progress";
    public static final String USER_AGENT_QUERY_KEY = "User-Agent";
    public static final String USER_AGENT_KEY = "User Agent";
    public static final String REMOTE_ADDRESS_QUERY_KEY = "remoteAddress";
    public static final String REMOTE_ADDRESS_KEY = "RemoteAddress";
    public static final String SERVICE_PROVIDER_KEY = "ServiceProviderName";
    public static final String SERVICE_PROVIDER_QUERY_KEY = "serviceProvider";
    private final String USER_NAME_KEY = "UserName";
    private final String USER_NAME_QUERY_KEY = "userName";

    public boolean doPostAddUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profile, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject data = new JSONObject();
            data.put("Claims", (Object)new JSONObject(claims));
            if (ArrayUtils.isNotEmpty((Object[])roleList)) {
                data.put("Roles", (Object)new JSONArray((Object)roleList));
            }
            data.put("Profile", (Object)profile);
            audit.warn((Object)this.createAuditMessage("Add-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), data, SUCCESS));
        }
        return true;
    }

    public boolean doPostDeleteUser(String userName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.warn((Object)this.createAuditMessage("Delete-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Claim", (Object)claimURI);
            dataObject.put("Claim Value", (Object)claimValue);
            dataObject.put("Profile", (Object)profileName);
            audit.info((Object)this.createAuditMessage("Set-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, IN_PROGRESS));
        }
        return true;
    }

    public boolean doPostSetUserClaimValue(String userName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.warn((Object)this.createAuditMessage("Set-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPostSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Claims", (Object)new JSONObject(claims));
            dataObject.put("Profile", (Object)profileName);
            audit.warn((Object)this.createAuditMessage("Set-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValues(String userName, String[] claims, String profileName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Profile", (Object)profileName);
            dataObject.put("Claims", (Object)new JSONObject((Object)claims));
            audit.warn((Object)this.createAuditMessage("Delete-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, IN_PROGRESS));
        }
        return true;
    }

    public boolean doPostDeleteUserClaimValues(String userName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.warn((Object)this.createAuditMessage("Delete-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPreDeleteUserClaimValue(String userName, String claimURI, String profileName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Claim", (Object)claimURI);
            dataObject.put("Profile", (Object)profileName);
            audit.warn((Object)this.createAuditMessage("Delete-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, IN_PROGRESS));
        }
        return true;
    }

    public boolean doPostDeleteUserClaimValue(String userName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.warn((Object)this.createAuditMessage("Delete-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPostUpdateCredential(String userName, Object credential, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.warn((Object)this.createAuditMessage("Change-Password-by-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPostUpdateCredentialByAdmin(String userName, Object newCredential, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.info((Object)this.createAuditMessage("Change-Password-by-Administrator", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPostDeleteRole(String roleName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            audit.warn((Object)this.createAuditMessage("Delete-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), null, SUCCESS));
        }
        return true;
    }

    public boolean doPostAddRole(String roleName, String[] userList, Permission[] permissions, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            if (ArrayUtils.isNotEmpty((Object[])userList)) {
                dataObject.put("Users", (Object)new JSONArray((Object)userList));
            }
            if (ArrayUtils.isNotEmpty((Object[])permissions)) {
                JSONArray permissionsArray = new JSONArray((Object)permissions);
                dataObject.put("Permissions", (Object)permissionsArray);
            }
            audit.warn((Object)this.createAuditMessage("Add-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostUpdateRoleName(String roleName, String newRoleName, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("NewRoleName", (Object)newRoleName);
            audit.warn((Object)this.createAuditMessage("Update-Role-Name", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostUpdatePermissionsOfRole(String roleName, Permission[] permissions, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            if (ArrayUtils.isNotEmpty((Object[])permissions)) {
                JSONArray permissionsArray = new JSONArray((Object)permissions);
                dataObject.put("Permissions", (Object)permissionsArray);
            }
            audit.warn((Object)this.createAuditMessage("Update-Permissions-of-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostUpdateUserListOfRole(String roleName, String[] deletedUsers, String[] newUsers, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            if (ArrayUtils.isNotEmpty((Object[])deletedUsers)) {
                dataObject.put("Deleted Users", (Object)new JSONArray((Object)deletedUsers));
            }
            if (ArrayUtils.isNotEmpty((Object[])newUsers)) {
                dataObject.put("New Users", (Object)new JSONArray((Object)newUsers));
            }
            audit.info((Object)this.createAuditMessage("Update-Users-of-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostUpdateRoleListOfUser(String userName, String[] deletedRoles, String[] newRoles, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            if (ArrayUtils.isNotEmpty((Object[])deletedRoles)) {
                dataObject.put("Deleted Roles", (Object)new JSONArray((Object)deletedRoles));
            }
            if (ArrayUtils.isNotEmpty((Object[])newRoles)) {
                dataObject.put("New Roles", (Object)new JSONArray((Object)newRoles));
            }
            audit.info((Object)this.createAuditMessage("Update-Roles-of-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostGetUserClaimValue(String userName, String claim, List<String> claimValue, String profileName, UserStoreManager storeManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Claim", (Object)claim);
            if (CollectionUtils.isNotEmpty(claimValue)) {
                dataObject.put("Claim Value", (Object)new JSONArray(claimValue));
            }
            dataObject.put("Profile", (Object)profileName);
            audit.info((Object)this.createAuditMessage("Get-User-Claim-Value", ListenerUtils.getEntityWithUserStoreDomain(userName, storeManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostGetUserClaimValues(String userName, String[] claims, String profileName, Map<String, String> claimMap, UserStoreManager storeManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Claims", (Object)new JSONObject(claimMap));
            dataObject.put("Profile", (Object)profileName);
            audit.info((Object)this.createAuditMessage("Get-User-Claim-Values", ListenerUtils.getEntityWithUserStoreDomain(userName, storeManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostGetUserList(String claimUri, String claimValue, List<String> returnValues, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Claim", (Object)claimUri);
            dataObject.put("Claim Value", (Object)claimValue);
            if (CollectionUtils.isNotEmpty(returnValues)) {
                dataObject.put("Users", (Object)new JSONArray(returnValues));
            }
            audit.info((Object)this.createAuditMessage("Get-User-List", null, dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostGetRoleListOfUser(String userName, String filter, String[] roleList, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            dataObject.put("Filter", (Object)filter);
            if (ArrayUtils.isNotEmpty((Object[])roleList)) {
                dataObject.put("Roles", (Object)new JSONArray((Object)roleList));
            }
            audit.info((Object)this.createAuditMessage("Get-Roles-of-User", ListenerUtils.getEntityWithUserStoreDomain(userName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public boolean doPostGetUserListOfRole(String roleName, String[] userList, UserStoreManager userStoreManager) {
        if (this.isEnable()) {
            JSONObject dataObject = new JSONObject();
            if (ArrayUtils.isNotEmpty((Object[])userList)) {
                dataObject.put("Users", (Object)new JSONArray((Object)userList));
            }
            audit.info((Object)this.createAuditMessage("Get-Users-of-Role", ListenerUtils.getEntityWithUserStoreDomain(roleName, userStoreManager), dataObject, SUCCESS));
        }
        return true;
    }

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 1;
    }

    private String createAuditMessage(String action, String target, JSONObject data, String resultField) {
        if (data == null) {
            data = new JSONObject();
        }
        this.addContextualAuditParams(data);
        String auditMessage = "Initiator=%s Action=%s Target=%s Data=%s Outcome=%s";
        return String.format(auditMessage, ListenerUtils.getUser(), action, target, data, resultField);
    }

    private void addContextualAuditParams(JSONObject jsonObject) {
        jsonObject.put(REMOTE_ADDRESS_KEY, (Object)MDC.get((String)REMOTE_ADDRESS_QUERY_KEY));
        jsonObject.put(USER_AGENT_KEY, (Object)MDC.get((String)USER_AGENT_QUERY_KEY));
        jsonObject.put("UserName", (Object)MDC.get((String)"userName"));
        jsonObject.put(SERVICE_PROVIDER_KEY, (Object)MDC.get((String)SERVICE_PROVIDER_QUERY_KEY));
    }
}

