/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.listeners;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;
import org.wso2.carbon.user.mgt.recorder.RecorderException;
import org.wso2.carbon.user.mgt.recorder.UserDeletionEventRecorder;

public class UserDeletionEventListener
extends AbstractIdentityUserOperationEventListener {
    private static final Log log = LogFactory.getLog(UserDeletionEventListener.class);
    private static final String EVENT_RECORDERS_ELEMENT = "UserDeleteEventRecorders";
    private static final String ENABLE_ATTRIBUTE = "enable";
    private static final String NAME_ATTRIBUTE = "name";

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 98;
    }

    public boolean doPostDeleteUser(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        IdentityConfigParser identityConfigParser = IdentityConfigParser.getInstance();
        Map<UserDeletionEventRecorder, Map<String, String>> userDeleteEventRecorders = this.readDeletionEventRecorders(identityConfigParser);
        try {
            String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
            int tenantId = userStoreManager.getTenantId();
            String tenantDomain = UserMgtDSComponent.getRealmService().getTenantManager().getDomain(userStoreManager.getTenantId());
            for (Map.Entry<UserDeletionEventRecorder, Map<String, String>> entry : userDeleteEventRecorders.entrySet()) {
                UserDeletionEventRecorder userDeletionEventRecorder = entry.getKey();
                Map<String, String> stringMap = entry.getValue();
                userDeletionEventRecorder.recordUserDeleteEvent(userName, userStoreDomain, tenantDomain, tenantId, new Date(System.currentTimeMillis()), stringMap);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Event recorder with name: " + userDeletionEventRecorder.getClass().getName() + " invoked with values. " + userName + ", " + userStoreDomain + ", " + tenantId));
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException | RecorderException e) {
            throw new UserStoreException(e);
        }
        return true;
    }

    private Map<UserDeletionEventRecorder, Map<String, String>> readDeletionEventRecorders(IdentityConfigParser identityConfigParser) {
        HashMap<UserDeletionEventRecorder, Map<String, String>> userDeleteEventRecorders = new HashMap<UserDeletionEventRecorder, Map<String, String>>();
        OMElement deleteEventRecorders = identityConfigParser.getConfigElement(EVENT_RECORDERS_ELEMENT);
        if (deleteEventRecorders == null) {
            return userDeleteEventRecorders;
        }
        Iterator deleteEventRecordersChildElements = deleteEventRecorders.getChildElements();
        while (deleteEventRecordersChildElements.hasNext()) {
            OMAttribute className;
            OMAttribute enabled;
            Object recorderElement = deleteEventRecordersChildElements.next();
            if (!(recorderElement instanceof OMElement) || (enabled = ((OMElement)recorderElement).getAttribute(new QName(ENABLE_ATTRIBUTE))) == null || !Boolean.parseBoolean(enabled.getAttributeValue()) || (className = ((OMElement)recorderElement).getAttribute(new QName(NAME_ATTRIBUTE))) == null) continue;
            UserDeletionEventRecorder userDeletionEventRecorder = UserMgtDSComponent.getUserDeleteEventRecorders().get(className.getAttributeValue());
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            Iterator properties = ((OMElement)recorderElement).getChildElements();
            while (properties.hasNext()) {
                Object propertyElement = properties.next();
                if (!(propertyElement instanceof OMElement)) continue;
                String nameAttribute = ((OMElement)propertyElement).getAttributeValue(new QName(NAME_ATTRIBUTE));
                String value = ((OMElement)propertyElement).getText();
                propertiesMap.put(nameAttribute, value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Property " + value + " added to the recorder: " + className.getAttributeValue()));
            }
            if (userDeletionEventRecorder == null) continue;
            userDeleteEventRecorders.put(userDeletionEventRecorder, propertiesMap);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Event recorder with name: " + className.getAttributeValue() + " added."));
        }
        return userDeleteEventRecorders;
    }
}

