/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class UserClaimsAuditLogger
extends AbstractIdentityUserOperationEventListener {
    private static Log log = LogFactory.getLog(UserClaimsAuditLogger.class);
    private static final Log audit = CarbonConstants.AUDIT_LOG;
    private static final int DEFAULT_EXECUTION_ORDER = 9;
    private static String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Claims : { %s }";
    private static String AUDIT_MESSAGE_FOR_UPDATED_CLAIMS = "Initiator : %s | Action : %s | Target : %s | Added Claims : { %s } | Updated Claims : { %s } | Removed Claims : { %s }";
    private static final String CONFIG_CHANGE_LOG_CLAIMS = "LoggableUserClaims.LoggableUserClaim";
    private static final String LOG_UPDATED_CLAIMS_ONLY_PROPERTY = "LogUpdatedClaimsOnly";
    private static final String EVENT_LISTENER_TYPE = "org.wso2.carbon.user.core.listener.UserOperationEventListener";
    private String[] loggableClaimURIs;
    private static final String DEFAULT = "default";
    private static final String ROLE_CLAIM_URI = "http://wso2.org/claims/role";

    public int getExecutionOrderId() {
        int result = super.getExecutionOrderId();
        return result <= 0 ? 9 : result;
    }

    public void init() {
        Object configValue = IdentityConfigParser.getInstance().getConfiguration().get(CONFIG_CHANGE_LOG_CLAIMS);
        ArrayList claimsFilters = new ArrayList();
        if (configValue instanceof ArrayList) {
            claimsFilters = (ArrayList)configValue;
        } else if (configValue instanceof String) {
            claimsFilters.add((String)configValue);
        }
        if (CollectionUtils.isEmpty((Collection)claimsFilters)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No Claim filters configured under LoggableUserClaims.LoggableUserClaim. User claim changes will not be logged.");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Some Claim filters configured under LoggableUserClaims.LoggableUserClaim. User claim changes will be logged.");
            }
            this.loggableClaimURIs = StringUtils.stripAll((String[])claimsFilters.toArray(new String[claimsFilters.size()]));
        }
    }

    public boolean doPreSetUserClaimValue(String userName, String claimURI, String claimValue, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (this.isEnable()) {
            this.logClaims(userName, "doPreSetUserClaimValue", userStoreManager);
        }
        return true;
    }

    public boolean doPostSetUserClaimValue(String userName, UserStoreManager userStoreManager) throws UserStoreException {
        if (this.isEnable()) {
            this.logClaims(userName, "doPostSetUserClaimValue", userStoreManager);
        }
        return true;
    }

    public boolean doPreSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (this.isEnable()) {
            if (this.isLogUpdatedClaimsOnlyPropertyEnabled()) {
                this.logUpdatedClaims(userName, claims, "doPreSetUserClaimValues", userStoreManager);
            } else {
                this.logClaims(userName, "doPreSetUserClaimValues", userStoreManager);
            }
        }
        return true;
    }

    public boolean doPostSetUserClaimValues(String userName, Map<String, String> claims, String profileName, UserStoreManager userStoreManager) throws UserStoreException {
        if (this.isEnable()) {
            if (this.isLogUpdatedClaimsOnlyPropertyEnabled()) {
                return true;
            }
            this.logClaims(userName, "doPostSetUserClaimValues", userStoreManager);
        }
        return true;
    }

    private boolean isLogUpdatedClaimsOnlyPropertyEnabled() {
        Object propertyValue = IdentityUtil.readEventListenerProperty((String)EVENT_LISTENER_TYPE, (String)((Object)((Object)this)).getClass().getName()).getProperties().get(LOG_UPDATED_CLAIMS_ONLY_PROPERTY);
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue.toString());
        }
        return false;
    }

    private void logUpdatedClaims(String userName, Map<String, String> claims, String action, UserStoreManager userStoreManager) {
        try {
            HashMap<String, String> addedClaims = new HashMap<String, String>();
            HashMap<String, String> updatedClaims = new HashMap<String, String>();
            HashMap<String, String> removedClaims = new HashMap<String, String>();
            Map loggableClaims = userStoreManager.getUserClaimValues(userName, this.loggableClaimURIs, DEFAULT);
            this.resolveLoggableClaims(loggableClaims);
            for (Map.Entry entry : loggableClaims.entrySet()) {
                String claimURI = (String)entry.getKey();
                String claimValue = (String)entry.getValue();
                String updatedClaimValue = claims.get(claimURI);
                if (StringUtils.isNotEmpty((String)updatedClaimValue) && !updatedClaimValue.equals(claimValue)) {
                    updatedClaims.put(claimURI, updatedClaimValue);
                }
                if (!StringUtils.isEmpty((String)updatedClaimValue) || !StringUtils.isNotEmpty((String)claimValue)) continue;
                removedClaims.put(claimURI, claimValue);
            }
            for (String loggableClaim : this.loggableClaimURIs) {
                String claimValue = (String)loggableClaims.get(loggableClaim);
                String updatedClaimValue = claims.get(loggableClaim);
                if (!StringUtils.isNotEmpty((String)updatedClaimValue) || !StringUtils.isEmpty((String)claimValue)) continue;
                addedClaims.put(loggableClaim, updatedClaimValue);
            }
            if (MapUtils.isNotEmpty(addedClaims) || MapUtils.isNotEmpty(updatedClaims) || MapUtils.isNotEmpty(removedClaims)) {
                audit.info((Object)String.format(AUDIT_MESSAGE_FOR_UPDATED_CLAIMS, this.getUser(), action, userName, this.formatClaims(addedClaims), this.formatClaims(updatedClaims), this.formatClaims(removedClaims)));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Updated claims are not configured under the user: " + userName));
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while logging updated user claim changes.", (Throwable)e);
        }
    }

    private void resolveLoggableClaims(Map<String, String> loggableClaims) {
        loggableClaims.remove(ROLE_CLAIM_URI);
        if (log.isDebugEnabled()) {
            log.debug((Object)"http://wso2.org/claims/role claim is removed from the loggable claims as it is a read-only claim.");
        }
    }

    private void logClaims(String userName, String action, UserStoreManager userStoreManager) {
        try {
            Map loggableClaims = userStoreManager.getUserClaimValues(userName, this.loggableClaimURIs, DEFAULT);
            if (MapUtils.isNotEmpty((Map)loggableClaims)) {
                audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), action, userName, this.formatClaims(loggableClaims)));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("No claims are configured under the user : " + userName));
            }
        }
        catch (UserStoreException e) {
            log.error((Object)"Error occurred while logging user claim changes.", (Throwable)e);
        }
    }

    private String formatClaims(Map<String, String> claims) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean notEmpty = false;
        for (Map.Entry<String, String> claimEntry : claims.entrySet()) {
            if (notEmpty) {
                stringBuilder.append(" , ");
            }
            if (!StringUtils.isNotEmpty((String)claimEntry.getValue())) continue;
            stringBuilder.append("\"").append(claimEntry.getKey()).append("\"");
            stringBuilder.append(" : ");
            stringBuilder.append("\"").append(claimEntry.getValue()).append("\"");
            notEmpty = true;
        }
        return stringBuilder.toString();
    }

    private String getUser() {
        String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
        user = user != null ? user + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : "wso2.system.user";
        return user;
    }
}

