/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.listeners;

import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractAuthorizationManagerListener;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;

public class PermissionAuthorizationListener
extends AbstractAuthorizationManagerListener
implements AuthorizationManagerListener {
    public int getExecutionOrderId() {
        return 5;
    }

    public boolean isRoleAuthorized(String roleName, String resourceId, String action, AuthorizationManager authorizationManager) throws UserStoreException {
        return this.isAuthorized(resourceId, authorizationManager);
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action, AuthorizationManager authorizationManager) throws UserStoreException {
        return this.isAuthorized(resourceId, authorizationManager);
    }

    public boolean isAuthorized(String resourceId, AuthorizationManager authorizationManager) throws UserStoreException {
        int tenantId = authorizationManager.getTenantId();
        if (tenantId == -1234) {
            return true;
        }
        String protectedPermissionPath = RegistryUtils.getAbsolutePath(null, (String)"/_system/config/permission/protected");
        return !resourceId.startsWith(protectedPermissionPath);
    }

    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
    }
}

