/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.listener.AuthorizationManagerListener;
import org.wso2.carbon.user.core.listener.UserManagementErrorEventListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.mgt.RolePermissionManagementService;
import org.wso2.carbon.user.mgt.RolePermissionManagementServiceImpl;
import org.wso2.carbon.user.mgt.internal.UserMgtInitializer;
import org.wso2.carbon.user.mgt.listeners.PermissionAuthorizationListener;
import org.wso2.carbon.user.mgt.listeners.UserClaimsAuditLogger;
import org.wso2.carbon.user.mgt.listeners.UserDeletionEventListener;
import org.wso2.carbon.user.mgt.listeners.UserManagementAuditLogger;
import org.wso2.carbon.user.mgt.listeners.UserMgtAuditLogger;
import org.wso2.carbon.user.mgt.listeners.UserMgtFailureAuditLogger;
import org.wso2.carbon.user.mgt.permission.ManagementPermissionsAdder;
import org.wso2.carbon.user.mgt.recorder.DefaultUserDeletionEventRecorder;
import org.wso2.carbon.user.mgt.recorder.UserDeletionEventRecorder;

@Component(name="usermgt.component", immediate=true)
public class UserMgtDSComponent {
    private static final Log log = LogFactory.getLog(UserMgtDSComponent.class);
    private static RegistryService registryService = null;
    private static RealmService realmService = null;
    private static Map<String, UserDeletionEventRecorder> userDeleteEventRecorders = new HashMap<String, UserDeletionEventRecorder>();
    private static Collection<UserOperationEventListener> userOperationEventListenerCollection;
    private static Map<Integer, UserOperationEventListener> userOperationEventListeners;
    private static Map<Integer, UserManagementErrorEventListener> userManagementErrorEventListeners;
    private static Collection<UserManagementErrorEventListener> userManagementErrorEventListenerCollection;

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"User Mgt bundle is activated ");
        }
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantDomain("carbon.super");
        carbonContext.setTenantId(-1234);
        UserMgtInitializer userMgtInitializer = new UserMgtInitializer();
        try {
            Bundle[] bundles;
            userMgtInitializer.start(ctxt.getBundleContext(), registryService);
            ManagementPermissionsAdder uiPermissionAdder = new ManagementPermissionsAdder();
            ctxt.getBundleContext().addBundleListener((BundleListener)uiPermissionAdder);
            for (Bundle bundle : bundles = ctxt.getBundleContext().getBundles()) {
                if (bundle.getState() != 32) continue;
                uiPermissionAdder.addUIPermissionFromBundle(bundle);
            }
            ServiceRegistration serviceRegistration = ctxt.getBundleContext().registerService(AuthorizationManagerListener.class.getName(), (Object)new PermissionAuthorizationListener(), null);
            if (serviceRegistration == null) {
                log.error((Object)"Error while registering PermissionAuthorizationListener.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"PermissionAuthorizationListener successfully registered.");
            }
            serviceRegistration = ctxt.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new UserMgtAuditLogger(), null);
            if (serviceRegistration == null) {
                log.error((Object)"Error while registering UserMgtAuditLogger.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"UserMgtAuditLogger successfully registered.");
            }
            serviceRegistration = ctxt.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)new UserManagementAuditLogger(), null);
            if (serviceRegistration == null) {
                log.error((Object)"Error while registering UserManagementAuditLogger.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"UserManagementAuditLogger successfully registered.");
            }
            serviceRegistration = ctxt.getBundleContext().registerService(UserManagementErrorEventListener.class.getName(), (Object)new UserMgtFailureAuditLogger(), null);
            if (serviceRegistration == null) {
                log.error((Object)"Error while registering UserMgtFailureAuditLogger.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"UserMgtFailureAuditLogger successfully registered.");
            }
            serviceRegistration = ctxt.getBundleContext().registerService(UserOperationEventListener.class, (Object)new UserDeletionEventListener(), null);
            if (serviceRegistration == null) {
                log.error((Object)"Error while registering UserDeletionEventListener.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"UserDeletionEventListener successfully registered.");
            }
            serviceRegistration = ctxt.getBundleContext().registerService(UserDeletionEventRecorder.class, (Object)new DefaultUserDeletionEventRecorder(), null);
            if (serviceRegistration == null) {
                log.error((Object)"Error while registering DefaultUserDeletionEventRecorder.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"DefaultUserDeletionEventRecorder successfully registered.");
            }
            UserClaimsAuditLogger userClaimsAuditLogger = new UserClaimsAuditLogger();
            userClaimsAuditLogger.init();
            ServiceRegistration userClaimsAuditLoggerSR = ctxt.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)userClaimsAuditLogger, null);
            if (userClaimsAuditLoggerSR == null) {
                log.error((Object)"Error while registering UserClaimsAuditLogger.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"UserClaimsAuditLogger successfully registered.");
            }
            ServiceRegistration rolePermissionManagementServiceRegistration = ctxt.getBundleContext().registerService(RolePermissionManagementService.class, (Object)new RolePermissionManagementServiceImpl(), null);
            if (rolePermissionManagementServiceRegistration == null) {
                log.error((Object)"Error while registering RolePermissionManagementServiceImpl.");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"RolePermissionManagementServiceImpl is successfully registered.");
            }
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"User Mgt bundle is deactivated ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Registry Service");
        }
        UserMgtDSComponent.registryService = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Registry Service");
        }
        UserMgtDSComponent.registryService = null;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        UserMgtDSComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        UserMgtDSComponent.realmService = null;
    }

    @Reference(name="org.wso2.carbon.user.mgt.recorder.UserDeletionEventRecorder", service=UserDeletionEventRecorder.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserDeleteEventRecorder")
    protected void setUserDeleteEventRecorder(UserDeletionEventRecorder userDeletionEventRecorder) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully added a user deletion event recorder. " + userDeletionEventRecorder.getClass().getName()));
        }
        userDeleteEventRecorders.put(userDeletionEventRecorder.getClass().getName(), userDeletionEventRecorder);
    }

    protected void unsetUserDeleteEventRecorder(UserDeletionEventRecorder userDeletionEventRecorder) {
        userDeleteEventRecorders.remove(userDeletionEventRecorder.getClass().getName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully removed the user deletion event recorder. " + userDeletionEventRecorder.getClass().getName()));
        }
    }

    @Reference(name="org.wso2.carbon.user.core.listener.UserOperationEventListener", service=UserOperationEventListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserOperationEventListenerService")
    protected synchronized void setUserOperationEventListenerService(UserOperationEventListener userOperationEventListenerService) {
        userOperationEventListenerCollection = null;
        if (userOperationEventListeners == null) {
            userOperationEventListeners = new TreeMap<Integer, UserOperationEventListener>();
        }
        userOperationEventListeners.put(userOperationEventListenerService.getExecutionOrderId(), userOperationEventListenerService);
    }

    protected synchronized void unsetUserOperationEventListenerService(UserOperationEventListener userOperationEventListenerService) {
        if (userOperationEventListenerService != null && userOperationEventListeners != null) {
            userOperationEventListeners.remove(userOperationEventListenerService.getExecutionOrderId());
            userOperationEventListenerCollection = null;
        }
    }

    @Reference(name="org.wso2.carbon.user.core.listener.UserManagementErrorEventListener", service=UserManagementErrorEventListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserManagementErrorEventListenerService")
    protected synchronized void setUserManagementErrorEventListenerService(UserManagementErrorEventListener userManagementErrorEventListenerService) {
        userManagementErrorEventListenerCollection = null;
        if (userManagementErrorEventListeners == null) {
            userManagementErrorEventListeners = new TreeMap<Integer, UserManagementErrorEventListener>();
        }
        userManagementErrorEventListeners.put(userManagementErrorEventListenerService.getExecutionOrderId(), userManagementErrorEventListenerService);
    }

    protected synchronized void unsetUserManagementErrorEventListenerService(UserManagementErrorEventListener userManagementErrorEventListenerService) {
        if (userManagementErrorEventListenerService != null && userManagementErrorEventListeners != null) {
            userManagementErrorEventListeners.remove(userManagementErrorEventListenerService.getExecutionOrderId());
            userManagementErrorEventListenerCollection = null;
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static Map<String, UserDeletionEventRecorder> getUserDeleteEventRecorders() {
        return userDeleteEventRecorders;
    }

    public static synchronized Collection<UserOperationEventListener> getUserOperationEventListeners() {
        if (userOperationEventListeners == null) {
            userOperationEventListeners = new TreeMap<Integer, UserOperationEventListener>();
        }
        if (userOperationEventListenerCollection == null) {
            userOperationEventListenerCollection = userOperationEventListeners.values();
        }
        return userOperationEventListenerCollection;
    }

    public static synchronized Collection<UserManagementErrorEventListener> getUserManagementErrorEventListeners() {
        if (userManagementErrorEventListeners == null) {
            userManagementErrorEventListeners = new TreeMap<Integer, UserManagementErrorEventListener>();
        }
        if (userManagementErrorEventListenerCollection == null) {
            userManagementErrorEventListenerCollection = userManagementErrorEventListeners.values();
        }
        return userManagementErrorEventListenerCollection;
    }
}

