/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.bulkimport.util;

import au.com.bytecode.opencsv.CSVReader;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class JSONConverter {
    private static final Log log = LogFactory.getLog(JSONConverter.class);
    private JsonObject content = new JsonObject();
    private JsonArray users;

    public String csvToJSON(InputStream sourceStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sourceStream));
        CSVReader csvReader = new CSVReader((Reader)bufferedReader, ',', '\"', 1);
        String[] line = csvReader.readNext();
        this.users = new JsonArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting csv to json.");
        }
        while (line != null) {
            JsonPrimitive user = new JsonPrimitive(line[0]);
            this.users.add((JsonElement)user);
            line = csvReader.readNext();
        }
        this.content.add("users", (JsonElement)this.users);
        return this.content.toString();
    }

    public String xlsToJSON(Sheet sheet) {
        int limit = sheet.getLastRowNum();
        this.users = new JsonArray();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting XLS sheet to json.");
        }
        for (int i = 1; i < limit + 1; ++i) {
            Row row = sheet.getRow(i);
            Cell cell = row.getCell(0);
            String name = cell.getStringCellValue();
            JsonPrimitive userJson = new JsonPrimitive(name);
            this.users.add((JsonElement)userJson);
        }
        this.content.add("users", (JsonElement)this.users);
        return this.content.toString();
    }
}

