/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.bulkimport;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public abstract class UserBulkImport {
    static final Log auditLog = CarbonConstants.AUDIT_LOG;
    static final Map<String, String> errorUsersMap = new HashMap<String, String>();
    static final List<String> duplicateUsers = new ArrayList<String>();
    String userStoreDomain = "";
    int successCount = 0;
    int failCount = 0;
    int duplicateCount = 0;
    String tenantUser = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername() + "@" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();

    public abstract void addUserList(UserStoreManager var1) throws UserAdminException;

    String buildBulkImportSummary() {
        JsonObject summaryJson = new JsonObject();
        summaryJson.addProperty("operation", "bulk_user_import");
        summaryJson.addProperty("performedBy", PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername());
        summaryJson.addProperty("userStore", this.userStoreDomain);
        summaryJson.addProperty("successCount", (Number)this.successCount);
        if (this.duplicateCount > 0) {
            JsonObject duplicateUsersJson = new JsonObject();
            JsonArray duplicateUsersJsonArray = new JsonArray();
            duplicateUsersJson.addProperty("count", (Number)this.duplicateCount);
            for (String string : duplicateUsers) {
                JsonPrimitive userJson = new JsonPrimitive(string);
                duplicateUsersJsonArray.add((JsonElement)userJson);
            }
            duplicateUsersJson.add("users", (JsonElement)duplicateUsersJsonArray);
            summaryJson.add("duplicateUsers", (JsonElement)duplicateUsersJson);
        }
        if (this.failCount > 0) {
            JsonObject errorUsersJson = new JsonObject();
            JsonArray errorUsersJsonArray = new JsonArray();
            errorUsersJson.addProperty("count", (Number)this.failCount);
            for (Object object : errorUsersMap.entrySet()) {
                Map.Entry pair = (Map.Entry)object;
                JsonObject errorUserJson = new JsonObject();
                errorUserJson.addProperty("name", pair.getKey().toString());
                errorUserJson.addProperty("cause", pair.getValue().toString());
                errorUsersJsonArray.add((JsonElement)errorUserJson);
            }
            errorUsersJson.add("users", (JsonElement)errorUsersJsonArray);
            summaryJson.add("failedUsers", (JsonElement)errorUsersJson);
        }
        return summaryJson.toString();
    }
}

