/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.bulkimport;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.bulkimport.UserBulkImport;
import org.wso2.carbon.user.mgt.bulkimport.util.JSONConverter;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class ExcelUserBulkImport
extends UserBulkImport {
    private static final Log log = LogFactory.getLog(ExcelUserBulkImport.class);
    private BulkImportConfig config;

    public ExcelUserBulkImport(BulkImportConfig config) {
        this.config = config;
    }

    @Override
    public void addUserList(UserStoreManager userStore) throws UserAdminException {
        Workbook wb = this.createWorkbook();
        Sheet sheet = wb.getSheet(wb.getSheetName(0));
        this.userStoreDomain = this.config.getUserStoreDomain();
        if (sheet == null || sheet.getLastRowNum() == -1) {
            throw new UserAdminException("The first sheet is empty");
        }
        int limit = sheet.getLastRowNum();
        boolean isDuplicate = false;
        boolean fail = false;
        for (int i = 1; i < limit + 1; ++i) {
            Row row = sheet.getRow(i);
            Cell cell = row.getCell(0);
            String userName = cell.getStringCellValue();
            int index = userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
            if (index > 0) {
                String domainFreeName = userName.substring(index + 1);
                userName = UserCoreUtil.addDomainToName((String)domainFreeName, (String)this.userStoreDomain);
            } else {
                userName = UserCoreUtil.addDomainToName((String)userName, (String)this.userStoreDomain);
            }
            if (!StringUtils.isNotBlank((String)userName)) continue;
            try {
                if (!userStore.isExistingUser(userName)) {
                    userStore.addUser(userName, null, null, null, null, true);
                    ++this.successCount;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("User import successful - Username : " + userName));
                    continue;
                }
                ++this.duplicateCount;
                duplicateUsers.add(userName);
                isDuplicate = true;
                log.error((Object)("User import unsuccessful - Username : " + userName + " - Error: Duplicate user"));
                duplicateUsers.add(userName);
                continue;
            }
            catch (UserStoreException e) {
                fail = true;
                ++this.failCount;
                log.error((Object)("User import unsuccessful - Username : " + userName + " - Error: " + e.getMessage()));
                errorUsersMap.put(userName, e.getMessage());
            }
        }
        String summeryLog = super.buildBulkImportSummary();
        log.info((Object)summeryLog);
        JSONConverter jsonConverter = new JSONConverter();
        String importedUsers = jsonConverter.xlsToJSON(sheet);
        auditLog.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : %s | Result : %s", this.tenantUser, "bulk_user_import", this.userStoreDomain, importedUsers, summeryLog));
        if (fail || isDuplicate) {
            throw new UserAdminException(String.format("Bulk User Import was completed with Errors. Success count : %d,  Failed Count : %d, Duplicate Count : %d.", this.successCount, this.failCount, this.duplicateCount));
        }
    }

    private Workbook createWorkbook() throws UserAdminException {
        XSSFWorkbook wb;
        String filename = this.config.getFileName();
        InputStream ins = this.config.getInStream();
        try {
            if (filename.endsWith(".xlsx")) {
                wb = new XSSFWorkbook(ins);
            } else {
                POIFSFileSystem fs = new POIFSFileSystem(ins);
                wb = new HSSFWorkbook(fs);
            }
        }
        catch (IOException e) {
            throw new UserAdminException("Error reading the xls file " + e.getMessage(), e);
        }
        finally {
            IdentityIOStreamUtils.closeInputStream((InputStream)ins);
        }
        return wb;
    }
}

