/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.bulkimport;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.bulkimport.UserBulkImport;
import org.wso2.carbon.user.mgt.bulkimport.util.JSONConverter;
import org.wso2.carbon.user.mgt.common.UserAdminException;

public class CSVUserBulkImport
extends UserBulkImport {
    private static final Log log = LogFactory.getLog(CSVUserBulkImport.class);
    private BufferedReader reader;
    private BulkImportConfig config;

    public CSVUserBulkImport(BulkImportConfig config) {
        this.config = config;
        this.reader = new BufferedReader(new InputStreamReader(config.getInStream(), Charset.forName("UTF-8")));
    }

    @Override
    public void addUserList(UserStoreManager userStore) throws UserAdminException {
        CSVReader csvReader = new CSVReader((Reader)this.reader, ',', '\"', 1);
        try {
            this.userStoreDomain = this.config.getUserStoreDomain();
            String[] line = csvReader.readNext();
            boolean isDuplicate = false;
            boolean fail = false;
            while (line != null && line.length > 0) {
                block22: {
                    String userName = line[0];
                    int index = userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
                    if (index > 0) {
                        String domainFreeName = userName.substring(index + 1);
                        userName = UserCoreUtil.addDomainToName((String)domainFreeName, (String)this.userStoreDomain);
                    } else {
                        userName = UserCoreUtil.addDomainToName((String)userName, (String)this.userStoreDomain);
                    }
                    if (StringUtils.isNotBlank((String)userName)) {
                        try {
                            if (!userStore.isExistingUser(userName)) {
                                if (line.length == 1) {
                                    userStore.addUser(userName, null, null, null, null, true);
                                    ++this.successCount;
                                    break block22;
                                }
                                try {
                                    this.addUserWithClaims(userName, line, userStore);
                                    ++this.successCount;
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)("User import successful - Username : " + userName));
                                    }
                                    break block22;
                                }
                                catch (IllegalArgumentException e) {
                                    fail = true;
                                    ++this.failCount;
                                    errorUsersMap.put(userName, e.getMessage());
                                    log.error((Object)("User import unsuccessful - Username : " + userName + " - Error: " + e.getMessage()), (Throwable)e);
                                }
                                break block22;
                            }
                            isDuplicate = true;
                            ++this.duplicateCount;
                            duplicateUsers.add(userName);
                            log.error((Object)("User import unsuccessful - Username : " + userName + " - Error: Duplicate user"));
                        }
                        catch (UserStoreException e) {
                            fail = true;
                            ++this.failCount;
                            errorUsersMap.put(userName, e.getMessage());
                            log.error((Object)("User import unsuccessful - Username : " + userName + " - Error: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                line = csvReader.readNext();
            }
            InputStream inputStream = this.config.getInStream();
            inputStream.reset();
            JSONConverter jsonConverter = new JSONConverter();
            String usersImported = jsonConverter.csvToJSON(inputStream);
            String summaryLog = this.buildBulkImportSummary();
            auditLog.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : %s | Result : %s", this.tenantUser, "bulk_user_import", this.userStoreDomain, usersImported, summaryLog));
            log.info((Object)summaryLog);
            if (fail || isDuplicate) {
                throw new UserAdminException(String.format("Bulk User Import was completed with Errors. Success count : %d,  Failed Count : %d, Duplicate Count : %d.", this.successCount, this.failCount, this.duplicateCount));
            }
        }
        catch (IOException e) {
            throw new UserAdminException("Error occurred while adding user list", e);
        }
        finally {
            try {
                if (csvReader != null) {
                    csvReader.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while closing CSV Reader", (Throwable)e);
            }
        }
    }

    private void addUserWithClaims(String username, String[] line, UserStoreManager userStore) throws UserStoreException {
        String roleString = null;
        String[] roles = null;
        String password = line[1];
        HashMap<String, String> claims = new HashMap<String, String>();
        for (int i = 2; i < line.length; ++i) {
            if (!StringUtils.isNotBlank((String)line[i])) continue;
            String[] claimStrings = line[i].split("=");
            if (claimStrings.length != 2) {
                throw new IllegalArgumentException("Claims and values are not in correct format");
            }
            String claimURI = claimStrings[0];
            String claimValue = claimStrings[1];
            if (claimURI.contains("role")) {
                roleString = claimValue;
                continue;
            }
            if (claimURI.isEmpty()) continue;
            claims.put(claimURI.trim(), claimValue);
        }
        if (StringUtils.isNotBlank(roleString)) {
            roles = roleString.split(":");
        }
        userStore.addUser(username, (Object)password, roles, claims, null, true);
    }
}

