/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.Permission;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.bulkimport.CSVUserBulkImport;
import org.wso2.carbon.user.mgt.bulkimport.ExcelUserBulkImport;
import org.wso2.carbon.user.mgt.bulkimport.UserBulkImport;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserRealmInfo;
import org.wso2.carbon.user.mgt.common.UserStoreInfo;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;
import org.wso2.carbon.user.mgt.permission.ManagementPermissionUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserRealmProxy {
    private static final Log log = LogFactory.getLog(UserRealmProxy.class);
    private static final String APPLICATIONS_PATH = "/permission/applications";
    private static final String DISAPLAY_NAME_CLAIM = "http://wso2.org/claims/displayName";
    public static final String FALSE = "false";
    public static final String PERMISSION = "/permission";
    public static final String PERMISSION_TREE = "/permission/";
    public static final String PERMISSION_ADMIN = "/permission/admin";
    public static final String PERMISSION_PROTECTED = "/permission/protected";
    private org.wso2.carbon.user.core.UserRealm realm = null;

    public UserRealmProxy(org.wso2.carbon.user.core.UserRealm userRealm) {
        this.realm = userRealm;
    }

    public String[] listUsers(String filter, int maxLimit) throws UserAdminException {
        try {
            return this.realm.getUserStoreManager().listUsers(filter, maxLimit);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] listUsers(ClaimValue claimValue, String filter, int maxLimit) throws UserAdminException {
        try {
            Object[] usersWithClaim = null;
            if (claimValue.getClaimURI() != null && claimValue.getValue() != null) {
                usersWithClaim = this.realm.getUserStoreManager().getUserList(claimValue.getClaimURI(), claimValue.getValue(), null);
            }
            int i = 0;
            FlaggedName[] flaggedNames = new FlaggedName[]{};
            if (usersWithClaim != null) {
                flaggedNames = new FlaggedName[usersWithClaim.length + 1];
                Arrays.sort(usersWithClaim);
                for (Object user : usersWithClaim) {
                    String domain;
                    flaggedNames[i] = new FlaggedName();
                    flaggedNames[i].setItemName((String)user);
                    String showDisplayName = IdentityUtil.getProperty((String)"UserFiltering.ShowDisplayName");
                    boolean isShowDisplayNameEnabled = Boolean.parseBoolean(showDisplayName);
                    if (isShowDisplayNameEnabled) {
                        String displayName = this.realm.getUserStoreManager().getUserClaimValue((String)user, DISAPLAY_NAME_CLAIM, null);
                        if (StringUtils.isNotBlank((String)displayName)) {
                            int index = ((String)user).indexOf(UserCoreConstants.DOMAIN_SEPARATOR);
                            if (index > 0) {
                                flaggedNames[i].setItemDisplayName(((String)user).substring(0, index + 1) + displayName);
                            } else {
                                flaggedNames[i].setItemDisplayName(displayName);
                            }
                        } else {
                            flaggedNames[i].setItemDisplayName((String)user);
                        }
                    } else {
                        flaggedNames[i].setItemDisplayName((String)user);
                    }
                    int index1 = flaggedNames[i].getItemName() != null ? flaggedNames[i].getItemName().indexOf(CarbonConstants.DOMAIN_SEPARATOR) : -1;
                    boolean domainProvided = index1 > 0;
                    String string = domain = domainProvided ? flaggedNames[i].getItemName().substring(0, index1) : null;
                    if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                        org.wso2.carbon.user.core.UserStoreManager secondaryUM = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                        if (secondaryUM != null && secondaryUM.isReadOnly()) {
                            flaggedNames[i].setEditable(false);
                        } else {
                            flaggedNames[i].setEditable(true);
                        }
                    } else if (this.realm.getUserStoreManager().isReadOnly()) {
                        flaggedNames[i].setEditable(false);
                    } else {
                        flaggedNames[i].setEditable(true);
                    }
                    ++i;
                }
                if (usersWithClaim.length > 0) {
                    FlaggedName flaggedName = new FlaggedName();
                    flaggedName.setItemName(FALSE);
                    flaggedName.setDomainName("");
                    flaggedNames[flaggedNames.length - 1] = flaggedName;
                }
            }
            return flaggedNames;
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] listAllUsers(String filter, int maxLimit) throws UserAdminException {
        FlaggedName[] flaggedNames = null;
        HashMap<String, Integer> userCount = new HashMap<String, Integer>();
        try {
            org.wso2.carbon.user.core.UserStoreManager userStoreManager = this.realm.getUserStoreManager();
            String[] users = userStoreManager.listUsers(filter, maxLimit);
            flaggedNames = new FlaggedName[users.length + 1];
            int i = 0;
            for (String user : users) {
                String domain;
                flaggedNames[i] = new FlaggedName();
                int index = user.indexOf("$_USERNAME_SEPARATOR_$");
                if (index > 0) {
                    flaggedNames[i].setItemName(user.substring(0, index));
                    flaggedNames[i].setItemDisplayName(user.substring(index + "$_USERNAME_SEPARATOR_$".length()));
                } else {
                    flaggedNames[i].setItemName(user);
                    flaggedNames[i].setItemDisplayName(user);
                }
                int index1 = flaggedNames[i].getItemName() != null ? flaggedNames[i].getItemName().indexOf(CarbonConstants.DOMAIN_SEPARATOR) : -1;
                boolean domainProvided = index1 > 0;
                String string = domain = domainProvided ? flaggedNames[i].getItemName().substring(0, index1) : null;
                if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                    org.wso2.carbon.user.core.UserStoreManager secondaryUM = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                    if (secondaryUM != null && secondaryUM.isReadOnly()) {
                        flaggedNames[i].setEditable(false);
                    } else {
                        flaggedNames[i].setEditable(true);
                    }
                } else if (this.realm.getUserStoreManager().isReadOnly()) {
                    flaggedNames[i].setEditable(false);
                } else {
                    flaggedNames[i].setEditable(true);
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                ++i;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        Arrays.sort(flaggedNames, new Comparator<FlaggedName>(){

            @Override
            public int compare(FlaggedName o1, FlaggedName o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
            }
        });
        String exceededDomains = "";
        boolean isPrimaryExceeding = false;
        try {
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxUserNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equalsIgnoreCase(domains[i])) {
                    if (((Integer)userCount.get("PRIMARY")).intValue() != ((Integer)maxUserListCount.get("PRIMARY")).intValue()) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName(FALSE);
            }
            flaggedName.setItemDisplayName(exceededDomains);
            flaggedNames[flaggedNames.length - 1] = flaggedName;
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        return flaggedNames;
    }

    public FlaggedName[] getAllSharedRoleNames(String filter, int maxLimit) throws UserAdminException {
        try {
            org.wso2.carbon.user.core.UserStoreManager userStoreMan = this.realm.getUserStoreManager();
            if (!(userStoreMan instanceof AbstractUserStoreManager)) {
                throw new UserAdminException("Initialized User Store Manager is not capable of getting the shared roles");
            }
            String[] externalRoles = ((AbstractUserStoreManager)userStoreMan).getSharedRoleNames(filter, maxLimit);
            ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            for (String externalRole : externalRoles) {
                FlaggedName fName = new FlaggedName();
                this.mapEntityName(externalRole, fName, userStoreMan);
                fName.setRoleType("External");
                int index = externalRole != null ? externalRole.indexOf(CarbonConstants.DOMAIN_SEPARATOR) : -1;
                boolean domainProvided = index > 0;
                String domain = domainProvided ? externalRole.substring(0, index) : null;
                org.wso2.carbon.user.core.UserStoreManager secManager = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                    if (secManager != null && (secManager.isReadOnly() || secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups") != null && FALSE.equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                flaggedNames.add(fName);
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName[] roleNames = flaggedNames.toArray(new FlaggedName[flaggedNames.size() + 1]);
            Arrays.sort(roleNames, new Comparator<FlaggedName>(){

                @Override
                public int compare(FlaggedName o1, FlaggedName o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
                }
            });
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName(FALSE);
            }
            flaggedName.setItemDisplayName(exceededDomains);
            roleNames[roleNames.length - 1] = flaggedName;
            return roleNames;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getAllRolesNames(String filter, int maxLimit) throws UserAdminException {
        try {
            org.wso2.carbon.user.core.UserStoreManager userStoreMan = this.realm.getUserStoreManager();
            String[] externalRoles = userStoreMan instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)userStoreMan).getRoleNames(filter, maxLimit, true, true, true) : userStoreMan.getRoleNames();
            ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            for (String externalRole : externalRoles) {
                FlaggedName fName = new FlaggedName();
                this.mapEntityName(externalRole, fName, userStoreMan);
                fName.setRoleType("External");
                int index = externalRole != null ? externalRole.indexOf(CarbonConstants.DOMAIN_SEPARATOR) : -1;
                boolean domainProvided = index > 0;
                String domain = domainProvided ? externalRole.substring(0, index) : null;
                org.wso2.carbon.user.core.UserStoreManager secManager = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                    if (secManager != null && (secManager.isReadOnly() || FALSE.equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                } else if (this.realm.getUserStoreManager().isReadOnly() || FALSE.equals(this.realm.getUserStoreManager().getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                    fName.setEditable(false);
                } else {
                    fName.setEditable(true);
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                flaggedNames.add(fName);
            }
            String filteredDomain = null;
            if (filter.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                filteredDomain = filter.split(CarbonConstants.DOMAIN_SEPARATOR)[0];
            }
            if (filter.startsWith("Internal" + CarbonConstants.DOMAIN_SEPARATOR)) {
                filter = filter.substring(filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR) + 1);
            }
            String[] hybridRoles = ((AbstractUserStoreManager)userStoreMan).getHybridRoles(filter);
            for (String hybridRole : hybridRoles = this.filterInternalSystemRoles(hybridRoles)) {
                if (filteredDomain != null && !hybridRole.startsWith(filteredDomain)) continue;
                FlaggedName fName = new FlaggedName();
                fName.setItemName(hybridRole);
                if (hybridRole.toLowerCase().startsWith("Internal".toLowerCase())) {
                    fName.setRoleType("Internal");
                } else {
                    fName.setRoleType("Application");
                }
                fName.setEditable(true);
                flaggedNames.add(fName);
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName[] roleNames = flaggedNames.toArray(new FlaggedName[flaggedNames.size() + 1]);
            Arrays.sort(roleNames, new Comparator<FlaggedName>(){

                @Override
                public int compare(FlaggedName o1, FlaggedName o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
                }
            });
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName(FALSE);
            }
            flaggedName.setItemDisplayName(exceededDomains);
            roleNames[roleNames.length - 1] = flaggedName;
            return roleNames;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private String[] filterInternalSystemRoles(String[] roles) throws UserAdminException {
        if (this.isRoleAndGroupSeparationEnabled()) {
            ArrayList<String> hybridRolesList = new ArrayList<String>(Arrays.asList(roles));
            hybridRolesList.removeIf(s -> s.startsWith("Internal" + CarbonConstants.DOMAIN_SEPARATOR + "system_"));
            roles = hybridRolesList.toArray(new String[0]);
        }
        return roles;
    }

    public UserRealmInfo getUserRealmInfo() throws UserAdminException {
        UserRealmInfo userRealmInfo = new UserRealmInfo();
        String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            int maxPagesInCache;
            RealmConfiguration realmConfig;
            block15: {
                int itemsPerPage;
                block14: {
                    realmConfig = this.realm.getRealmConfiguration();
                    if (this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/manage/identity", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/manage/identity/usermgt/users", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/manage/identity/usermgt/passwords", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/manage/identity/usermgt/view", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/manage/identity/rolemgt/view", "ui.execute")) {
                        userRealmInfo.setAdminRole(realmConfig.getAdminRoleName());
                        userRealmInfo.setAdminUser(realmConfig.getAdminUserName());
                        userRealmInfo.setEveryOneRole(realmConfig.getEveryOneRoleName());
                        Object[] defaultClaims = this.realm.getClaimManager().getAllClaimMappings("http://wso2.org/claims");
                        if (ArrayUtils.isNotEmpty((Object[])defaultClaims)) {
                            Arrays.sort(defaultClaims, new ClaimMappingsComparator());
                        }
                        ArrayList<String> fullClaimList = new ArrayList<String>();
                        ArrayList<String> requiredClaimsList = new ArrayList<String>();
                        ArrayList<String> defaultClaimList = new ArrayList<String>();
                        for (Object claimMapping : defaultClaims) {
                            Claim claim = claimMapping.getClaim();
                            fullClaimList.add(claim.getClaimUri());
                            if (claim.isRequired()) {
                                requiredClaimsList.add(claim.getClaimUri());
                            }
                            if (!claim.isSupportedByDefault()) continue;
                            defaultClaimList.add(claim.getClaimUri());
                        }
                        userRealmInfo.setUserClaims(fullClaimList.toArray(new String[fullClaimList.size()]));
                        userRealmInfo.setRequiredUserClaims(requiredClaimsList.toArray(new String[requiredClaimsList.size()]));
                        userRealmInfo.setDefaultUserClaims(defaultClaimList.toArray(new String[defaultClaimList.size()]));
                    }
                    ArrayList<UserStoreInfo> storeInfoList = new ArrayList<UserStoreInfo>();
                    ArrayList<String> domainNames = new ArrayList<String>();
                    RealmConfiguration secondaryConfig = realmConfig;
                    org.wso2.carbon.user.core.UserStoreManager secondaryManager = this.realm.getUserStoreManager();
                    do {
                        secondaryConfig = secondaryManager.getRealmConfiguration();
                        UserStoreInfo userStoreInfo = this.getUserStoreInfo(secondaryConfig, secondaryManager);
                        if (secondaryConfig.isPrimary()) {
                            userRealmInfo.setPrimaryUserStoreInfo(userStoreInfo);
                        }
                        storeInfoList.add(userStoreInfo);
                        userRealmInfo.setBulkImportSupported(secondaryManager.isBulkImportSupported());
                        String domainName = secondaryConfig.getUserStoreProperty("DomainName");
                        if (domainName == null || domainName.trim().length() <= 0) continue;
                        domainNames.add(domainName.toUpperCase());
                    } while ((secondaryManager = secondaryManager.getSecondaryUserStoreManager()) != null);
                    if (storeInfoList.size() > 1) {
                        userRealmInfo.setMultipleUserStore(true);
                    }
                    userRealmInfo.setUserStoresInfo(storeInfoList.toArray(new UserStoreInfo[storeInfoList.size()]));
                    userRealmInfo.setDomainNames(domainNames.toArray(new String[domainNames.size()]));
                    String itemsPerPageString = realmConfig.getRealmProperty("MaxItemsPerUserMgtUIPage");
                    itemsPerPage = 15;
                    try {
                        itemsPerPage = Integer.parseInt(itemsPerPageString);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block14;
                        log.debug((Object)"Error parsing number of items per page, using default value", (Throwable)e);
                    }
                }
                userRealmInfo.setMaxItemsPerUIPage(itemsPerPage);
                String maxPageInCacheString = realmConfig.getRealmProperty("MaxUserMgtUIPagesInCache");
                maxPagesInCache = 6;
                try {
                    maxPagesInCache = Integer.parseInt(maxPageInCacheString);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug((Object)"Error parsing number of maximum pages in cache, using default value", (Throwable)e);
                }
            }
            userRealmInfo.setMaxUIPagesInCache(maxPagesInCache);
            String enableUIPageCacheString = realmConfig.getRealmProperty("EnableUserMgtUIPageCache");
            boolean enableUIPageCache = true;
            if (FALSE.equals(enableUIPageCacheString)) {
                enableUIPageCache = false;
            }
            userRealmInfo.setEnableUIPageCache(enableUIPageCache);
        }
        catch (Exception e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        return userRealmInfo;
    }

    private UserStoreInfo getUserStoreInfo(RealmConfiguration realmConfig, org.wso2.carbon.user.core.UserStoreManager manager) throws UserAdminException {
        try {
            UserStoreInfo info = new UserStoreInfo();
            info.setReadOnly(manager.isReadOnly());
            boolean readRolesEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("ReadGroups"));
            info.setReadGroupsEnabled(readRolesEnabled);
            boolean writeRolesEnabled = Boolean.parseBoolean(realmConfig.getUserStoreProperty("WriteGroups"));
            info.setWriteGroupsEnabled(!manager.isReadOnly() && readRolesEnabled && writeRolesEnabled);
            info.setPasswordsExternallyManaged(realmConfig.isPasswordsExternallyManaged());
            info.setPasswordRegEx(realmConfig.getUserStoreProperty("PasswordJavaScriptRegEx"));
            info.setPasswordRegExViolationErrorMsg(realmConfig.getUserStoreProperty("PasswordJavaRegExViolationErrorMsg"));
            info.setUsernameRegExViolationErrorMsg(realmConfig.getUserStoreProperty("UsernameJavaRegExViolationErrorMsg"));
            info.setUserNameRegEx(realmConfig.getUserStoreProperty("UsernameJavaScriptRegEx"));
            info.setRoleNameRegEx(realmConfig.getUserStoreProperty("RolenameJavaScriptRegEx"));
            info.setExternalIdP(realmConfig.getUserStoreProperty("ExternalIdP"));
            info.setBulkImportSupported(this.isBulkImportSupported(realmConfig));
            info.setDomainName(realmConfig.getUserStoreProperty("DomainName"));
            boolean caseSensitiveUsername = IdentityUtil.isUserStoreCaseSensitive((org.wso2.carbon.user.core.UserStoreManager)manager);
            info.setCaseSensitiveUsername(caseSensitiveUsername);
            return info;
        }
        catch (UserStoreException e) {
            String domainName = manager.getRealmConfiguration().getUserStoreProperty("DomainName");
            String errorMsg = "Error while getting user realm information for domain '" + domainName + "' : " + e.getMessage();
            throw new UserAdminException(errorMsg, e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private boolean isBulkImportSupported(RealmConfiguration realmConfig) throws UserAdminException {
        if (realmConfig != null) {
            return Boolean.valueOf((String)realmConfig.getUserStoreProperties().get("IsBulkImportSupported"));
        }
        throw new UserAdminException("Unable to retrieve user store manager from realm.");
    }

    private final String addPrimaryDomainIfNotExists(String userName) {
        if (StringUtils.isNotEmpty((String)userName) && !userName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            StringBuilder builder = new StringBuilder();
            builder.append("PRIMARY").append(CarbonConstants.DOMAIN_SEPARATOR).append(userName);
            userName = builder.toString();
        }
        return userName;
    }

    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        try {
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (realmConfig.getUserStoreProperty("ExternalIdP") != null) {
                throw new UserAdminException("Please contact your external Identity Provider to add users");
            }
            if (roles != null && roles.length > 0) {
                String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
                String adminUser = this.addPrimaryDomainIfNotExists(realmConfig.getAdminUserName());
                Arrays.sort(roles);
                boolean isRoleHasAdminPermission = false;
                String[] stringArray = roles;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String role = stringArray[i];
                    isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(role, PERMISSION, "ui.execute");
                    if (!isRoleHasAdminPermission) {
                        isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(role, PERMISSION_ADMIN, "ui.execute");
                    }
                    if (isRoleHasAdminPermission) break;
                }
                if (isRoleHasAdminPermission && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to assign user " + userName + " to a role which has admin permission by user : " + loggedInUserName));
                    throw new UserStoreException("You do not have the required privilege to assign a user to a role which has admin permission.");
                }
            }
            org.wso2.carbon.user.core.UserStoreManager admin = this.realm.getUserStoreManager();
            HashMap<String, String> claimMap = new HashMap<String, String>();
            if (claims != null) {
                for (ClaimValue claimValue : claims) {
                    claimMap.put(claimValue.getClaimURI(), claimValue.getValue());
                }
            }
            admin.addUser(userName, (Object)password, roles, claimMap, profileName, false);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void changePassword(String userName, String newPassword) throws UserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            if (loggedInUserName != null && loggedInUserName.equalsIgnoreCase(userName)) {
                log.warn((Object)("An attempt to change password with out providing old password : " + loggedInUserName));
                throw new UserStoreException("An attempt to change password with out providing old password");
            }
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (loggedInUserName != null) {
                loggedInUserName = this.addPrimaryDomainIfNotExists(loggedInUserName);
            }
            String adminUser = this.addPrimaryDomainIfNotExists(realmConfig.getAdminUserName());
            if (realmConfig.getAdminUserName().equalsIgnoreCase(userName) && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to change password of admin user by user : " + loggedInUserName));
                throw new UserStoreException("You do not have the required privilege to change the password of admin user");
            }
            if (userName != null) {
                boolean isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, PERMISSION, "ui.execute");
                if (!isUserHadAdminPermission) {
                    isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, PERMISSION_ADMIN, "ui.execute");
                }
                if (isUserHadAdminPermission && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to change password of user has admin permission by user : " + loggedInUserName));
                    throw new UserStoreException("You do not have the required privilege to change the password of a user with admin permission");
                }
            }
            this.realm.getUserStoreManager().updateCredentialByAdmin(userName, (Object)newPassword);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName, Registry registry) throws UserAdminException {
        try {
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            String adminUser = this.addPrimaryDomainIfNotExists(realmConfig.getAdminUserName());
            if (realmConfig.getAdminUserName().equalsIgnoreCase(userName) && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to delete the admin user by user : " + loggedInUserName));
                throw new UserStoreException("You do not have the required privilege to delete the admin user");
            }
            if (userName != null) {
                boolean isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, PERMISSION, "ui.execute");
                if (!isUserHadAdminPermission) {
                    isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, PERMISSION_ADMIN, "ui.execute");
                }
                if (isUserHadAdminPermission && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to delete a user who has admin permission by user : " + loggedInUserName));
                    throw new UserStoreException("You do not have the required privilege to delete a user who has admin permission");
                }
            }
            this.realm.getUserStoreManager().deleteUser(userName);
            String path = "/users/" + userName;
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error deleting user from registry " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UserAdminException(msg, e);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void addRole(String roleName, String[] userList, String[] permissions, boolean isSharedRole) throws UserAdminException {
        try {
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            String adminUserName = this.addPrimaryDomainIfNotExists(this.realm.getRealmConfiguration().getAdminUserName());
            if (permissions != null && !adminUserName.equalsIgnoreCase(loggedInUserName)) {
                Arrays.sort(permissions);
                if (Arrays.binarySearch(permissions, PERMISSION_ADMIN) > -1 || Arrays.binarySearch(permissions, "/permission/admin/") > -1 || Arrays.binarySearch(permissions, PERMISSION) > -1 || Arrays.binarySearch(permissions, PERMISSION_TREE) > -1 || Arrays.binarySearch(permissions, PERMISSION_PROTECTED) > -1 || Arrays.binarySearch(permissions, "/permission/protected/") > -1) {
                    log.warn((Object)("An attempt to create a role with admin permission by user " + loggedInUserName));
                    throw new UserStoreException("You do not have the required privilege to create a role with admin permission");
                }
            }
            org.wso2.carbon.user.core.UserStoreManager usAdmin = this.realm.getUserStoreManager();
            org.wso2.carbon.user.core.UserStoreManager secManager = null;
            secManager = roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR) ? usAdmin.getSecondaryUserStoreManager(roleName.substring(0, roleName.indexOf(UserCoreConstants.DOMAIN_SEPARATOR))) : usAdmin;
            if (secManager == null) {
                throw new UserAdminException("Invalid Domain");
            }
            if (secManager.isReadOnly() || FALSE.equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                throw new UserAdminException("Read only user store or Role creation is disabled");
            }
            usAdmin.addRole(roleName, userList, ManagementPermissionUtil.getRoleUIPermissions(roleName, permissions), isSharedRole);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void addInternalRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        try {
            org.wso2.carbon.user.core.UserStoreManager usAdmin;
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            String adminUser = this.addPrimaryDomainIfNotExists(this.realm.getRealmConfiguration().getAdminUserName());
            if (permissions != null && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                Arrays.sort(permissions);
                if (Arrays.binarySearch(permissions, PERMISSION_ADMIN) > -1 || Arrays.binarySearch(permissions, "/permission/admin/") > -1 || Arrays.binarySearch(permissions, PERMISSION) > -1 || Arrays.binarySearch(permissions, PERMISSION_TREE) > -1 || Arrays.binarySearch(permissions, PERMISSION_PROTECTED) > -1 || Arrays.binarySearch(permissions, "/permission/protected/") > -1) {
                    log.warn((Object)("An attempt to create a role with admin permission by user " + loggedInUserName));
                    throw new UserStoreException("You do not have the required privilege to create a role with admin permission");
                }
            }
            if ((usAdmin = this.realm.getUserStoreManager()) instanceof AbstractUserStoreManager) {
                if (roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR) && "Application".equals(roleName.substring(0, roleName.indexOf(UserCoreConstants.DOMAIN_SEPARATOR)))) {
                    usAdmin.addRole(roleName, userList, null, false);
                } else if (roleName.startsWith("Internal" + UserCoreConstants.DOMAIN_SEPARATOR)) {
                    usAdmin.addRole(roleName, userList, null, false);
                } else {
                    usAdmin.addRole("Internal" + UserCoreConstants.DOMAIN_SEPARATOR + roleName, userList, null, false);
                }
            } else {
                throw new UserStoreException("Internal role can not be created");
            }
            if (roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR) && "Application".equals(roleName.substring(0, roleName.indexOf(UserCoreConstants.DOMAIN_SEPARATOR)))) {
                ManagementPermissionUtil.updateRoleUIPermission(roleName, permissions);
            } else {
                ManagementPermissionUtil.updateRoleUIPermission("Internal" + UserCoreConstants.DOMAIN_SEPARATOR + roleName, permissions);
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        try {
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            String adminUser = this.addPrimaryDomainIfNotExists(this.realm.getRealmConfiguration().getAdminUserName());
            String roleWithoutDN = roleName.split("@")[0];
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleWithoutDN, PERMISSION, "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleWithoutDN, PERMISSION_ADMIN, "ui.execute");
            }
            if (isRoleHasAdminPermission && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to rename a role with admin permission by user " + loggedInUserName));
                throw new UserStoreException("You do not have the required privilege to rename a role with admin permission");
            }
            org.wso2.carbon.user.core.UserStoreManager usAdmin = this.realm.getUserStoreManager();
            usAdmin.updateRoleName(roleName, newRoleName);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteRole(String roleName) throws UserAdminException {
        try {
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            String adminUser = this.addPrimaryDomainIfNotExists(this.realm.getRealmConfiguration().getAdminUserName());
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION, "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION_ADMIN, "ui.execute");
            }
            if (isRoleHasAdminPermission && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to delete a role with admin permission by user " + loggedInUserName));
                throw new UserStoreException("You do not have the required privilege to delete a role with admin permission");
            }
            this.realm.getUserStoreManager().deleteRole(roleName);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter, int limit) throws UserAdminException {
        try {
            Object flaggedNames;
            Object[] usersOfRole;
            String domain;
            int index = roleName != null ? roleName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) : -1;
            boolean domainProvided = index > 0;
            String string = domain = domainProvided ? roleName.substring(0, index) : null;
            if (!(domain == null || filter == null || filter.toLowerCase().startsWith(domain.toLowerCase()) || "Internal".equalsIgnoreCase(domain) || "Application".equalsIgnoreCase(domain))) {
                filter = domain + CarbonConstants.DOMAIN_SEPARATOR + filter;
            }
            org.wso2.carbon.user.core.UserStoreManager usMan = this.realm.getUserStoreManager();
            boolean canLimitAndFilterUsersFromUMLevel = this.canLimitAndFilterUsersFromUMLevel(roleName, usMan);
            if (domain == null && limit != 0) {
                filter = filter != null ? CarbonConstants.DOMAIN_SEPARATOR + filter : "/*";
            }
            if (canLimitAndFilterUsersFromUMLevel) {
                int userCountLimit = this.getUserCountLimit(limit);
                String domainFreeFilter = this.getDomainFreeFilter(filter);
                AbstractUserStoreManager abstractUsMan = (AbstractUserStoreManager)usMan;
                usersOfRole = abstractUsMan.getUserListOfRole(roleName, domainFreeFilter, userCountLimit);
            } else {
                usersOfRole = usMan.getUserListOfRole(roleName);
            }
            Arrays.sort(usersOfRole);
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            if (limit == 0) {
                filter = filter.replace("*", ".*");
                Pattern pattern = Pattern.compile(filter, 2);
                flaggedNames = new ArrayList();
                for (Object anUsersOfRole : usersOfRole) {
                    int combinerIndex = ((String)anUsersOfRole).indexOf("$_USERNAME_SEPARATOR_$");
                    Matcher matcher = combinerIndex > 0 ? pattern.matcher(((String)anUsersOfRole).substring(combinerIndex + "$_USERNAME_SEPARATOR_$".length())) : pattern.matcher((CharSequence)anUsersOfRole);
                    if (!matcher.matches()) continue;
                    FlaggedName fName = new FlaggedName();
                    fName.setSelected(true);
                    if (combinerIndex > 0) {
                        fName.setItemName(((String)anUsersOfRole).substring(0, combinerIndex));
                        fName.setItemDisplayName(((String)anUsersOfRole).substring(combinerIndex + "$_USERNAME_SEPARATOR_$".length()));
                    } else {
                        fName.setItemName((String)anUsersOfRole);
                        fName.setItemDisplayName((String)anUsersOfRole);
                    }
                    if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                        if (usMan.getSecondaryUserStoreManager(domain) != null && (usMan.getSecondaryUserStoreManager(domain).isReadOnly() || FALSE.equals(usMan.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                            fName.setEditable(false);
                        } else {
                            fName.setEditable(true);
                        }
                    } else if (usMan.isReadOnly() || usMan.getSecondaryUserStoreManager(domain) != null && FALSE.equals(usMan.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                    if (domain != null) {
                        if (userCount.containsKey(domain)) {
                            userCount.put(domain, (Integer)userCount.get(domain) + 1);
                        } else {
                            userCount.put(domain, 1);
                        }
                    } else if (userCount.containsKey("PRIMARY")) {
                        userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                    } else {
                        userCount.put("PRIMARY", 1);
                    }
                    flaggedNames.add(fName);
                }
                String exceededDomains = "";
                boolean isPrimaryExceeding = false;
                Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxUserNameListLength");
                String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
                for (int i = 0; i < domains.length; ++i) {
                    if ("PRIMARY".equals(domains[i])) {
                        if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                        isPrimaryExceeding = true;
                        continue;
                    }
                    if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                    exceededDomains = exceededDomains + domains[i];
                    if (i == domains.length - 1) continue;
                    exceededDomains = exceededDomains + ":";
                }
                FlaggedName flaggedName = new FlaggedName();
                if (isPrimaryExceeding) {
                    flaggedName.setItemName("true");
                } else {
                    flaggedName.setItemName(FALSE);
                }
                flaggedName.setItemDisplayName(exceededDomains);
                flaggedNames.add(flaggedName);
                return flaggedNames.toArray(new FlaggedName[flaggedNames.size()]);
            }
            String[] userNames = usMan.listUsers(filter, limit);
            flaggedNames = new FlaggedName[userNames.length + 1];
            for (int i = 0; i < userNames.length; ++i) {
                int combinerIndex;
                FlaggedName fName = new FlaggedName();
                fName.setItemName(userNames[i]);
                if (Arrays.binarySearch(usersOfRole, userNames[i]) > -1) {
                    fName.setSelected(true);
                }
                if ((combinerIndex = userNames[i].indexOf("$_USERNAME_SEPARATOR_$")) > 0) {
                    fName.setItemName(userNames[i].substring(0, combinerIndex));
                    fName.setItemDisplayName(userNames[i].substring(combinerIndex + "$_USERNAME_SEPARATOR_$".length()));
                } else {
                    fName.setItemName(userNames[i]);
                }
                if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                    if (usMan.getSecondaryUserStoreManager(domain) != null && (usMan.getSecondaryUserStoreManager(domain).isReadOnly() || FALSE.equals(usMan.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                } else if (usMan.isReadOnly() || usMan.getSecondaryUserStoreManager(domain) != null && FALSE.equals(usMan.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                    fName.setEditable(false);
                } else {
                    fName.setEditable(true);
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                flaggedNames[i] = fName;
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxUserNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName(FALSE);
            }
            flaggedName.setItemDisplayName(exceededDomains);
            flaggedNames[((FlaggedName[])flaggedNames).length - 1] = flaggedName;
            return flaggedNames;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getRolesOfUser(String userName, String filter, int limit) throws UserAdminException {
        try {
            FlaggedName fname;
            String domain;
            int index = userName != null ? userName.indexOf(CarbonConstants.DOMAIN_SEPARATOR) : -1;
            boolean domainProvided = index > 0;
            String string = domain = domainProvided ? userName.substring(0, index) : null;
            if (filter == null) {
                filter = "*";
            }
            org.wso2.carbon.user.core.UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] userRoles = ((AbstractUserStoreManager)admin).getRoleListOfUser(userName);
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            userRoles = this.filterInternalSystemRoles((String[])userRoles);
            if (limit == 0) {
                String modifiedFilter = filter;
                if (filter.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                    modifiedFilter = filter.substring(filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR) + 1);
                }
                Object[] hybridRoles = ((AbstractUserStoreManager)admin).getHybridRoles(modifiedFilter);
                if ((hybridRoles = this.filterInternalSystemRoles((String[])hybridRoles)) != null) {
                    Arrays.sort(hybridRoles);
                }
                modifiedFilter = modifiedFilter.replace("*", ".*");
                Pattern pattern = Pattern.compile(modifiedFilter, 2);
                ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
                Object[] objectArray = userRoles;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Matcher matcher;
                    Object role;
                    Object matchingRole = role = objectArray[i];
                    String roleDomain = null;
                    if (((String)matchingRole).contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                        matchingRole = ((String)matchingRole).substring(((String)matchingRole).indexOf(CarbonConstants.DOMAIN_SEPARATOR) + 1);
                        if (filter.contains(CarbonConstants.DOMAIN_SEPARATOR)) {
                            roleDomain = ((String)role).substring(0, ((String)role).indexOf(CarbonConstants.DOMAIN_SEPARATOR) + 1);
                        }
                    }
                    if (hybridRoles != null && Arrays.binarySearch(hybridRoles, role) > -1 ? !(matcher = pattern.matcher((CharSequence)matchingRole)).matches() || roleDomain != null && !filter.toLowerCase().startsWith(roleDomain.toLowerCase()) : !(matcher = pattern.matcher((CharSequence)matchingRole)).matches() || roleDomain != null && !filter.toLowerCase().startsWith(roleDomain.toLowerCase())) continue;
                    FlaggedName fName = new FlaggedName();
                    this.mapEntityName((String)role, fName, admin);
                    fName.setSelected(true);
                    if (domain != null && !"Internal".equalsIgnoreCase(domain) && !"Application".equalsIgnoreCase(domain)) {
                        if ((admin.getSecondaryUserStoreManager(domain).isReadOnly() || admin.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups") != null && admin.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups").equals(FALSE)) && hybridRoles != null && Arrays.binarySearch(hybridRoles, role) < 0) {
                            fName.setEditable(false);
                        } else {
                            fName.setEditable(true);
                        }
                    } else if ((admin.isReadOnly() || admin.getRealmConfiguration().getUserStoreProperty("WriteGroups") != null && FALSE.equals(admin.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) && hybridRoles != null && Arrays.binarySearch(hybridRoles, role) < 0) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                    if (domain != null) {
                        if (userCount.containsKey(domain)) {
                            userCount.put(domain, (Integer)userCount.get(domain) + 1);
                        } else {
                            userCount.put(domain, 1);
                        }
                    } else if (userCount.containsKey("PRIMARY")) {
                        userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                    } else {
                        userCount.put("PRIMARY", 1);
                    }
                    flaggedNames.add(fName);
                }
                String exceededDomains = "";
                boolean isPrimaryExceeding = false;
                Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
                String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
                for (int i = 0; i < domains.length; ++i) {
                    if ("PRIMARY".equals(domains[i])) {
                        if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                        isPrimaryExceeding = true;
                        continue;
                    }
                    if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                    exceededDomains = exceededDomains + domains[i];
                    if (i == domains.length - 1) continue;
                    exceededDomains = exceededDomains + ":";
                }
                FlaggedName flaggedName = new FlaggedName();
                if (isPrimaryExceeding) {
                    flaggedName.setItemName("true");
                } else {
                    flaggedName.setItemName(FALSE);
                }
                flaggedName.setItemDisplayName(exceededDomains);
                flaggedNames.add(flaggedName);
                return flaggedNames.toArray(new FlaggedName[flaggedNames.size()]);
            }
            String[] internalRoles = null;
            String[] externalRoles = null;
            if (filter.toLowerCase().startsWith("Internal".toLowerCase())) {
                if (admin instanceof AbstractUserStoreManager) {
                    filter = filter.substring(filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR) + 1);
                    internalRoles = ((AbstractUserStoreManager)admin).getHybridRoles(filter);
                } else {
                    internalRoles = admin.getHybridRoles();
                }
            } else if (domain != null && filter.toLowerCase().startsWith(domain.toLowerCase() + CarbonConstants.DOMAIN_SEPARATOR)) {
                externalRoles = admin instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)admin).getRoleNames(filter, limit, true, true, true) : admin.getRoleNames();
            } else {
                internalRoles = admin instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)admin).getHybridRoles(filter) : admin.getHybridRoles();
                filter = domain == null ? CarbonConstants.DOMAIN_SEPARATOR + filter : domain + CarbonConstants.DOMAIN_SEPARATOR + filter;
                externalRoles = admin instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)admin).getRoleNames(filter, limit, true, true, true) : admin.getRoleNames();
            }
            internalRoles = this.filterInternalSystemRoles(internalRoles);
            ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
            Arrays.sort(userRoles);
            if (externalRoles != null) {
                for (String externalRole : externalRoles) {
                    fname = new FlaggedName();
                    this.mapEntityName(externalRole, fname, admin);
                    fname.setDomainName(domain);
                    if (Arrays.binarySearch(userRoles, externalRole) > -1) {
                        fname.setSelected(true);
                    }
                    if (domain != null) {
                        org.wso2.carbon.user.core.UserStoreManager secManager = admin.getSecondaryUserStoreManager(domain);
                        if (secManager.isReadOnly() || FALSE.equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                            fname.setEditable(false);
                        } else {
                            fname.setEditable(true);
                        }
                    } else if (admin.isReadOnly() || FALSE.equals(admin.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                        fname.setEditable(false);
                    } else {
                        fname.setEditable(true);
                    }
                    if (domain != null) {
                        if (userCount.containsKey(domain)) {
                            userCount.put(domain, (Integer)userCount.get(domain) + 1);
                        } else {
                            userCount.put(domain, 1);
                        }
                    } else if (userCount.containsKey("PRIMARY")) {
                        userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                    } else {
                        userCount.put("PRIMARY", 1);
                    }
                    flaggedNames.add(fname);
                }
            }
            if (internalRoles != null) {
                for (String internalRole : internalRoles) {
                    fname = new FlaggedName();
                    fname.setItemName(internalRole);
                    fname.setDomainName("Internal");
                    if (Arrays.binarySearch(userRoles, internalRole) > -1) {
                        fname.setSelected(true);
                    }
                    fname.setEditable(true);
                    flaggedNames.add(fname);
                }
            }
            Collections.sort(flaggedNames, new Comparator<FlaggedName>(){

                @Override
                public int compare(FlaggedName role1, FlaggedName role2) {
                    return role1.getItemName().compareToIgnoreCase(role2.getItemName());
                }
            });
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName(FALSE);
            }
            flaggedName.setItemDisplayName(exceededDomains);
            flaggedNames.add(flaggedName);
            return flaggedNames.toArray(new FlaggedName[flaggedNames.size()]);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        try {
            if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName)) {
                log.error((Object)"Security Alert! Carbon anonymous role is being manipulated");
                throw new UserStoreException("Invalid data");
            }
            if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase(roleName)) {
                log.error((Object)"Security Alert! Carbon Everyone role is being manipulated");
                throw new UserStoreException("Invalid data");
            }
            org.wso2.carbon.user.core.UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldUserList = admin.getUserListOfRole(roleName);
            ArrayList<Object> list = new ArrayList<Object>();
            if (oldUserList != null) {
                for (Object value : oldUserList) {
                    int combinerIndex = ((String)value).indexOf("$_USERNAME_SEPARATOR_$");
                    if (combinerIndex > 0) {
                        list.add(((String)value).substring(0, combinerIndex));
                        continue;
                    }
                    list.add(value);
                }
                oldUserList = list.toArray(new String[list.size()]);
            }
            if (oldUserList != null) {
                Arrays.sort(oldUserList);
            }
            ArrayList<String> delUsers = new ArrayList<String>();
            ArrayList<String> addUsers = new ArrayList<String>();
            for (FlaggedName fName : userList) {
                boolean isSelected = fName.isSelected();
                String userName = fName.getItemName();
                if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                    log.error((Object)"Security Alert! Carbon anonymous user is being manipulated");
                    return;
                }
                int oldindex = Arrays.binarySearch(oldUserList, userName);
                if (oldindex > -1 && !isSelected) {
                    delUsers.add(userName);
                    continue;
                }
                if (oldindex >= 0 || !isSelected) continue;
                addUsers.add(userName);
            }
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            String adminUser = this.addPrimaryDomainIfNotExists(realmConfig.getAdminUserName());
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION_TREE, "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin/", "ui.execute");
            }
            if ((realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) || isRoleHasAdminPermission) && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to add or remove users from Admin role by user : " + loggedInUserName));
                throw new UserStoreException("Can not add or remove user from Admin permission role");
            }
            Object[] delUsersArray = null;
            String[] addUsersArray = null;
            Object[] users = this.realm.getUserStoreManager().getUserListOfRole(roleName);
            if (delUsers != null && users != null) {
                Arrays.sort(users);
                delUsersArray = delUsers.toArray(new String[delUsers.size()]);
                Arrays.sort(delUsersArray);
                if (Arrays.binarySearch(delUsersArray, loggedInUserName) > -1 && Arrays.binarySearch(users, loggedInUserName) > -1 && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to remove from role : " + roleName + " by user :" + loggedInUserName));
                    throw new UserStoreException("Can not remove yourself from role : " + roleName);
                }
            }
            if (addUsers != null) {
                addUsersArray = addUsers.toArray(new String[addUsers.size()]);
            }
            admin.updateUserListOfRole(roleName, delUsersArray, addUsersArray);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRolesOfUser(String userName, String[] roleList) throws UserAdminException {
        try {
            if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                log.error((Object)"Security Alert! Carbon anonymous user is being manipulated");
                throw new UserAdminException("Invalid data");
            }
            if (roleList != null) {
                String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
                RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
                String adminUser = this.addPrimaryDomainIfNotExists(realmConfig.getAdminUserName());
                Arrays.sort(roleList);
                Object[] roles = this.realm.getUserStoreManager().getRoleListOfUser(userName);
                org.wso2.carbon.user.core.UserStoreManager admin = this.realm.getUserStoreManager();
                Object[] oldRoleList = admin.getRoleListOfUser(userName);
                Arrays.sort(oldRoleList);
                ArrayList<String> addRoles = new ArrayList<String>();
                ArrayList<Object> delRoles = new ArrayList<Object>();
                boolean isUserHasAdminPermission = false;
                String adminPermissionRole = null;
                if (roles != null) {
                    Arrays.sort(roles);
                    for (Object role : roles) {
                        isUserHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized((String)role, PERMISSION, "ui.execute");
                        if (!isUserHasAdminPermission) {
                            isUserHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized((String)role, PERMISSION_ADMIN, "ui.execute");
                        }
                        if (isUserHasAdminPermission) break;
                    }
                }
                for (String string : roleList) {
                    boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(string, PERMISSION, "ui.execute");
                    if (!isRoleHasAdminPermission) {
                        isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(string, PERMISSION_ADMIN, "ui.execute");
                    }
                    if (!isRoleHasAdminPermission) continue;
                    adminPermissionRole = string;
                    break;
                }
                if (roles == null || Arrays.binarySearch(roles, realmConfig.getAdminRoleName()) < 0) {
                    if ((Arrays.binarySearch(roleList, realmConfig.getAdminRoleName()) > -1 || !isUserHasAdminPermission && adminPermissionRole != null) && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                        log.warn((Object)("An attempt to add users to Admin permission role by user : " + loggedInUserName));
                        throw new UserStoreException("Can not add users to Admin permission role");
                    }
                } else if (Arrays.binarySearch(roleList, realmConfig.getAdminRoleName()) < 0 && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to remove users from Admin role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not remove users from Admin role");
                }
                for (String string : roleList) {
                    int oldindex = Arrays.binarySearch(oldRoleList, string);
                    if (oldindex >= 0) continue;
                    addRoles.add(string);
                }
                for (Object object : oldRoleList) {
                    int newindex = Arrays.binarySearch(roleList, object);
                    if (newindex >= 0) continue;
                    if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase((String)object)) {
                        log.warn((Object)"Carbon Internal/everyone role can't be manipulated");
                        continue;
                    }
                    delRoles.add(object);
                }
                admin.updateRoleListOfUser(userName, delRoles.toArray(new String[delRoles.size()]), addRoles.toArray(new String[addRoles.size()]));
            }
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateUsersOfRole(String roleName, String[] newUsers, String[] deleteUsers) throws UserAdminException {
        try {
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName)) {
                log.error((Object)("Security Alert! Carbon anonymous role is being manipulated by user " + loggedInUserName));
                throw new UserStoreException("Invalid data");
            }
            if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase(roleName)) {
                log.error((Object)("Security Alert! Carbon Everyone role is being manipulated by user " + loggedInUserName));
                throw new UserStoreException("Invalid data");
            }
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION_TREE, "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin/", "ui.execute");
            }
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            String adminUser = this.addPrimaryDomainIfNotExists(realmConfig.getAdminUserName());
            if ((realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) || isRoleHasAdminPermission) && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to add or remove users from a admin role by user : " + loggedInUserName));
                throw new UserStoreException("You do not have the required privilege to add or remove user from a admin role");
            }
            if (deleteUsers != null) {
                Arrays.sort(deleteUsers);
                if (realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) && Arrays.binarySearch(deleteUsers, realmConfig.getAdminUserName()) > -1) {
                    log.warn((Object)("An attempt to remove Admin user from Admin role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not remove Admin user from Admin role");
                }
            }
            org.wso2.carbon.user.core.UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldUserList = admin.getUserListOfRole(roleName);
            ArrayList<String> list = new ArrayList<String>();
            if (oldUserList != null) {
                for (String string : oldUserList) {
                    int combinerIndex = string.indexOf("$_USERNAME_SEPARATOR_$");
                    if (combinerIndex > 0) {
                        list.add(string.substring(0, combinerIndex));
                        continue;
                    }
                    list.add(string);
                }
                oldUserList = list.toArray(new String[list.size()]);
                Arrays.sort(oldUserList);
            }
            ArrayList<String> delUser = new ArrayList<String>();
            ArrayList<String> addUsers = new ArrayList<String>();
            if (oldUserList != null) {
                if (newUsers != null) {
                    String[] stringArray = newUsers;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String name = stringArray[i];
                        if (Arrays.binarySearch(oldUserList, name) >= 0) continue;
                        addUsers.add(name);
                    }
                    newUsers = addUsers.toArray(new String[addUsers.size()]);
                }
                if (deleteUsers != null) {
                    for (String name : deleteUsers) {
                        if (Arrays.binarySearch(oldUserList, name) <= -1) continue;
                        delUser.add(name);
                    }
                    deleteUsers = delUser.toArray(new String[delUser.size()]);
                }
            } else {
                deleteUsers = null;
            }
            admin.updateUserListOfRole(roleName, deleteUsers, newUsers);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRolesOfUser(String userName, String[] newRoles, String[] deletedRoles) throws UserAdminException {
        try {
            RealmConfiguration realmConfig;
            String adminUser;
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                log.error((Object)("Security Alert! Carbon anonymous user is being manipulated by user " + loggedInUserName));
                throw new UserAdminException("Invalid data");
            }
            if (deletedRoles != null) {
                for (String name : deletedRoles) {
                    if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase(name)) {
                        log.error((Object)("Security Alert! Carbon everyone role is being manipulated by user " + loggedInUserName));
                        throw new UserAdminException("Invalid data");
                    }
                    if (!this.realm.getRealmConfiguration().getAdminRoleName().equalsIgnoreCase(name) || !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(userName)) continue;
                    log.error((Object)("Can not remove admin user from admin role " + loggedInUserName));
                    throw new UserAdminException("Can not remove admin user from admin role");
                }
            }
            if (!(adminUser = this.addPrimaryDomainIfNotExists((realmConfig = this.realm.getRealmConfiguration()).getAdminUserName())).equalsIgnoreCase(loggedInUserName)) {
                boolean isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, PERMISSION, "ui.execute");
                if (!isUserHadAdminPermission) {
                    isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, PERMISSION_ADMIN, "ui.execute");
                }
                if (newRoles != null) {
                    boolean isRoleHasAdminPermission = false;
                    for (String roleName : newRoles) {
                        if (roleName.equalsIgnoreCase(realmConfig.getAdminRoleName())) {
                            log.warn((Object)("An attempt to add users to Admin permission role by user : " + loggedInUserName));
                            throw new UserStoreException("Can not add users to Admin permission role");
                        }
                        isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION, "ui.execute");
                        if (!isRoleHasAdminPermission) {
                            isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION_ADMIN, "ui.execute");
                        }
                        if (isRoleHasAdminPermission) break;
                    }
                    if (!isUserHadAdminPermission && isRoleHasAdminPermission) {
                        log.warn((Object)("An attempt to add users to Admin permission role by user : " + loggedInUserName));
                        throw new UserStoreException("Can not add users to Admin permission role");
                    }
                }
                if (deletedRoles != null) {
                    boolean isRemoveRoleHasAdminPermission = false;
                    for (String roleName : deletedRoles) {
                        isRemoveRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION, "ui.execute");
                        if (!isRemoveRoleHasAdminPermission) {
                            isRemoveRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, PERMISSION_ADMIN, "ui.execute");
                        }
                        if (isRemoveRoleHasAdminPermission) break;
                    }
                    if (isUserHadAdminPermission && isRemoveRoleHasAdminPermission) {
                        log.warn((Object)("An attempt to remove users from Admin role by user : " + loggedInUserName));
                        throw new UserStoreException("Can not remove users from Admin role");
                    }
                }
            }
            this.realm.getUserStoreManager().updateRoleListOfUser(userName, deletedRoles, newRoles);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getAllUIPermissions(int tenantId) throws UserAdminException {
        Collection parent = null;
        UserRegistry tenentRegistry = null;
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            UserRegistry registry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry();
            if (tenantId == -1234) {
                if (CarbonContext.getThreadLocalCarbonContext().getTenantId() != -1234) {
                    log.error((Object)"Illegal access attempt");
                    throw new UserStoreException("Illegal access attempt");
                }
                regRoot = (Collection)registry.get(PERMISSION_TREE);
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode(PERMISSION_TREE, displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                tenentRegistry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
                if (tenentRegistry.resourceExists(APPLICATIONS_PATH)) {
                    Collection appRoot = (Collection)tenentRegistry.get(APPLICATIONS_PATH);
                    parent = (Collection)tenentRegistry.newCollection();
                    parent.setProperty("name", "All Permissions");
                    parent.setChildren(new String[]{regRoot.getPath(), appRoot.getPath()});
                }
                String displayName = null;
                displayName = parent != null ? parent.getProperty("name") : regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            if (parent != null) {
                this.buildUIPermissionNode(parent, nodeRoot, (Registry)registry, (Registry)tenentRegistry, null, null, null);
            } else {
                this.buildUIPermissionNode(regRoot, nodeRoot, (Registry)registry, (Registry)tenentRegistry, null, null, null);
            }
            return nodeRoot;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getRolePermissions(String roleName, int tenantId) throws UserAdminException {
        Collection parent = null;
        UserRegistry tenentRegistry = null;
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            UserRegistry registry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry();
            if (tenantId == -1234) {
                regRoot = (Collection)registry.get(PERMISSION_TREE);
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode(PERMISSION_TREE, displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                tenentRegistry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
                if (tenentRegistry.resourceExists(APPLICATIONS_PATH)) {
                    Collection appRoot = (Collection)tenentRegistry.get(APPLICATIONS_PATH);
                    parent = (Collection)tenentRegistry.newCollection();
                    parent.setProperty("name", "All Permissions");
                    parent.setChildren(new String[]{regRoot.getPath(), appRoot.getPath()});
                }
                String displayName = null;
                displayName = parent != null ? parent.getProperty("name") : regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            if (parent != null) {
                this.buildUIPermissionNode(parent, nodeRoot, (Registry)registry, (Registry)tenentRegistry, this.realm.getAuthorizationManager(), roleName, null);
            } else {
                this.buildUIPermissionNode(regRoot, nodeRoot, (Registry)registry, (Registry)tenentRegistry, this.realm.getAuthorizationManager(), roleName, null);
            }
            return nodeRoot;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        Permission[] permissions = null;
        org.wso2.carbon.user.core.UserStoreManager userStoreManager = null;
        try {
            if (((AbstractUserStoreManager)this.realm.getUserStoreManager()).isOthersSharedRole(roleName)) {
                throw new UserAdminException("Logged in user is not authorized to assign permissions to a role belong to another tenant");
            }
            if (this.realm.getRealmConfiguration().getAdminRoleName().equalsIgnoreCase(roleName)) {
                String msg = "UI permissions of Admin is not allowed to change";
                log.error((Object)msg);
                throw new UserAdminException(msg);
            }
            String loggedInUserName = this.addPrimaryDomainIfNotExists(this.getLoggedInUser());
            String adminUser = this.addPrimaryDomainIfNotExists(this.realm.getRealmConfiguration().getAdminUserName());
            if (rawResources != null && !adminUser.equalsIgnoreCase(loggedInUserName)) {
                Arrays.sort(rawResources);
                if (Arrays.binarySearch(rawResources, PERMISSION_ADMIN) > -1 || Arrays.binarySearch(rawResources, PERMISSION_PROTECTED) > -1 || Arrays.binarySearch(rawResources, PERMISSION) > -1 || Arrays.binarySearch(rawResources, PERMISSION_TREE) > -1) {
                    log.warn((Object)("An attempt to Assign admin permission for role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not assign Admin for permission role");
                }
            }
            String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawResources);
            AuthorizationManager authMan = this.realm.getAuthorizationManager();
            authMan.clearRoleActionOnAllResources(roleName, "ui.execute");
            permissions = new Permission[optimizedList.length];
            for (int i = 0; i < optimizedList.length; ++i) {
                authMan.authorizeRole(roleName, optimizedList[i], "ui.execute");
                permissions[i] = new Permission(optimizedList[i], "ui.execute");
            }
            userStoreManager = this.realm.getUserStoreManager();
            ManagementPermissionUtil.handlePostUpdatePermissionsOfRole(roleName, permissions, userStoreManager);
        }
        catch (UserStoreException e) {
            ManagementPermissionUtil.handleOnUpdatePermissionsOfRoleFailure(e.getMessage(), roleName, permissions, userStoreManager);
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void bulkImportUsers(String userStoreDomain, String fileName, InputStream inStream, String defaultPassword) throws UserAdminException {
        block6: {
            try {
                BulkImportConfig config = new BulkImportConfig(inStream, fileName);
                if (defaultPassword != null && defaultPassword.trim().length() > 0) {
                    config.setDefaultPassword(defaultPassword.trim());
                }
                if (StringUtils.isNotEmpty((String)userStoreDomain)) {
                    config.setUserStoreDomain(userStoreDomain);
                }
                org.wso2.carbon.user.core.UserStoreManager userStore = this.realm.getUserStoreManager();
                userStore = userStore.getSecondaryUserStoreManager(userStoreDomain);
                if (fileName.endsWith("csv")) {
                    CSVUserBulkImport csvAdder = new CSVUserBulkImport(config);
                    ((UserBulkImport)csvAdder).addUserList(userStore);
                    break block6;
                }
                if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
                    ExcelUserBulkImport excelAdder = new ExcelUserBulkImport(config);
                    ((UserBulkImport)excelAdder).addUserList(userStore);
                    break block6;
                }
                throw new UserAdminException("Unsupported format");
            }
            catch (UserStoreException e) {
                throw new UserAdminException(e.getMessage(), e);
            }
        }
    }

    public void changePasswordByUser(String userName, String oldPassword, String newPassword) throws UserAdminException {
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
            RealmService realmService = UserMgtDSComponent.getRealmService();
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            UserRealm userRealm = realmService.getTenantUserRealm(tenantId);
            UserStoreManager userStore = userRealm.getUserStoreManager();
            userStore.updateCredential(tenantAwareUsername, (Object)newPassword, (Object)oldPassword);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)"Error while getting tenant user realm", (Throwable)e);
            throw new UserAdminException("Error while getting tenant user realm", e);
        }
    }

    public boolean hasMultipleUserStores() throws UserAdminException {
        try {
            return this.realm.getUserStoreManager().getSecondaryUserStoreManager() != null;
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            throw new UserAdminException("Unable to check for multiple user stores");
        }
    }

    private void buildUIPermissionNode(Collection parent, UIPermissionNode parentNode, Registry registry, Registry tenantRegistry, AuthorizationManager authMan, String roleName, String userName) throws RegistryException, UserStoreException {
        boolean isSelected = false;
        if (roleName != null) {
            isSelected = authMan.isRoleAuthorized(roleName, parentNode.getResourcePath(), "ui.execute");
        } else if (userName != null) {
            isSelected = authMan.isUserAuthorized(userName, parentNode.getResourcePath(), "ui.execute");
        }
        if (isSelected) {
            this.buildUIPermissionNodeAllSelected(parent, parentNode, registry, tenantRegistry);
            parentNode.setSelected(true);
        } else {
            this.buildUIPermissionNodeNotAllSelected(parent, parentNode, registry, tenantRegistry, authMan, roleName, userName);
        }
    }

    private void buildUIPermissionNodeAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry, Registry tenantRegistry) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            String child = children[i];
            Resource resource = null;
            if (registry.resourceExists(child)) {
                resource = registry.get(child);
            } else if (tenantRegistry != null) {
                resource = tenantRegistry.get(child);
            } else {
                throw new RegistryException("Permission resource not found in the registry.");
            }
            childNodes[i] = this.getUIPermissionNode(resource, true);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeAllSelected((Collection)resource, childNodes[i], registry, tenantRegistry);
        }
        parentNode.setNodeList(childNodes);
    }

    private void buildUIPermissionNodeNotAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry, Registry tenantRegistry, AuthorizationManager authMan, String roleName, String userName) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            String child = children[i];
            Resource resource = null;
            if (tenantRegistry != null && child.startsWith(APPLICATIONS_PATH)) {
                resource = tenantRegistry.get(child);
            } else if (registry.resourceExists(child)) {
                resource = registry.get(child);
            } else {
                throw new RegistryException("Permission resource not found in the registry.");
            }
            boolean isSelected = false;
            if (roleName != null) {
                isSelected = authMan.isRoleAuthorized(roleName, child, "ui.execute");
            } else if (userName != null) {
                isSelected = authMan.isUserAuthorized(userName, child, "ui.execute");
            }
            childNodes[i] = this.getUIPermissionNode(resource, isSelected);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeNotAllSelected((Collection)resource, childNodes[i], registry, tenantRegistry, authMan, roleName, userName);
        }
        parentNode.setNodeList(childNodes);
    }

    private UIPermissionNode getUIPermissionNode(Resource resource, boolean isSelected) throws RegistryException {
        String displayName = resource.getProperty("name");
        return new UIPermissionNode(resource.getPath(), displayName, isSelected);
    }

    private String getLoggedInUser() {
        return CarbonContext.getThreadLocalCarbonContext().getUsername();
    }

    private void mapEntityName(String entityName, FlaggedName fName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) {
        if (entityName.contains("@SharedRoleSeperator@")) {
            String[] nameAndDn = entityName.split("@SharedRoleSeperator@");
            fName.setItemName(nameAndDn[0]);
            fName.setDn(nameAndDn[1]);
            fName.setShared(((AbstractUserStoreManager)userStoreManager).isOthersSharedRole(entityName));
            if (fName.isShared()) {
                fName.setItemDisplayName("@SharedRoleSeperator@" + fName.getItemName());
            }
        } else {
            fName.setItemName(entityName);
        }
    }

    public boolean isSharedRolesEnabled() throws UserAdminException {
        try {
            org.wso2.carbon.user.core.UserStoreManager userManager = this.realm.getUserStoreManager();
            return ((AbstractUserStoreManager)userManager).isSharedGroupEnabled();
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            throw new UserAdminException("Unable to check shared role enabled", e);
        }
    }

    public String[] concatArrays(String[] o1, String[] o2) {
        String[] ret = new String[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    private boolean canLimitAndFilterUsersFromUMLevel(String roleName, org.wso2.carbon.user.core.UserStoreManager userStoreManager) {
        boolean canLimitAndFilterWithUM = false;
        int domainSeparatorIndex = roleName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (domainSeparatorIndex > 0) {
            String domainInRole = roleName.substring(0, domainSeparatorIndex);
            org.wso2.carbon.user.core.UserStoreManager secondaryUserStoreManager = userStoreManager.getSecondaryUserStoreManager(domainInRole);
            if (secondaryUserStoreManager != null) {
                canLimitAndFilterWithUM = secondaryUserStoreManager instanceof JDBCUserStoreManager;
            }
        } else {
            canLimitAndFilterWithUM = userStoreManager instanceof JDBCUserStoreManager;
        }
        return canLimitAndFilterWithUM;
    }

    private String getDomainFreeFilter(String filter) {
        String domainFreeFilter = filter;
        int domainSeparatorIndex = filter.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (!CarbonConstants.DOMAIN_SEPARATOR.equalsIgnoreCase(filter) && domainSeparatorIndex >= 0) {
            domainFreeFilter = filter.substring(domainSeparatorIndex + 1);
        }
        return domainFreeFilter;
    }

    private int getUserCountLimit(int limit) {
        int userCountLimit = limit;
        if (limit == 0) {
            userCountLimit = -1;
        }
        return userCountLimit;
    }

    public UIPermissionNode getRolePermissions(List<String> roleNames, int tenantId) throws UserAdminException {
        Collection parent = null;
        UserRegistry tenantRegistry = null;
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            UserRegistry registry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry();
            if (tenantId == -1234) {
                regRoot = (Collection)registry.get(PERMISSION_TREE);
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode(PERMISSION_TREE, displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                tenantRegistry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
                if (tenantRegistry.resourceExists(APPLICATIONS_PATH)) {
                    Collection appRoot = (Collection)tenantRegistry.get(APPLICATIONS_PATH);
                    parent = (Collection)tenantRegistry.newCollection();
                    parent.setProperty("name", "All Permissions");
                    parent.setChildren(new String[]{regRoot.getPath(), appRoot.getPath()});
                }
                String displayName = parent != null ? parent.getProperty("name") : regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            if (parent != null) {
                this.buildUIPermissionNode(parent, nodeRoot, (Registry)registry, (Registry)tenantRegistry, this.realm.getAuthorizationManager(), roleNames);
            } else {
                this.buildUIPermissionNode(regRoot, nodeRoot, (Registry)registry, (Registry)tenantRegistry, this.realm.getAuthorizationManager(), roleNames);
            }
            return nodeRoot;
        }
        catch (RegistryException | UserStoreException e) {
            log.error((Object)e.getMessage(), e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private void buildUIPermissionNode(Collection parent, UIPermissionNode parentNode, Registry registry, Registry tenantRegistry, AuthorizationManager authMan, List<String> roleNames) throws RegistryException, UserStoreException {
        boolean isSelected = false;
        for (String roleName : roleNames) {
            if (!StringUtils.isNotBlank((String)roleName) || !authMan.isRoleAuthorized(roleName, parentNode.getResourcePath(), "ui.execute")) continue;
            isSelected = true;
            break;
        }
        if (isSelected) {
            this.buildUIPermissionNodeAllSelected(parent, parentNode, registry, tenantRegistry);
            parentNode.setSelected(true);
        } else {
            this.buildUIPermissionNodeNotAllSelected(parent, parentNode, registry, tenantRegistry, authMan, roleNames);
        }
    }

    private void buildUIPermissionNodeNotAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry, Registry tenantRegistry, AuthorizationManager authMan, List<String> roleNames) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            Resource resource;
            String child = children[i];
            if (tenantRegistry != null && child.startsWith(APPLICATIONS_PATH)) {
                resource = tenantRegistry.get(child);
            } else if (registry.resourceExists(child)) {
                resource = registry.get(child);
            } else {
                throw new RegistryException("Permission resource not found in the registry.");
            }
            boolean isSelected = false;
            for (String roleName : roleNames) {
                if (!StringUtils.isNotBlank((String)roleName) || !authMan.isRoleAuthorized(roleName, child, "ui.execute")) continue;
                isSelected = true;
                break;
            }
            childNodes[i] = this.getUIPermissionNode(resource, isSelected);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeNotAllSelected((Collection)resource, childNodes[i], registry, tenantRegistry, authMan, roleNames);
        }
        parentNode.setNodeList(childNodes);
    }

    public List<String> getHybridRoleListOfGroup(String groupName, String domainName) throws UserAdminException {
        try {
            return ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getHybridRoleListOfGroup(groupName, domainName);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public boolean isExistingHybridRole(String roleName) throws UserAdminException {
        try {
            return ((AbstractUserStoreManager)this.realm.getUserStoreManager()).isExistingHybridRole(roleName);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateGroupListOfHybridRole(String roleName, String[] deletedGroups, String[] newGroups) throws UserAdminException {
        try {
            ((AbstractUserStoreManager)this.realm.getUserStoreManager()).updateGroupListOfHybridRole(roleName, deletedGroups, newGroups);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public boolean isRoleAndGroupSeparationEnabled() throws UserAdminException {
        try {
            return ((AbstractUserStoreManager)this.realm.getUserStoreManager()).isRoleAndGroupSeparationEnabled();
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private class ClaimMappingsComparator
    implements Comparator<ClaimMapping> {
        private ClaimMappingsComparator() {
        }

        @Override
        public int compare(ClaimMapping o1, ClaimMapping o2) {
            return o1.getClaim().getClaimUri().compareTo(o2.getClaim().getClaimUri());
        }
    }
}

