/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.UserRealmProxy;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserRealmInfo;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserAdmin {
    private static final Log log = LogFactory.getLog(UserAdmin.class);

    public String[] listUsers(String filter, int limit) throws UserAdminException {
        String[] users = this.getUserAdminProxy().listUsers(filter, limit);
        return users;
    }

    public FlaggedName[] listAllUsers(String filter, int limit) throws UserAdminException {
        FlaggedName[] names = this.getUserAdminProxy().listAllUsers(filter, limit);
        return names;
    }

    public FlaggedName[] listAllUsersWithPermission(String filter, String permission, int limit) throws UserAdminException {
        ArrayList<FlaggedName> permittedUsers = new ArrayList<FlaggedName>();
        try {
            UserRealm realm = UserMgtDSComponent.getRealmService().getTenantUserRealm(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            AuthorizationManager authorizationManager = realm.getAuthorizationManager();
            FlaggedName[] users = this.getUserAdminProxy().listAllUsers(filter, limit);
            for (int i = 0; i < users.length - 1; ++i) {
                if (!authorizationManager.isUserAuthorized(users[i].getItemName(), permission, "ui.execute")) continue;
                permittedUsers.add(users[i]);
            }
            permittedUsers.add(users[users.length - 1]);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserAdminException("Error while filtering authorized users.", e);
        }
        FlaggedName[] permittedUsersArray = new FlaggedName[permittedUsers.size()];
        return permittedUsers.toArray(permittedUsersArray);
    }

    public FlaggedName[] getAllRolesNames(String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getAllRolesNames(filter, limit);
    }

    public FlaggedName[] getAllPermittedRoleNames(String filter, String permission, int limit) throws UserAdminException {
        FlaggedName[] roles = this.getUserAdminProxy().getAllRolesNames(filter, limit);
        ArrayList<FlaggedName> permittedRoles = new ArrayList<FlaggedName>();
        try {
            UserRealm realm = UserMgtDSComponent.getRealmService().getTenantUserRealm(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            AuthorizationManager authorizationManager = realm.getAuthorizationManager();
            for (int i = 0; i < roles.length - 1; ++i) {
                if (!authorizationManager.isRoleAuthorized(roles[i].getItemName(), permission, "ui.execute")) continue;
                permittedRoles.add(roles[i]);
            }
            permittedRoles.add(roles[roles.length - 1]);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserAdminException("Error while filtering authorized roles.", e);
        }
        FlaggedName[] permittedRolesArray = new FlaggedName[permittedRoles.size()];
        return permittedRoles.toArray(permittedRolesArray);
    }

    public FlaggedName[] getAllSharedRoleNames(String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getAllRolesNames(filter, limit);
    }

    public UserRealmInfo getUserRealmInfo() throws UserAdminException {
        return this.getUserAdminProxy().getUserRealmInfo();
    }

    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        this.getUserAdminProxy().addUser(userName, password, roles, claims, profileName);
    }

    public void changePassword(String userName, String newPassword) throws UserAdminException {
        this.getUserAdminProxy().changePassword(userName, newPassword);
    }

    public void deleteUser(String userName) throws UserAdminException {
        this.getUserAdminProxy().deleteUser(userName, CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.USER_CONFIGURATION));
    }

    public void addRole(String roleName, String[] userList, String[] permissions, boolean isSharedRole) throws UserAdminException {
        this.addUserRole(roleName, userList, permissions, isSharedRole, false);
    }

    private void addUserRole(String roleName, String[] userList, String[] permissions, boolean isSharedRole, boolean isInternalRole) throws UserAdminException {
        org.wso2.carbon.user.core.UserRealm realm;
        if (permissions == null) {
            permissions = new String[]{};
        }
        if (!this.isAllowedRoleName(roleName, realm = (org.wso2.carbon.user.core.UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm())) {
            throw new UserAdminException("Role name is reserved by the system.");
        }
        if (!isInternalRole) {
            if (this.getUserAdminProxy().isRoleAndGroupSeparationEnabled() && ArrayUtils.isNotEmpty((Object[])permissions)) {
                this.addInternalSystemRole(roleName, permissions);
                permissions = new String[]{};
            }
            this.getUserAdminProxy().addRole(roleName, userList, permissions, isSharedRole);
        } else {
            this.getUserAdminProxy().addInternalRole(roleName, userList, permissions);
        }
    }

    public void addInternalRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        if (this.getUserAdminProxy().isRoleAndGroupSeparationEnabled() && StringUtils.startsWithIgnoreCase((String)roleName, (String)"system_")) {
            String errorMessage = String.format("Invalid role name: %s. Role names with the prefix: %s, is not allowed to be created from externally in the system.", roleName, "system_");
            throw new UserAdminException(errorMessage);
        }
        this.addUserRole(roleName, userList, permissions, false, true);
    }

    private boolean isAllowedRoleName(String roleName, org.wso2.carbon.user.core.UserRealm realm) throws UserAdminException {
        if (roleName == null) {
            return false;
        }
        int index = roleName.indexOf(CarbonConstants.DOMAIN_SEPARATOR);
        if (index > 0) {
            roleName = roleName.substring(index + 1);
        }
        try {
            return !realm.getRealmConfiguration().isReservedRoleName(roleName);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteRole(String roleName) throws UserAdminException {
        this.getUserAdminProxy().deleteRole(roleName);
        if (this.getUserAdminProxy().isRoleAndGroupSeparationEnabled()) {
            String internalSystemRoleName = "system_" + UserCoreUtil.extractDomainFromName((String)roleName).toLowerCase() + "_" + UserCoreUtil.removeDomainFromName((String)roleName);
            this.getUserAdminProxy().deleteRole(this.appendInternalDomain(internalSystemRoleName));
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        this.getUserAdminProxy().updateRoleName(roleName, newRoleName);
    }

    public boolean hasMultipleUserStores() throws UserAdminException {
        return this.getUserAdminProxy().hasMultipleUserStores();
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getUsersOfRole(roleName, filter, limit);
    }

    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        this.getUserAdminProxy().updateUsersOfRole(roleName, userList);
    }

    public FlaggedName[] getRolesOfUser(String userName, String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getRolesOfUser(userName, filter, limit);
    }

    public FlaggedName[] getRolesOfCurrentUser() throws UserAdminException {
        return this.getRolesOfUser(CarbonContext.getThreadLocalCarbonContext().getUsername(), "*", -1);
    }

    public void updateRolesOfUser(String userName, String[] newRoleList) throws UserAdminException {
        this.getUserAdminProxy().updateRolesOfUser(userName, newRoleList);
    }

    public UIPermissionNode getAllUIPermissions() throws UserAdminException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        return this.getUserAdminProxy().getAllUIPermissions(tenantId);
    }

    public UIPermissionNode getRolePermissions(String roleName) throws UserAdminException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (!this.getUserAdminProxy().isRoleAndGroupSeparationEnabled() || this.isInternalRole(roleName)) {
            return this.getUserAdminProxy().getRolePermissions(roleName, tenantId);
        }
        List<String> roles = this.getUserAdminProxy().getHybridRoleListOfGroup(UserCoreUtil.removeDomainFromName((String)roleName), UserCoreUtil.extractDomainFromName((String)roleName));
        return this.getUserAdminProxy().getRolePermissions(roles, tenantId);
    }

    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        if (!this.getUserAdminProxy().isRoleAndGroupSeparationEnabled() || this.isInternalRole(roleName)) {
            this.getUserAdminProxy().setRoleUIPermission(roleName, rawResources);
        } else {
            this.addInternalSystemRole(roleName, rawResources);
        }
    }

    private void addInternalSystemRole(String roleName, String[] rawResources) throws UserAdminException {
        String internalSystemRoleName = "system_" + UserCoreUtil.extractDomainFromName((String)roleName).toLowerCase() + "_" + UserCoreUtil.removeDomainFromName((String)roleName);
        if (this.getUserAdminProxy().isExistingHybridRole(internalSystemRoleName)) {
            this.getUserAdminProxy().setRoleUIPermission(this.appendInternalDomain(internalSystemRoleName), rawResources);
        } else {
            this.getUserAdminProxy().addInternalRole(internalSystemRoleName, new String[0], rawResources);
            this.getUserAdminProxy().updateGroupListOfHybridRole(internalSystemRoleName, null, new String[]{roleName});
        }
    }

    private String appendInternalDomain(String roleName) {
        if (!roleName.contains(UserCoreConstants.DOMAIN_SEPARATOR)) {
            return "Internal" + UserCoreConstants.DOMAIN_SEPARATOR + roleName;
        }
        return roleName;
    }

    private boolean isInternalRole(String roleName) {
        String domain = UserCoreUtil.extractDomainFromName((String)roleName);
        return "Internal".equalsIgnoreCase(domain) || "Workflow".equalsIgnoreCase(domain) || "Application".equalsIgnoreCase(domain) || "SYSTEM".equalsIgnoreCase(domain);
    }

    public void bulkImportUsers(String userStoreDomain, String fileName, DataHandler handler, String defaultPassword) throws UserAdminException {
        if (fileName == null || handler == null) {
            throw new UserAdminException("Required data not provided");
        }
        if (StringUtils.isEmpty((String)userStoreDomain)) {
            userStoreDomain = IdentityUtil.getPrimaryDomainName();
        }
        try {
            InputStream inStream = handler.getInputStream();
            this.getUserAdminProxy().bulkImportUsers(userStoreDomain, fileName, inStream, defaultPassword);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void changePasswordByUser(String userName, String oldPassword, String newPassword) throws UserAdminException {
        Object result = null;
        try {
            String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            RealmService realmService = UserMgtDSComponent.getRealmService();
            int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
            UserRealm userRealm = realmService.getTenantUserRealm(tenantId);
            String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
            boolean isAuthenticated = userRealm.getUserStoreManager().authenticate(tenantAwareUsername, (Object)oldPassword);
            if (!isAuthenticated) {
                throw new UserAdminException("The current password you entered is incorrect. ");
            }
            this.getUserAdminProxy().changePasswordByUser(userName, oldPassword, newPassword);
        }
        catch (UserAdminException e) {
            throw e;
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserAdminException("Error while updating password. Please enter tenant unaware username", e);
        }
    }

    public void addRemoveUsersOfRole(String roleName, String[] newUsers, String[] deletedUsers) throws UserAdminException {
        this.getUserAdminProxy().updateUsersOfRole(roleName, newUsers, deletedUsers);
    }

    public void addRemoveRolesOfUser(String userName, String[] newRoles, String[] deletedRoles) throws UserAdminException {
        this.getUserAdminProxy().updateRolesOfUser(userName, newRoles, deletedRoles);
    }

    public FlaggedName[] listUserByClaim(ClaimValue claimValue, String filter, int maxLimit) throws UserAdminException {
        return this.getUserAdminProxy().listUsers(claimValue, filter, maxLimit);
    }

    public FlaggedName[] listUserByClaimWithPermission(ClaimValue claimValue, String filter, String permission, int maxLimit) throws UserAdminException {
        ArrayList<FlaggedName> permittedUsers = new ArrayList<FlaggedName>();
        try {
            UserRealm realm = UserMgtDSComponent.getRealmService().getTenantUserRealm(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            AuthorizationManager authorizationManager = realm.getAuthorizationManager();
            FlaggedName[] users = this.getUserAdminProxy().listUsers(claimValue, filter, maxLimit);
            for (int i = 0; i < users.length - 1; ++i) {
                if (!authorizationManager.isUserAuthorized(users[i].getItemName(), permission, "ui.execute")) continue;
                permittedUsers.add(users[i]);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserAdminException("Error while filtering authorized users.", e);
        }
        FlaggedName[] permittedUsersArray = new FlaggedName[permittedUsers.size()];
        return permittedUsers.toArray(permittedUsersArray);
    }

    private UserRealmProxy getUserAdminProxy() {
        org.wso2.carbon.user.core.UserRealm realm = (org.wso2.carbon.user.core.UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        return new UserRealmProxy(realm);
    }

    public boolean isSharedRolesEnabled() throws UserAdminException {
        return this.getUserAdminProxy().isSharedRolesEnabled();
    }
}

