/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.core.util.DatabaseUtil;

public class UMDatabaseManager {
    private DataSource dataSource = null;
    private static Log log = LogFactory.getLog(UMDatabaseManager.class);
    private static final String CREATE_TABLE = "CREATE TABLE USER_MGT_PROPERTIES(ID INTEGER GENERATED BY DEFAULT AS IDENTITY, PROPERTY_NAME VARCHAR(255) NOT NULL, PROPERTY_VALUE VARCHAR(255), PRIMARY KEY (ID))";
    private static final String SET_PROPERTY = "INSERT INTO USER_MGT_PROPERTIES(PROPERTY_NAME, PROPERTY_VALUE) VALUES (?,?)";
    private static final String GET_PROPERTY = "SELECT PROPERTY_VALUE FROM USER_MGT_PROPERTIES WHERE PROPERTY_NAME=?";
    private static final String GET_PROPERTIES = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM USER_MGT_PROPERTIES";
    private static final String DELETE_PROPERTIES = "DELETE * FROM USER_MGT_PROPERTIES";

    public UMDatabaseManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) throws SQLException {
        String value = null;
        PreparedStatement stmt = null;
        Connection dbConnection = null;
        ResultSet rs = null;
        try {
            dbConnection = this.dataSource.getConnection();
            stmt = dbConnection.prepareStatement(GET_PROPERTY);
            stmt.setString(1, name);
            stmt.executeQuery();
            rs = stmt.executeQuery();
            if (rs.next()) {
                value = rs.getString(1);
            }
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement[])new PreparedStatement[]{stmt});
            throw throwable;
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement[])new PreparedStatement[]{stmt});
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExternalStoreProperties() throws SQLException {
        Connection dbConnection = null;
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            stmt = dbConnection.prepareStatement(GET_PROPERTIES);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString(1);
                String value = rs.getString(2);
                map.put(name, value);
            }
        }
        catch (Throwable throwable) {
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement[])new PreparedStatement[]{stmt});
            throw throwable;
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement[])new PreparedStatement[]{stmt});
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllProperties() throws SQLException {
        Connection dbConnection = null;
        PreparedStatement stmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            stmt = dbConnection.prepareStatement(DELETE_PROPERTIES);
            stmt.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                dbConnection.rollback();
                log.error((Object)"Error occurred while delete the properties", (Throwable)e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
                throw throwable;
            }
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
        }
        DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[]{stmt});
    }

    public void setProperty(String name, String value) throws SQLException {
        try (Connection dbConnection = this.dataSource.getConnection();){
            dbConnection.setAutoCommit(false);
            try (PreparedStatement stmt = dbConnection.prepareStatement(SET_PROPERTY);){
                stmt.setString(1, name);
                stmt.setString(2, value);
                stmt.executeUpdate();
                dbConnection.commit();
            }
            catch (SQLException e1) {
                dbConnection.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createManagementTables() throws SQLException {
        Connection dbConnection = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            dbConnection = this.dataSource.getConnection();
            dbConnection.setAutoCommit(false);
            DatabaseMetaData dbmd = dbConnection.getMetaData();
            rs = dbmd.getTables(null, null, "USER_MGT_PROPERTIES", null);
            stmt = dbConnection.createStatement(1004, 1008);
            if (!rs.next()) {
                stmt.executeUpdate(CREATE_TABLE);
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            dbConnection.rollback();
            log.error((Object)"Error occurred while creating management table", (Throwable)e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            DatabaseUtil.closeAllConnections((Connection)dbConnection, (PreparedStatement[])new PreparedStatement[0]);
        }
    }
}

