/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.mgt.RolePermissionException;
import org.wso2.carbon.user.mgt.RolePermissionManagementService;
import org.wso2.carbon.user.mgt.UserRealmProxy;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.model.Permission;

public class RolePermissionManagementServiceImpl
implements RolePermissionManagementService {
    private static final Log log = LogFactory.getLog(RolePermissionManagementServiceImpl.class);

    @Override
    public String[] getRolePermissions(String roleName, int tenantId) throws RolePermissionException {
        try {
            return this.getSelectedPermissions(this.getUserAdminProxy().getRolePermissions(roleName, tenantId));
        }
        catch (UserAdminException e) {
            log.error((Object)("An error occurred when retrieving permissions of role: " + roleName));
            throw new RolePermissionException("An error occurred when retrieving permissions of role : " + roleName, e);
        }
    }

    @Override
    public void setRolePermissions(String roleName, String[] permissions) throws RolePermissionException {
        try {
            this.getUserAdminProxy().setRoleUIPermission(roleName, permissions);
        }
        catch (UserAdminException e) {
            log.error((Object)("An error occurred when retrieving permissions of role: " + roleName));
            throw new RolePermissionException("An error occurred when retrieving permissions of role: " + roleName, e);
        }
    }

    @Override
    public Permission[] getAllPermissions(int tenantId) throws RolePermissionException {
        try {
            return this.getAllPermissions(this.getUserAdminProxy().getAllUIPermissions(tenantId));
        }
        catch (UserAdminException e) {
            log.error((Object)"An error occurred when retrieving all permissions.");
            throw new RolePermissionException("An error occurred when retrieving all permissions.", e);
        }
    }

    private UserRealmProxy getUserAdminProxy() {
        UserRealm realm = (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        return new UserRealmProxy(realm);
    }

    private String[] getSelectedPermissions(UIPermissionNode node) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (node.isSelected()) {
            permissions.add(node.getResourcePath());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Permission: " + node.getDisplayName() + " and resourcePath: " + node.getResourcePath() + " added to the permission Map"));
            }
        } else {
            Object[] childNodes = node.getNodeList();
            if (ArrayUtils.isNotEmpty((Object[])childNodes)) {
                for (Object childNode : childNodes) {
                    permissions.addAll(Arrays.asList(this.getSelectedPermissions((UIPermissionNode)childNode)));
                }
            }
        }
        return permissions.toArray(new String[0]);
    }

    private Permission[] getAllPermissions(UIPermissionNode node) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        Object[] childNodes = node.getNodeList();
        Permission permission = new Permission();
        permission.setDisplayName(node.getDisplayName());
        permission.setResourcePath(node.getResourcePath());
        permissions.add(permission);
        if (ArrayUtils.isNotEmpty((Object[])childNodes)) {
            for (Object childNode : childNodes) {
                permissions.addAll(Arrays.asList(this.getAllPermissions((UIPermissionNode)childNode)));
            }
        }
        return permissions.toArray(new Permission[0]);
    }
}

