/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util.filter;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.endpoint.util.AuthenticationEndpointUtil;

public class AuthenticationEndpointFilter
implements Filter {
    private static final Log log = LogFactory.getLog(AuthenticationEndpointFilter.class);
    private static final String REQUEST_PARAM_APPLICATION = "application";
    private static final String REQUEST_PARAM_AUTHENTICATORS = "authenticators";
    private static final String REQUEST_PARAM_HRD = "hrd";
    private static final String REQUEST_PARAM_TYPE = "type";
    private static final String REQUEST_PARAM_REFERRER = "referer";
    private static final String QUERY_SEPARATOR = "&";
    private static final String EQUAL = "=";
    private static final String SAMLSSO = "samlsso";
    private static final String OPENID = "openid";
    private static final String PASSIVESTS = "passivests";
    private static final String OAUTH2 = "oauth2";
    private static final String OIDC = "oidc";
    private static final String FIDO = "fido";
    private static final String URI_LOGIN = "login.do";
    private static final String URI_SAMLSSO_LOGIN = "samlsso_login.do";
    private static final String URI_OPENID_LOGIN = "openid_login.do";
    private static final String URI_PASSIVESTS_LOGIN = "passivests_login.do";
    private static final String URI_OAUTH2_LOGIN = "oauth2_login.do";
    public static final String ATTRIBUTE_SKIP_PROPERTY = "skip";
    private ServletContext context = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object skipFilterAttribute = servletRequest.getAttribute(ATTRIBUTE_SKIP_PROPERTY);
        if (skipFilterAttribute != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String redirectUrl = null;
        String appSpecificCustomPageConfigKey = null;
        String refererHeader = ((HttpServletRequest)servletRequest).getHeader(REQUEST_PARAM_REFERRER);
        String serviceProviderName = null;
        if (servletRequest.getParameter("sp") != null) {
            serviceProviderName = servletRequest.getParameter("sp");
        } else if (servletRequest.getParameter(REQUEST_PARAM_APPLICATION) != null) {
            serviceProviderName = servletRequest.getParameter(REQUEST_PARAM_APPLICATION);
        } else if (refererHeader != null) {
            String[] queryParams;
            for (String queryParam : queryParams = refererHeader.split(QUERY_SEPARATOR)) {
                if (!queryParam.contains("sp=") && !queryParam.contains("application=")) continue;
                serviceProviderName = queryParam.substring(queryParam.lastIndexOf(EQUAL) + 1);
                break;
            }
        }
        String relativePath = ((HttpServletRequest)servletRequest).getRequestURI().substring(((HttpServletRequest)servletRequest).getContextPath().length());
        if (StringUtils.isNotBlank((String)serviceProviderName)) {
            appSpecificCustomPageConfigKey = AuthenticationEndpointUtil.getApplicationSpecificCustomPageConfigKey(serviceProviderName, relativePath);
        }
        if (appSpecificCustomPageConfigKey != null) {
            redirectUrl = AuthenticationEndpointUtil.getCustomPageRedirectUrl(this.context.getInitParameter(appSpecificCustomPageConfigKey), ((HttpServletRequest)servletRequest).getQueryString());
        }
        if (redirectUrl == null) {
            redirectUrl = AuthenticationEndpointUtil.getCustomPageRedirectUrl(this.context.getInitParameter(relativePath), ((HttpServletRequest)servletRequest).getQueryString());
        }
        if (redirectUrl != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("There is a custom configuration matching the request uri. Redirecting to : " + redirectUrl));
            }
            ((HttpServletResponse)servletResponse).sendRedirect(redirectUrl);
            return;
        }
        if (((HttpServletRequest)servletRequest).getRequestURI().contains(URI_LOGIN)) {
            String protocolType;
            String hrdParam = servletRequest.getParameter(REQUEST_PARAM_HRD);
            if (hrdParam != null && "true".equalsIgnoreCase(hrdParam)) {
                servletRequest.getRequestDispatcher("domain.jsp").forward(servletRequest, servletResponse);
                return;
            }
            HashMap<String, String> idpAuthenticatorMapping = new HashMap<String, String>();
            String authenticators = servletRequest.getParameter(REQUEST_PARAM_AUTHENTICATORS);
            if (authenticators != null) {
                String[] authenticatorIdPMappings;
                for (String authenticatorIdPMapping : authenticatorIdPMappings = authenticators.split(";")) {
                    String[] authenticatorIdPMapArr = authenticatorIdPMapping.split(":");
                    for (int i = 1; i < authenticatorIdPMapArr.length; ++i) {
                        if (idpAuthenticatorMapping.containsKey(authenticatorIdPMapArr[i])) {
                            idpAuthenticatorMapping.put(authenticatorIdPMapArr[i], (String)idpAuthenticatorMapping.get(authenticatorIdPMapArr[i]) + "," + authenticatorIdPMapArr[0]);
                            continue;
                        }
                        idpAuthenticatorMapping.put(authenticatorIdPMapArr[i], authenticatorIdPMapArr[0]);
                    }
                }
            }
            if (!idpAuthenticatorMapping.isEmpty()) {
                servletRequest.setAttribute("idpAuthenticatorMap", idpAuthenticatorMapping);
            }
            String loadPage = SAMLSSO.equals(protocolType = servletRequest.getParameter(REQUEST_PARAM_TYPE)) ? URI_SAMLSSO_LOGIN : (OPENID.equals(protocolType) ? URI_OPENID_LOGIN : (PASSIVESTS.equals(protocolType) ? URI_PASSIVESTS_LOGIN : (OAUTH2.equals(protocolType) || OIDC.equals(protocolType) ? URI_OAUTH2_LOGIN : (FIDO.equals(protocolType) ? "fido-auth.jsp" : "login.jsp"))));
            servletRequest.setAttribute(ATTRIBUTE_SKIP_PROPERTY, (Object)true);
            servletRequest.getRequestDispatcher(loadPage).forward(servletRequest, servletResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

