/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import org.wso2.carbon.identity.application.authentication.endpoint.util.client.exception.ServiceClientException;
import org.wso2.carbon.identity.application.authentication.endpoint.util.client.model.AuthenticationErrorResponse;
import org.wso2.carbon.identity.application.authentication.endpoint.util.client.model.AuthenticationResponse;
import org.wso2.carbon.identity.application.authentication.endpoint.util.client.model.AuthenticationSuccessResponse;

public class AuthAPIServiceClient {
    private static final Log log = LogFactory.getLog(AuthAPIServiceClient.class);
    private static final String RESPONSE_PARAM_TOKEN = "token";
    private static final String RESPONSE_PARAM_CODE = "code";
    private static final String RESPONSE_PARAM_MESSAGE = "message";
    private static final String RESPONSE_PARAM_DESCRIPTION = "description";
    private static final String RESPONSE_PARAM_PROPERTIES = "properties";
    private String basePath;
    private CloseableHttpClient httpClient = HttpClients.createDefault();

    public AuthAPIServiceClient(String apiBasePath) {
        this.basePath = apiBasePath;
    }

    public AuthenticationResponse authenticate(String username, Object password) throws ServiceClientException {
        AuthenticationResponse authenticationResponse;
        String endpointURL = this.basePath + "authenticate";
        HttpPost httpPostRequest = new HttpPost(endpointURL);
        httpPostRequest.setHeader("Authorization", this.buildBasicAuthHeader(username, password));
        httpPostRequest.setHeader("Content-Type", "application/json");
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPostRequest);){
            JSONObject responseObj;
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = this.extractResponse(response);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response: { status: " + response.getStatusLine().getStatusCode() + "\n data: " + responseString + " }"));
            }
            authenticationResponse = (responseObj = new JSONObject(responseString)).has(RESPONSE_PARAM_TOKEN) ? this.populateAuthenticationSuccessResponse(responseObj) : this.populateAuthenticationErrorResponse(responseObj);
            authenticationResponse.setStatusCode(statusCode);
        }
        catch (IOException e) {
            String msg = "Error while invoking " + endpointURL;
            log.error((Object)msg, (Throwable)e);
            throw new ServiceClientException(msg, e);
        }
        return authenticationResponse;
    }

    private String extractResponse(CloseableHttpResponse httpResponse) throws ServiceClientException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8));){
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
        }
        catch (IOException e) {
            String msg = "Error while reading HTTP response from service endpoint: " + this.basePath;
            log.error((Object)msg, (Throwable)e);
            throw new ServiceClientException(msg, e);
        }
        return response.toString();
    }

    private String buildBasicAuthHeader(String username, Object password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encodedAuth, StandardCharsets.UTF_8);
    }

    private AuthenticationSuccessResponse populateAuthenticationSuccessResponse(JSONObject responseObj) {
        AuthenticationSuccessResponse authenticationSuccessResponse = new AuthenticationSuccessResponse();
        authenticationSuccessResponse.setToken(responseObj.getString(RESPONSE_PARAM_TOKEN));
        return authenticationSuccessResponse;
    }

    private AuthenticationErrorResponse populateAuthenticationErrorResponse(JSONObject responseObj) {
        JSONObject propertyObj;
        AuthenticationErrorResponse authenticationErrorResponse = new AuthenticationErrorResponse();
        authenticationErrorResponse.setCode(responseObj.getString(RESPONSE_PARAM_CODE));
        authenticationErrorResponse.setMessage(responseObj.getString(RESPONSE_PARAM_MESSAGE));
        authenticationErrorResponse.setDescription(responseObj.getString(RESPONSE_PARAM_DESCRIPTION));
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        if (responseObj.has(RESPONSE_PARAM_PROPERTIES) && !responseObj.isNull(RESPONSE_PARAM_PROPERTIES) && (propertyObj = responseObj.getJSONObject(RESPONSE_PARAM_PROPERTIES)) != null) {
            Iterator keys = propertyObj.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                propertyMap.put(key, String.valueOf(propertyObj.get(key)));
            }
        }
        authenticationErrorResponse.setProperties(propertyMap);
        return authenticationErrorResponse;
    }
}

