/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.endpoint.util.AuthenticationException;

public class TenantMgtAdminServiceClient {
    private static final Log log = LogFactory.getLog(TenantMgtAdminServiceClient.class);
    private static final String HTTP_POST = "POST";
    private static String keyStoreType = "JKS";
    private static String trustStoreType = "JKS";
    private static String keyManagerType = "SunX509";
    private static String trustManagerType = "SunX509";
    private static String protocol = "TLSv1.2";
    private static KeyStore keyStore;
    private static KeyStore trustStore;
    private static char[] keyStorePassword;
    private static HttpsURLConnection httpsURLConnection;
    private static SSLSocketFactory sslSocketFactory;

    private TenantMgtAdminServiceClient() {
    }

    public static void loadKeyStore(String keyStorePath, String keyStorePassword) throws AuthenticationException {
        InputStream fis = null;
        try {
            TenantMgtAdminServiceClient.keyStorePassword = keyStorePassword.toCharArray();
            keyStore = KeyStore.getInstance(keyStoreType);
            fis = new FileInputStream(keyStorePath);
            keyStore.load(fis, TenantMgtAdminServiceClient.keyStorePassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AuthenticationException("Error while trying to load Key Store.", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close file. ", (Throwable)e);
                }
            }
        }
    }

    public static void loadTrustStore(String trustStorePath, String trustStorePassword) throws AuthenticationException {
        InputStream is = null;
        try {
            trustStore = KeyStore.getInstance(trustStoreType);
            is = new FileInputStream(trustStorePath);
            trustStore.load(is, trustStorePassword.toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AuthenticationException("Error while trying to load Trust Store.", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close file. ", (Throwable)e);
                }
            }
        }
    }

    public static void initMutualSSLConnection(boolean hostNameVerificationEnabled) throws AuthenticationException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerType);
            keyManagerFactory.init(keyStore, keyStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerType);
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(protocol);
            if (hostNameVerificationEnabled) {
                sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                sslSocketFactory = sslContext.getSocketFactory();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mutual SSL Client initialized with Hostname Verification enabled");
                }
            } else {
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                };
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sslContext.init(keyManagerFactory.getKeyManagers(), trustAllCerts, new SecureRandom());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSL Context is initialized with trust manager for excluding certificate validation");
                }
                SSLContext.setDefault(sslContext);
                sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mutual SSL Client initialized with Hostname Verification disabled");
                }
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new AuthenticationException("Error while trying to load Trust Store.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequest(String backendURL, String message, Map<String, String> requestProps) {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        BufferedReader reader = null;
        String response = null;
        URL url = null;
        try {
            String line;
            url = new URL(backendURL);
            httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod(HTTP_POST);
            if (requestProps != null) {
                for (Map.Entry<String, String> entry : requestProps.entrySet()) {
                    httpsURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            outputStream = httpsURLConnection.getOutputStream();
            if (StringUtils.isNotEmpty((String)message)) {
                outputStream.write(message.getBytes(StandardCharsets.UTF_8));
            }
            inputStream = httpsURLConnection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while (StringUtils.isNotEmpty((String)(line = reader.readLine()))) {
                builder.append(line);
            }
            response = builder.toString();
        }
        catch (IOException e) {
            log.error((Object)("Sending POST request to URL : " + url + "failed."), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Closing stream for " + url + " failed"), (Throwable)e);
            }
        }
        return response;
    }

    public static String getKeyStoreType() {
        return keyStoreType;
    }

    public static void setKeyStoreType(String keyStoreType) {
        TenantMgtAdminServiceClient.keyStoreType = keyStoreType;
    }

    public static String getTrustStoreType() {
        return trustStoreType;
    }

    public static void setTrustStoreType(String trustStoreType) {
        TenantMgtAdminServiceClient.trustStoreType = trustStoreType;
    }

    public static String getKeyManagerType() {
        return keyManagerType;
    }

    public static void setKeyManagerType(String keyManagerType) {
        TenantMgtAdminServiceClient.keyManagerType = keyManagerType;
    }

    public static String getTrustManagerType() {
        return trustManagerType;
    }

    public static void setTrustManagerType(String trustManagerType) {
        TenantMgtAdminServiceClient.trustManagerType = trustManagerType;
    }

    public static HttpsURLConnection getHttpsURLConnection() {
        return httpsURLConnection;
    }

    public static void setProtocol(String protocol) {
        TenantMgtAdminServiceClient.protocol = protocol;
    }
}

