/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.identity.application.authentication.endpoint.util.AuthenticationException;
import org.wso2.carbon.identity.application.authentication.endpoint.util.TenantMgtAdminServiceClient;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;
import org.xml.sax.InputSource;

public class TenantDataManager {
    private static final Log log = LogFactory.getLog(TenantDataManager.class);
    private static final String PROTECTED_TOKENS = "protectedTokens";
    private static final String DEFAULT_CALLBACK_HANDLER = "org.wso2.carbon.securevault.DefaultSecretCallbackHandler";
    private static final String SECRET_PROVIDER = "secretProvider";
    private static Properties prop;
    private static String carbonLogin;
    private static String serviceURL;
    private static String usernameHeaderName;
    private static List<String> tenantDomainList;
    private static boolean initialized;
    private static boolean initAttempted;

    private TenantDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() {
        InputStream inputStream = null;
        initAttempted = true;
        try {
            if (!initialized) {
                prop = new Properties();
                String configFilePath = TenantDataManager.buildFilePath("./repository/conf/identity/EndpointConfig.properties");
                File configFile = new File(configFilePath);
                if (configFile.exists()) {
                    log.info((Object)"EndpointConfig.properties file loaded from ./repository/conf/identity/EndpointConfig.properties");
                    inputStream = new FileInputStream(configFile);
                    prop.load(inputStream);
                    if (Boolean.parseBoolean(TenantDataManager.getPropertyValue("tenantListEnabled"))) {
                        TenantDataManager.resolveSecrets(prop);
                    }
                } else {
                    inputStream = TenantDataManager.class.getClassLoader().getResourceAsStream("EndpointConfig.properties");
                    if (inputStream != null) {
                        prop.load(inputStream);
                        log.debug((Object)"EndpointConfig.properties file loaded from authentication endpoint webapp");
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Input stream is null while loading authentication endpoint from webapp");
                    }
                }
                if (Boolean.parseBoolean(TenantDataManager.getPropertyValue("tenantListEnabled"))) {
                    usernameHeaderName = TenantDataManager.getPropertyValue("username.header");
                    carbonLogin = TenantDataManager.getPropertyValue("mutual.ssl.username");
                    carbonLogin = Base64.encode((byte[])carbonLogin.getBytes("UTF-8"));
                    String clientKeyStorePath = TenantDataManager.buildFilePath(TenantDataManager.getPropertyValue("client.keyStore"));
                    String clientTrustStorePath = TenantDataManager.buildFilePath(TenantDataManager.getPropertyValue("client.trustStore"));
                    if (StringUtils.isNotEmpty((String)TenantDataManager.getPropertyValue("tls.protocol"))) {
                        TenantMgtAdminServiceClient.setProtocol(TenantDataManager.getPropertyValue("tls.protocol"));
                    }
                    if (StringUtils.isNotEmpty((String)TenantDataManager.getPropertyValue("key.manager.type"))) {
                        TenantMgtAdminServiceClient.setKeyManagerType(TenantDataManager.getPropertyValue("key.manager.type"));
                    }
                    if (StringUtils.isNotEmpty((String)TenantDataManager.getPropertyValue("trust.manager.type"))) {
                        TenantMgtAdminServiceClient.setTrustManagerType(TenantDataManager.getPropertyValue("trust.manager.type"));
                    }
                    TenantMgtAdminServiceClient.loadKeyStore(clientKeyStorePath, TenantDataManager.getPropertyValue("Carbon.Security.KeyStore.Password"));
                    TenantMgtAdminServiceClient.loadTrustStore(clientTrustStorePath, TenantDataManager.getPropertyValue("Carbon.Security.TrustStore.Password"));
                    TenantMgtAdminServiceClient.initMutualSSLConnection(Boolean.parseBoolean(TenantDataManager.getPropertyValue("hostname.verification.enabled")));
                    StringBuilder builder = new StringBuilder();
                    serviceURL = builder.append(TenantDataManager.getPropertyValue("identity.server.serviceURL")).append("/TenantMgtAdminService/retrieveTenants").toString();
                    initialized = true;
                }
            }
        }
        catch (IOException | AuthenticationException e) {
            log.error((Object)"Initialization failed : ", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close the FileInputStream, file : EndpointConfig.properties", (Throwable)e);
                }
            }
        }
    }

    private static String buildFilePath(String path) throws IOException {
        if (StringUtils.isNotEmpty((String)path) && path.startsWith(".")) {
            File currentDirectory = new File(new File(".").getAbsolutePath());
            path = currentDirectory.getCanonicalPath() + File.separator + path;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("File path for KeyStore/TrustStore : " + path));
        }
        return path;
    }

    protected static String getPropertyValue(String key) {
        if ("identity.server.serviceURL".equals(key) && !prop.containsKey("identity.server.serviceURL")) {
            String serviceUrl = IdentityUtil.getServicePath();
            return IdentityUtil.getServerURL((String)serviceUrl, (boolean)true, (boolean)true);
        }
        return prop.getProperty(key);
    }

    private static String getServiceResponse(String url) {
        String serviceResponse = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put(usernameHeaderName, carbonLogin);
        serviceResponse = TenantMgtAdminServiceClient.sendPostRequest(url, null, headerParams);
        return serviceResponse;
    }

    public static List<String> getAllActiveTenantDomains() {
        if (initialized && tenantDomainList.isEmpty()) {
            TenantDataManager.refreshActiveTenantDomainsList();
        }
        return tenantDomainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetTenantDataList() {
        if (!initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant domains list not set as TenantDataManager is not initialized.");
            }
            return;
        }
        List<String> list = tenantDomainList;
        synchronized (list) {
            tenantDomainList.clear();
            TenantDataManager.refreshActiveTenantDomainsList();
        }
    }

    private static void refreshActiveTenantDomainsList() {
        try {
            String xmlString = TenantDataManager.getServiceResponse(serviceURL);
            if (StringUtils.isNotEmpty((String)xmlString)) {
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xpath = xpf.newXPath();
                InputSource inputSource = new InputSource(new StringReader(xmlString));
                DocumentBuilderFactory factory = IdentityUtil.getSecuredDocumentBuilderFactory();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                String xPathExpression = "/*[local-name() = 'retrieveTenantsResponse']/*[local-name() = 'return']";
                XPathExpression expr = xpath.compile(xPathExpression);
                NodeList nodeList = null;
                nodeList = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                tenantDomainList.clear();
                block2: for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node == null || node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    NodeList tenantData = element.getChildNodes();
                    boolean activeChecked = false;
                    boolean domainChecked = false;
                    boolean isActive = false;
                    String tenantDomain = null;
                    for (int j = 0; j < tenantData.getLength(); ++j) {
                        Node dataItem = tenantData.item(j);
                        String localName = dataItem.getLocalName();
                        if ("active".equals(localName)) {
                            activeChecked = true;
                            if (Boolean.parseBoolean(dataItem.getTextContent())) {
                                isActive = true;
                            }
                        }
                        if ("tenantDomain".equals(localName)) {
                            domainChecked = true;
                            tenantDomain = dataItem.getTextContent();
                        }
                        if (!activeChecked || !domainChecked) continue;
                        if (isActive) {
                            tenantDomainList.add(tenantDomain);
                            if (!log.isDebugEnabled()) continue block2;
                            log.debug((Object)(tenantDomain + " is active and added to the dropdown list"));
                            continue block2;
                        }
                        if (!log.isDebugEnabled()) continue block2;
                        log.debug((Object)(tenantDomain + " is inactive and not added to the dropdown list"));
                        continue block2;
                    }
                }
                Collections.sort(tenantDomainList);
            }
        }
        catch (Exception e) {
            log.error((Object)"Retrieving list of active tenant domains failed. Ignore this if there are no tenants : ", (Throwable)e);
        }
    }

    public static boolean isTenantListEnabled() {
        if (!initAttempted && !initialized) {
            TenantDataManager.init();
        }
        return Boolean.parseBoolean(TenantDataManager.getPropertyValue("tenantListEnabled"));
    }

    private static void resolveSecrets(Properties properties) {
        SecretResolver secretResolver;
        String secretProvider = (String)properties.get(SECRET_PROVIDER);
        if (StringUtils.isBlank((String)secretProvider)) {
            properties.put(SECRET_PROVIDER, DEFAULT_CALLBACK_HANDLER);
        }
        if ((secretResolver = SecretResolverFactory.create((Properties)properties)) != null && secretResolver.isInitialized()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (value != null) {
                    value = MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
                }
                properties.put(key, value);
            }
        }
        if (TenantDataManager.isSecuredPropertyAvailable(properties)) {
            SecretResolver resolver = SecretResolverFactory.create((Properties)properties, (String)"");
            String protectedTokens = (String)properties.get(PROTECTED_TOKENS);
            StringTokenizer st = new StringTokenizer(protectedTokens, ",");
            while (st.hasMoreElements()) {
                String element = st.nextElement().toString().trim();
                if (resolver.isTokenProtected(element)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resolving and replacing secret for " + element));
                    }
                    properties.put(element, resolver.resolve(element));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No encryption done for value with key :" + element));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Secure vault encryption ignored since no protected tokens available");
        }
    }

    private static boolean isSecuredPropertyAvailable(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!PROTECTED_TOKENS.equals(key) || !StringUtils.isNotBlank((String)properties.getProperty(key))) continue;
            return true;
        }
        return false;
    }

    static {
        carbonLogin = "";
        usernameHeaderName = "";
        tenantDomainList = new ArrayList<String>();
        initialized = false;
        initAttempted = false;
    }
}

