/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.endpoint.util.MutualSSLManager;

public class TemplateMgtAPIClient {
    private static final Log log = LogFactory.getLog(TemplateMgtAPIClient.class);
    private static final String HTTP_METHOD_GET = "GET";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTemplateData(String backendURL) {
        InputStream inputStream = null;
        BufferedReader reader = null;
        String response = null;
        URL url = null;
        try {
            String line;
            url = new URL(backendURL);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
            httpsURLConnection.setSSLSocketFactory(MutualSSLManager.getSslSocketFactory());
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod(HTTP_METHOD_GET);
            httpsURLConnection.setRequestProperty(MutualSSLManager.getUsernameHeaderName(), MutualSSLManager.getCarbonLogin());
            inputStream = httpsURLConnection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            StringBuilder builder = new StringBuilder();
            while (StringUtils.isNotEmpty((String)(line = reader.readLine()))) {
                builder.append(line);
            }
            response = builder.toString();
        }
        catch (IOException e) {
            log.error((Object)("Sending GET request to URL : " + url + "failed."), (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)("Closing stream for " + url + " failed"), (Throwable)e);
            }
        }
        return response;
    }
}

