/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.endpoint.util.AuthenticationException;
import org.wso2.carbon.identity.application.authentication.endpoint.util.TenantMgtAdminServiceClient;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class MutualSSLManager {
    private static final Log log = LogFactory.getLog(MutualSSLManager.class);
    private static final String PROTECTED_TOKENS = "protectedTokens";
    private static final String DEFAULT_CALLBACK_HANDLER = "org.wso2.carbon.securevault.DefaultSecretCallbackHandler";
    private static final String SECRET_PROVIDER = "secretProvider";
    private static Properties prop;
    private static String carbonLogin;
    private static String usernameHeaderName;
    private static final String keyStoreType = "JKS";
    private static final String trustStoreType = "JKS";
    private static final String keyManagerType = "SunX509";
    private static final String trustManagerType = "SunX509";
    private static final String protocol = "TLSv1.2";
    private static KeyStore keyStore;
    private static KeyStore trustStore;
    private static char[] keyStorePassword;
    private static SSLSocketFactory sslSocketFactory;
    private static boolean initialized;

    private MutualSSLManager() {
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized void init() {
        block36: {
            try {
                if (MutualSSLManager.initialized) break block36;
                MutualSSLManager.prop = new Properties();
                configFilePath = MutualSSLManager.buildFilePath("./repository/conf/identity/EndpointConfig.properties");
                configFile = new File(configFilePath);
                if (configFile.exists()) {
                    MutualSSLManager.log.info((Object)"EndpointConfig.properties file loaded from ./repository/conf/identity/EndpointConfig.properties");
                    inputStream = new FileInputStream(configFile);
                    var3_4 = null;
                    try {
                        MutualSSLManager.prop.load(inputStream);
                        if (!MutualSSLManager.isMutualSSLManagerEnabled(MutualSSLManager.getPropertyValue("mutualSSLManagerEnabled"))) ** GOTO lbl54
                        MutualSSLManager.resolveSecrets(MutualSSLManager.prop);
                    }
                    catch (Throwable var4_6) {
                        var3_4 = var4_6;
                        throw var4_6;
                    }
                    finally {
                        if (inputStream != null) {
                            if (var3_4 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable var4_5) {
                                    var3_4.addSuppressed(var4_5);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                } else {
                    inputStream = MutualSSLManager.class.getClassLoader().getResourceAsStream("EndpointConfig.properties");
                    var3_4 = null;
                    try {
                        if (inputStream != null) {
                            MutualSSLManager.prop.load(inputStream);
                            if (MutualSSLManager.log.isDebugEnabled()) {
                                MutualSSLManager.log.debug((Object)"EndpointConfig.properties file loaded from authentication endpoint webapp");
                            }
                        } else if (MutualSSLManager.log.isDebugEnabled()) {
                            MutualSSLManager.log.debug((Object)"Input stream is null while loading authentication endpoint from webapp");
                        }
                    }
                    catch (Throwable var4_8) {
                        var3_4 = var4_8;
                        throw var4_8;
                    }
                    finally {
                        if (inputStream != null) {
                            if (var3_4 != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable var4_7) {
                                    var3_4.addSuppressed(var4_7);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                    }
                }
                if (MutualSSLManager.isMutualSSLManagerEnabled(MutualSSLManager.getPropertyValue("mutualSSLManagerEnabled"))) {
                    MutualSSLManager.usernameHeaderName = MutualSSLManager.getPropertyValue("username.header");
                    MutualSSLManager.carbonLogin = MutualSSLManager.getPropertyValue("mutual.ssl.username");
                    MutualSSLManager.carbonLogin = Base64.encode((byte[])MutualSSLManager.carbonLogin.getBytes("UTF-8"));
                    clientKeyStorePath = MutualSSLManager.buildFilePath(MutualSSLManager.getPropertyValue("client.keyStore"));
                    clientTrustStorePath = MutualSSLManager.buildFilePath(MutualSSLManager.getPropertyValue("client.trustStore"));
                    if (StringUtils.isNotBlank((String)MutualSSLManager.getPropertyValue("tls.protocol"))) {
                        TenantMgtAdminServiceClient.setProtocol(MutualSSLManager.getPropertyValue("tls.protocol"));
                    }
                    if (StringUtils.isNotBlank((String)MutualSSLManager.getPropertyValue("key.manager.type"))) {
                        TenantMgtAdminServiceClient.setKeyManagerType(MutualSSLManager.getPropertyValue("key.manager.type"));
                    }
                    if (StringUtils.isNotBlank((String)MutualSSLManager.getPropertyValue("trust.manager.type"))) {
                        TenantMgtAdminServiceClient.setTrustManagerType(MutualSSLManager.getPropertyValue("trust.manager.type"));
                    }
                    MutualSSLManager.loadKeyStore(clientKeyStorePath, MutualSSLManager.getPropertyValue("Carbon.Security.KeyStore.Password"));
                    MutualSSLManager.loadTrustStore(clientTrustStorePath, MutualSSLManager.getPropertyValue("Carbon.Security.TrustStore.Password"));
                    MutualSSLManager.initMutualSSLConnection(Boolean.parseBoolean(MutualSSLManager.getPropertyValue("hostname.verification.enabled")));
                    MutualSSLManager.initialized = true;
                }
            }
            catch (IOException | AuthenticationException e) {
                MutualSSLManager.log.error((Object)"Initialization failed : ", (Throwable)e);
            }
        }
    }

    private static boolean isMutualSSLManagerEnabled(String mutualSSLManagerEnabled) {
        boolean isMutualSSLManagerEnabled = true;
        if (StringUtils.isNotEmpty((String)mutualSSLManagerEnabled)) {
            isMutualSSLManagerEnabled = Boolean.parseBoolean(mutualSSLManagerEnabled);
        }
        return isMutualSSLManagerEnabled;
    }

    private static String buildFilePath(String path) throws IOException {
        if (StringUtils.isNotEmpty((String)path) && path.startsWith(".")) {
            File currentDirectory = new File(new File(".").getAbsolutePath());
            path = currentDirectory.getCanonicalPath() + File.separator + path;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("File path for KeyStore/TrustStore : " + path));
        }
        return path;
    }

    protected static String getPropertyValue(String key) {
        if ("identity.server.serviceURL".equals(key) && !prop.containsKey("identity.server.serviceURL")) {
            String serviceUrl = IdentityUtil.getServicePath();
            return IdentityUtil.getServerURL((String)serviceUrl, (boolean)true, (boolean)true);
        }
        return prop.getProperty(key);
    }

    private static void resolveSecrets(Properties properties) {
        SecretResolver secretResolver;
        String secretProvider = (String)properties.get(SECRET_PROVIDER);
        if (StringUtils.isBlank((String)secretProvider)) {
            properties.put(SECRET_PROVIDER, DEFAULT_CALLBACK_HANDLER);
        }
        if ((secretResolver = SecretResolverFactory.create((Properties)properties)) != null && secretResolver.isInitialized()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (value != null) {
                    value = MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
                }
                properties.put(key, value);
            }
        }
        if (MutualSSLManager.isSecuredPropertyAvailable(properties)) {
            SecretResolver resolver = SecretResolverFactory.create((Properties)properties, (String)"");
            String protectedTokens = (String)properties.get(PROTECTED_TOKENS);
            StringTokenizer st = new StringTokenizer(protectedTokens, ",");
            while (st.hasMoreElements()) {
                String element = st.nextElement().toString().trim();
                if (resolver.isTokenProtected(element)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resolving and replacing secret for " + element));
                    }
                    properties.put(element, resolver.resolve(element));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No encryption done for value with key :" + element));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Secure vault encryption ignored since no protected tokens available");
        }
    }

    private static boolean isSecuredPropertyAvailable(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!PROTECTED_TOKENS.equals(key) || !StringUtils.isNotBlank((String)properties.getProperty(key))) continue;
            return true;
        }
        return false;
    }

    public static void loadKeyStore(String keyStorePath, String keyStorePassword) throws AuthenticationException {
        try {
            MutualSSLManager.keyStorePassword = keyStorePassword.toCharArray();
            keyStore = KeyStore.getInstance("JKS");
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                keyStore.load(fis, MutualSSLManager.keyStorePassword);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AuthenticationException("Error while trying to load Key Store.", e);
        }
    }

    public static void loadTrustStore(String trustStorePath, String trustStorePassword) throws AuthenticationException {
        try {
            trustStore = KeyStore.getInstance("JKS");
            try (FileInputStream is = new FileInputStream(trustStorePath);){
                trustStore.load(is, trustStorePassword.toCharArray());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AuthenticationException("Error while trying to load Trust Store.", e);
        }
    }

    public static void initMutualSSLConnection(boolean hostNameVerificationEnabled) throws AuthenticationException {
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, keyStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(protocol);
            if (hostNameVerificationEnabled) {
                sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                sslSocketFactory = sslContext.getSocketFactory();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mutual SSL Client initialized with Hostname Verification enabled");
                }
            } else {
                HostnameVerifier hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                };
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                sslContext.init(keyManagerFactory.getKeyManagers(), trustAllCerts, new SecureRandom());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SSL Context is initialized with trust manager for excluding certificate validation");
                }
                SSLContext.setDefault(sslContext);
                sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection.setDefaultHostnameVerifier(hv);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Mutual SSL Client initialized with Hostname Verification disabled");
                }
            }
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new AuthenticationException("Error while trying to load Trust Store.", e);
        }
    }

    public static SSLSocketFactory getSslSocketFactory() {
        return sslSocketFactory;
    }

    public static String getCarbonLogin() {
        return carbonLogin;
    }

    public static String getUsernameHeaderName() {
        return usernameHeaderName;
    }

    static {
        carbonLogin = "";
        usernameHeaderName = "";
        initialized = false;
    }
}

