/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class EndpointConfigManager {
    private static final Log log = LogFactory.getLog(EndpointConfigManager.class);
    private static final String PROTECTED_TOKENS = "protectedTokens";
    private static final String DEFAULT_CALLBACK_HANDLER = "org.wso2.carbon.securevault.DefaultSecretCallbackHandler";
    private static final String SECRET_PROVIDER = "secretProvider";
    private static Properties prop;
    private static String appName;
    private static char[] appPassword;
    private static String serverOrigin;
    private static boolean initialized;

    public static void init() {
        try {
            if (!initialized) {
                prop = new Properties();
                String configFilePath = EndpointConfigManager.buildFilePath("./repository/conf/identity/EndpointConfig.properties");
                File configFile = new File(configFilePath);
                if (configFile.exists()) {
                    log.info((Object)"EndpointConfig.properties file loaded from ./repository/conf/identity/EndpointConfig.properties");
                    FileInputStream inputStream = new FileInputStream(configFile);
                    prop.load(inputStream);
                    EndpointConfigManager.resolveSecrets(prop);
                } else {
                    InputStream inputStream = EndpointConfigManager.class.getClassLoader().getResourceAsStream("EndpointConfig.properties");
                    if (inputStream != null) {
                        prop.load(inputStream);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"EndpointConfig.properties file loaded from authentication endpoint webapp");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"EndpointConfig.properties could not be located in ./repository/conf/identity/EndpointConfig.properties or authentication endpoint webapp");
                    }
                }
                appName = EndpointConfigManager.getPropertyValue("app.name");
                appPassword = EndpointConfigManager.getPropertyValue("app.password").toCharArray();
                serverOrigin = EndpointConfigManager.getPropertyValue("identity.server.origin");
                if (StringUtils.isNotBlank((String)serverOrigin)) {
                    serverOrigin = IdentityUtil.fillURLPlaceholders((String)serverOrigin);
                }
                initialized = true;
            }
        }
        catch (IOException e) {
            log.error((Object)"Initialization failed : ", (Throwable)e);
        }
    }

    public static String getAppName() {
        return appName;
    }

    public static char[] getAppPassword() {
        return appPassword;
    }

    public static String getServerOrigin() {
        return serverOrigin;
    }

    private static String buildFilePath(String path) throws IOException {
        if (StringUtils.isNotEmpty((String)path) && path.startsWith(".")) {
            File currentDirectory = new File(new File(".").getAbsolutePath());
            path = currentDirectory.getCanonicalPath() + File.separator + path;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("File path for KeyStore/TrustStore : " + path));
        }
        return path;
    }

    private static String getPropertyValue(String key) {
        if ("identity.server.serviceURL".equals(key) && !prop.containsKey("identity.server.serviceURL")) {
            String serviceUrl = IdentityUtil.getServicePath();
            return IdentityUtil.getServerURL((String)serviceUrl, (boolean)true, (boolean)true);
        }
        return prop.getProperty(key);
    }

    private static boolean isSecuredPropertyAvailable(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!PROTECTED_TOKENS.equals(key) || !StringUtils.isNotBlank((String)properties.getProperty(key))) continue;
            return true;
        }
        return false;
    }

    private static void resolveSecrets(Properties properties) {
        SecretResolver secretResolver;
        String secretProvider = (String)properties.get(SECRET_PROVIDER);
        if (StringUtils.isBlank((String)secretProvider)) {
            properties.put(SECRET_PROVIDER, DEFAULT_CALLBACK_HANDLER);
        }
        if ((secretResolver = SecretResolverFactory.create((Properties)properties)) != null && secretResolver.isInitialized()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (value != null) {
                    value = MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
                }
                properties.put(key, value);
            }
        }
        if (EndpointConfigManager.isSecuredPropertyAvailable(properties)) {
            SecretResolver resolver = SecretResolverFactory.create((Properties)properties, (String)"");
            String protectedTokens = (String)properties.get(PROTECTED_TOKENS);
            StringTokenizer st = new StringTokenizer(protectedTokens, ",");
            while (st.hasMoreElements()) {
                String element = st.nextElement().toString().trim();
                if (resolver.isTokenProtected(element)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resolving and replacing secret for " + element));
                    }
                    properties.put(element, resolver.resolve(element));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No encryption done for value with key :" + element));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Secure vault encryption ignored since no protected tokens available");
        }
    }

    static {
        appName = null;
        appPassword = null;
        initialized = false;
    }
}

