/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class EncodedControl
extends ResourceBundle.Control {
    public static final String JAVA_PROPERTIES = "java.properties";
    public static final String PROPERTIES = "properties";
    private String encoding;

    public EncodedControl(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        InputStream stream;
        if (!format.equals(JAVA_PROPERTIES)) {
            return super.newBundle(baseName, locale, format, loader, reload);
        }
        String bundleName = this.toBundleName(baseName, locale);
        PropertyResourceBundle bundle = null;
        String resourceName = this.toResourceName(bundleName, PROPERTIES);
        ClassLoader classLoader = loader;
        boolean reloadFlag = reload;
        try {
            stream = this.getStream(resourceName, classLoader, reloadFlag);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (stream != null) {
            try {
                InputStreamReader reader = new InputStreamReader(stream, this.encoding);
                bundle = new PropertyResourceBundle(reader);
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }

    private InputStream getStream(final String resourceName, final ClassLoader classLoader, final boolean reloadFlag) throws PrivilegedActionException, IOException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws IOException {
                InputStream is = null;
                if (reloadFlag) {
                    URLConnection connection;
                    URL url = classLoader.getResource(resourceName);
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        is = connection.getInputStream();
                    }
                } else {
                    is = classLoader.getResourceAsStream(resourceName);
                }
                return is;
            }
        });
    }
}

