/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.lang.StringUtils;
import org.owasp.encoder.Encode;
import org.wso2.carbon.identity.application.authentication.endpoint.util.bean.UserDTO;
import org.wso2.carbon.user.core.UserCoreConstants;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthenticationEndpointUtil {
    private static final String CUSTOM_PAGE_APP_SPECIFIC_CONFIG_KEY_SEPARATOR = "-";
    private static final String QUERY_STRING_APPENDER = "&";
    private static final String QUERY_STRING_INITIATOR = "?";
    private static final String PADDING_CHAR = "=";
    private static final String UNDERSCORE = "_";

    private AuthenticationEndpointUtil() {
    }

    public static String getApplicationSpecificCustomPageConfigKey(String serviceProviderName, String relativePath) {
        return serviceProviderName + CUSTOM_PAGE_APP_SPECIFIC_CONFIG_KEY_SEPARATOR + relativePath;
    }

    public static String getCustomPageRedirectUrl(String customPageConfigValue, String queryString) {
        String redirectUrl = customPageConfigValue;
        if (customPageConfigValue != null && queryString != null && !queryString.isEmpty()) {
            redirectUrl = customPageConfigValue.indexOf(QUERY_STRING_INITIATOR) > 0 ? customPageConfigValue + QUERY_STRING_APPENDER + queryString : customPageConfigValue + QUERY_STRING_INITIATOR + queryString;
        }
        return redirectUrl;
    }

    public static String cleanErrorMessages(String queryString) {
        StringBuilder cleanedQueryString = new StringBuilder();
        if (queryString != null) {
            String[] split = queryString.split(QUERY_STRING_APPENDER);
            for (int i = 0; i < split.length; ++i) {
                String query = split[i];
                if (query.startsWith("authFailure") || query.startsWith("errorCode")) continue;
                cleanedQueryString.append(query);
                cleanedQueryString.append(QUERY_STRING_APPENDER);
            }
            if (cleanedQueryString.length() > 0 && cleanedQueryString.charAt(cleanedQueryString.length() - 1) == '&') {
                return cleanedQueryString.substring(0, cleanedQueryString.length() - 1);
            }
        }
        return cleanedQueryString.toString();
    }

    public static UserDTO getUser(String userName) {
        if (userName == null) {
            return null;
        }
        String userStoreDomain = AuthenticationEndpointUtil.extractDomainFromName(userName);
        String tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        String userNameWithoutTenantDomainAndUserStoreDomain = MultitenantUtils.getTenantAwareUsername((String)UserCoreUtil.removeDomainFromName((String)userName));
        UserDTO user = new UserDTO();
        user.setUsername(userNameWithoutTenantDomainAndUserStoreDomain);
        user.setRealm(userStoreDomain);
        user.setTenantDomain(tenantDomain);
        return user;
    }

    public static String extractDomainFromName(String nameWithDomain) {
        if (nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR) > 0) {
            String domain = nameWithDomain.substring(0, nameWithDomain.indexOf(UserCoreConstants.DOMAIN_SEPARATOR));
            return domain.toUpperCase();
        }
        return null;
    }

    public static String i18n(ResourceBundle resourceBundle, String key) {
        try {
            return Encode.forHtml((String)(StringUtils.isNotBlank((String)resourceBundle.getString(key)) ? resourceBundle.getString(key) : key));
        }
        catch (Exception e) {
            return Encode.forHtml((String)key);
        }
    }

    public static String i18nBase64(ResourceBundle resourceBundle, String key) {
        String base64Key = Base64.encode((byte[])key.getBytes(StandardCharsets.UTF_8)).replaceAll(PADDING_CHAR, UNDERSCORE);
        try {
            return Encode.forHtml((String)(StringUtils.isNotBlank((String)resourceBundle.getString(base64Key)) ? resourceBundle.getString(base64Key) : key));
        }
        catch (Exception e) {
            return Encode.forHtml((String)key);
        }
    }

    public static String customi18n(ResourceBundle resourceBundle, String key) {
        try {
            return Encode.forHtml((String)(StringUtils.isNotBlank((String)resourceBundle.getString(key)) ? resourceBundle.getString(key) : key));
        }
        catch (Exception e) {
            return AuthenticationEndpointUtil.i18nBase64(resourceBundle, key);
        }
    }
}

