/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authentication.endpoint.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class AdaptiveAuthUtil {
    private static final Log log = LogFactory.getLog(AdaptiveAuthUtil.class);
    private static Map<String, String> adaptiveAuthConfigs = new HashMap<String, String>();

    private AdaptiveAuthUtil() {
    }

    public static void init() {
        block27: {
            try {
                String configFilePath = AdaptiveAuthUtil.buildFilePath("./repository/conf/identity/identity.xml");
                File configFile = new File(configFilePath);
                if (configFile.exists()) {
                    adaptiveAuthConfigs.put("AdaptiveAuth.HTTPConnectionTimeout", IdentityUtil.getProperty((String)"AdaptiveAuth.HTTPConnectionTimeout"));
                    adaptiveAuthConfigs.put("AdaptiveAuth.RefreshInterval", IdentityUtil.getProperty((String)"AdaptiveAuth.RefreshInterval"));
                    break block27;
                }
                Properties props = new Properties();
                InputStream inputStream = AdaptiveAuthUtil.class.getClassLoader().getResourceAsStream("EndpointConfig.properties");
                Object object = null;
                try {
                    if (inputStream != null) {
                        props.load(inputStream);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"EndpointConfig.properties file loaded from authentication endpoint webapp");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Input stream is null while loading authentication endpoint from webapp");
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        if (object != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
                Set<String> keys = props.stringPropertyNames();
                object = keys.iterator();
                while (object.hasNext()) {
                    String key;
                    switch (key = (String)object.next()) {
                        case "AdaptiveAuth.HTTPConnectionTimeout": 
                        case "AdaptiveAuth.RefreshInterval": {
                            adaptiveAuthConfigs.put(key, props.getProperty(key));
                        }
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while loading configs for adaptive authentication.", (Throwable)e);
            }
        }
    }

    private static String buildFilePath(String path) throws IOException {
        if (StringUtils.isNotEmpty((String)path) && path.startsWith(".")) {
            File currentDirectory = new File(new File(".").getAbsolutePath());
            path = currentDirectory.getCanonicalPath() + File.separator + path;
        }
        return path;
    }

    public static int getRequestTimeout() {
        return AdaptiveAuthUtil.getConfiguredTime(5000, "AdaptiveAuth.HTTPConnectionTimeout");
    }

    public static int getRefreshInterval() {
        return AdaptiveAuthUtil.getConfiguredTime(500, "AdaptiveAuth.RefreshInterval");
    }

    private static int getConfiguredTime(int defaultValue, String propertyName) {
        String connectionTimeoutString = adaptiveAuthConfigs.get(propertyName);
        int connectionTimeout = defaultValue;
        if (connectionTimeoutString != null) {
            try {
                connectionTimeout = Integer.parseInt(connectionTimeoutString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return connectionTimeout;
    }
}

