/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.transport.socket.nio.support;

import java.util.Queue;
import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.IoFilter;
import org.wso2.org.apache.mina.common.IoSession;
import org.wso2.org.apache.mina.common.support.AbstractIoFilterChain;
import org.wso2.org.apache.mina.transport.socket.nio.support.DatagramAcceptorDelegate;
import org.wso2.org.apache.mina.transport.socket.nio.support.DatagramConnectorDelegate;
import org.wso2.org.apache.mina.transport.socket.nio.support.DatagramService;
import org.wso2.org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;

class DatagramFilterChain
extends AbstractIoFilterChain {
    DatagramFilterChain(IoSession parent) {
        super(parent);
    }

    @Override
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        Queue<IoFilter.WriteRequest> writeRequestQueue = s.getWriteRequestQueue();
        ByteBuffer buffer = (ByteBuffer)writeRequest.getMessage();
        buffer.mark();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            s.increaseScheduledWriteRequests();
        } else {
            s.increaseScheduledWriteBytes(buffer.remaining());
        }
        writeRequestQueue.add(writeRequest);
        if (session.getTrafficMask().isWritable()) {
            s.getManagerDelegate().flushSession(s);
        }
    }

    @Override
    protected void doClose(IoSession session) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        DatagramService manager = s.getManagerDelegate();
        if (manager instanceof DatagramConnectorDelegate) {
            manager.closeSession(s);
        } else {
            ((DatagramAcceptorDelegate)manager).getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
        }
    }
}

