/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.org.apache.mina.filter.codec.support;

import java.util.LinkedList;
import java.util.Queue;
import org.wso2.org.apache.mina.common.ByteBuffer;
import org.wso2.org.apache.mina.common.WriteFuture;
import org.wso2.org.apache.mina.filter.codec.ProtocolEncoderOutput;

public abstract class SimpleProtocolEncoderOutput
implements ProtocolEncoderOutput {
    private final Queue<ByteBuffer> bufferQueue = new LinkedList<ByteBuffer>();

    public Queue<ByteBuffer> getBufferQueue() {
        return this.bufferQueue;
    }

    @Override
    public void write(ByteBuffer buf) {
        this.bufferQueue.add(buf);
    }

    @Override
    public void mergeAll() {
        ByteBuffer byteBuffer;
        int sum = 0;
        int size = this.bufferQueue.size();
        if (size < 2) {
            return;
        }
        for (Object e : this.bufferQueue) {
            sum += ((ByteBuffer)e).remaining();
        }
        ByteBuffer newBuf = ByteBuffer.allocate(sum);
        while ((byteBuffer = this.bufferQueue.poll()) != null) {
            newBuf.put(byteBuffer);
            byteBuffer.release();
        }
        newBuf.flip();
        this.bufferQueue.offer(newBuf);
    }

    @Override
    public WriteFuture flush() {
        ByteBuffer buf;
        Queue<ByteBuffer> bufferQueue = this.bufferQueue;
        WriteFuture future = null;
        if (bufferQueue.isEmpty()) {
            return null;
        }
        while ((buf = bufferQueue.poll()) != null) {
            if (!buf.hasRemaining()) continue;
            future = this.doFlush(buf);
        }
        return future;
    }

    protected abstract WriteFuture doFlush(ByteBuffer var1);
}

