/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.wso2.jndi;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.jndi.PropertiesFileInitialContextFactory;
import org.wso2.andes.util.Strings;

public class TenantAwareInitialContextFactory
extends PropertiesFileInitialContextFactory {
    private static final Logger _logger = LoggerFactory.getLogger(TenantAwareInitialContextFactory.class);
    private static final String TRANSPORT_CON_FAC = "transport.jms.ConnectionFactoryJNDIName";
    private static final String DEFAULT_CON_FAC = "org.apache.qpid.wso2.default.ConnectionFactoryJNDIName";
    private static final String USERNAEM_START_TOKEN = "://";
    private static final String USERNAME_END_TOKEN = ":";
    private static final String DOMAIN_NAME_SEPARATOR = "@";
    private static final String DOMAIN_NAME_SEPARATOR_INTERNAL = "!";

    @Override
    public Context getInitialContext(Hashtable environment) throws NamingException {
        ConcurrentHashMap data = new ConcurrentHashMap();
        this.loadPropertiesFromFile(environment);
        String tenantDomain = this.getTenantDomain(environment);
        if (!tenantDomain.isEmpty()) {
            this.makeNamesTenantAware(environment, tenantDomain);
        }
        this.createConnectionFactories(data, environment);
        this.createQueues(data, environment);
        this.createTopics(data, environment);
        this.createDestinations(data, environment);
        return this.createContext(data, environment);
    }

    private void loadPropertiesFromFile(Hashtable environment) {
        try {
            String file = null;
            file = environment.containsKey("java.naming.provider.url") ? (String)environment.get("java.naming.provider.url") : System.getProperty("java.naming.provider.url");
            if (file != null) {
                _logger.info("Loading Properties from:" + file);
                Properties p = this.loadProperties(file);
                Strings.ChainedResolver resolver = new Strings.ChainedResolver(Strings.SYSTEM_RESOLVER, new Strings.PropertiesResolver(p));
                for (Map.Entry<Object, Object> me : p.entrySet()) {
                    String key = (String)me.getKey();
                    String value = (String)me.getValue();
                    String expanded = Strings.expand(value, resolver);
                    environment.put(key, expanded);
                    if (System.getProperty(key) != null) continue;
                    System.setProperty(key, expanded);
                }
                _logger.info("Loaded Context Properties:" + environment.toString());
            } else {
                _logger.info("No Provider URL specified.");
            }
        }
        catch (IOException ioe) {
            _logger.warn("Unable to load property file specified in Provider_URL:" + environment.get("java.naming.provider.url") + "\nDue to:" + ioe.getMessage());
        }
    }

    private String getTenantDomain(Hashtable environment) {
        int domainNameSeparatorIndex;
        int endIndex;
        String username;
        int startIndex;
        String defaultConnectionFactory;
        String tenantDomain = "";
        String defaultConnectionFactoryName = null;
        if (environment.containsKey(TRANSPORT_CON_FAC)) {
            defaultConnectionFactoryName = (String)environment.get(TRANSPORT_CON_FAC);
        } else if (environment.containsKey(DEFAULT_CON_FAC)) {
            defaultConnectionFactoryName = (String)environment.get(DEFAULT_CON_FAC);
        }
        if (null != defaultConnectionFactoryName && null != (defaultConnectionFactory = (String)environment.get(this.getConnectionPrefix() + defaultConnectionFactoryName)) && -1 != (startIndex = defaultConnectionFactory.indexOf(USERNAEM_START_TOKEN)) && null != (username = defaultConnectionFactory.substring(startIndex += USERNAEM_START_TOKEN.length(), endIndex = defaultConnectionFactory.indexOf(USERNAME_END_TOKEN, startIndex))) && -1 != (domainNameSeparatorIndex = username.indexOf(DOMAIN_NAME_SEPARATOR))) {
            tenantDomain = username.substring(domainNameSeparatorIndex + 1);
            if (null != tenantDomain) {
                tenantDomain = tenantDomain.replace(".", "-");
            }
            String defaultConnectionFactoryInternal = this.getInternalConnectionURL(defaultConnectionFactory, startIndex + domainNameSeparatorIndex);
            environment.put(this.getConnectionPrefix() + defaultConnectionFactoryName, defaultConnectionFactoryInternal);
        }
        return tenantDomain;
    }

    private String getInternalConnectionURL(String connectionURL, int domainNameSeparatorIndex) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(connectionURL.substring(0, domainNameSeparatorIndex));
        buffer.append(DOMAIN_NAME_SEPARATOR_INTERNAL);
        buffer.append(connectionURL.substring(domainNameSeparatorIndex + 1));
        return buffer.toString();
    }

    private void makeNamesTenantAware(Hashtable environment, String domainName) {
        for (Map.Entry entry : environment.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(this.getDestinationPrefix()) && !key.startsWith(this.getQueuePrefix()) && !key.startsWith(this.getTopicPrefix())) continue;
            String physicalName = (String)entry.getValue();
            entry.setValue(domainName + "-" + physicalName);
        }
    }

    private void setEnvironmentProperties(Properties properties, Hashtable environment, String jndiNamePrefix) {
        Strings.ChainedResolver resolver = new Strings.ChainedResolver(Strings.SYSTEM_RESOLVER, new Strings.PropertiesResolver(properties));
        for (Map.Entry<Object, Object> me : properties.entrySet()) {
            String key = new StringBuffer(jndiNamePrefix).append((String)me.getKey()).toString();
            String value = (String)me.getValue();
            String expanded = Strings.expand(value, resolver);
            environment.put(key, expanded);
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, expanded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String propertyFile) throws IOException {
        Properties p1;
        FilterInputStream dis = null;
        BufferedReader br = null;
        try {
            String eachLine;
            dis = new DataInputStream(new FileInputStream(propertyFile));
            br = new BufferedReader(new InputStreamReader(dis));
            p1 = new Properties();
            while ((eachLine = br.readLine()) != null) {
                int eqIndex = eachLine.indexOf(61);
                p1.put(eachLine.substring(0, eqIndex), eachLine.substring(eqIndex + 1));
            }
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return p1;
    }
}

