/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.security.sasl;

import javax.security.sasl.SaslClient;
import org.wso2.andes.transport.Connection;
import org.wso2.andes.transport.ConnectionException;
import org.wso2.andes.transport.ConnectionListener;

public abstract class SASLEncryptor
implements ConnectionListener {
    protected SaslClient saslClient;
    protected boolean securityLayerEstablished = false;
    protected int sendBuffSize;
    protected int recvBuffSize;

    public boolean isSecurityLayerEstablished() {
        return this.securityLayerEstablished;
    }

    @Override
    public void opened(Connection conn) {
        if (conn.getSaslClient() != null) {
            this.saslClient = conn.getSaslClient();
            if (this.saslClient.isComplete() && this.saslClient.getNegotiatedProperty("javax.security.sasl.qop") == "auth-conf") {
                this.sendBuffSize = Integer.parseInt((String)this.saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
                this.recvBuffSize = Integer.parseInt((String)this.saslClient.getNegotiatedProperty("javax.security.sasl.maxbuffer"));
                this.securityLayerEstablished();
                this.securityLayerEstablished = true;
            }
        }
    }

    @Override
    public void exception(Connection conn, ConnectionException exception) {
    }

    @Override
    public void closed(Connection conn) {
    }

    public abstract void securityLayerEstablished();
}

