/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.codec;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.wso2.andes.transport.Binary;
import org.wso2.andes.transport.codec.AbstractDecoder;

public final class BBDecoder
extends AbstractDecoder {
    private ByteBuffer in;

    public void init(ByteBuffer in) {
        this.in = in;
        this.in.order(ByteOrder.BIG_ENDIAN);
    }

    public void releaseBuffer() {
        this.in = null;
    }

    @Override
    protected byte doGet() {
        return this.in.get();
    }

    @Override
    protected void doGet(byte[] bytes) {
        this.in.get(bytes);
    }

    @Override
    protected Binary get(int size) {
        if (this.in.hasArray()) {
            byte[] bytes = this.in.array();
            Binary bin = new Binary(bytes, this.in.arrayOffset() + this.in.position(), size);
            this.in.position(this.in.position() + size);
            return bin;
        }
        return super.get(size);
    }

    @Override
    public boolean hasRemaining() {
        return this.in.hasRemaining();
    }

    @Override
    public short readUint8() {
        return (short)(0xFF & this.in.get());
    }

    @Override
    public int readUint16() {
        return 0xFFFF & this.in.getShort();
    }

    @Override
    public long readUint32() {
        return 0xFFFFFFFFL & (long)this.in.getInt();
    }

    @Override
    public long readUint64() {
        return this.in.getLong();
    }

    @Override
    public byte[] readBin128() {
        byte[] result = new byte[16];
        this.get(result);
        return result;
    }

    @Override
    public byte[] readBytes(int howManyBytes) {
        byte[] result = new byte[howManyBytes];
        this.get(result);
        return result;
    }

    @Override
    public double readDouble() {
        return this.in.getDouble();
    }

    @Override
    public float readFloat() {
        return this.in.getFloat();
    }

    @Override
    public short readInt16() {
        return this.in.getShort();
    }

    @Override
    public int readInt32() {
        return this.in.getInt();
    }

    @Override
    public byte readInt8() {
        return this.in.get();
    }

    @Override
    public byte[] readReaminingBytes() {
        byte[] result = new byte[this.in.limit() - this.in.position()];
        this.get(result);
        return result;
    }

    @Override
    public long readInt64() {
        return this.in.getLong();
    }
}

