/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class QueuePurge
extends Method {
    public static final int TYPE = 2051;
    private short packing_flags = 0;
    private String queue;

    @Override
    public final int getStructType() {
        return 2051;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public QueuePurge() {
    }

    public QueuePurge(String queue, Option ... _options) {
        if (queue != null) {
            this.setQueue(queue);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.queuePurge(context, this);
    }

    public final boolean hasQueue() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final QueuePurge clearQueue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.queue = null;
        this.dirty = true;
        return this;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final QueuePurge setQueue(String value) {
        this.queue = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final QueuePurge queue(String value) {
        return this.setQueue(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.queue);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.queue = dec.readStr8();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("queue", this.getQueue());
        }
        return result;
    }
}

