/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.wso2.andes.transport.Method;
import org.wso2.andes.transport.MethodDelegate;
import org.wso2.andes.transport.Option;
import org.wso2.andes.transport.codec.Decoder;
import org.wso2.andes.transport.codec.Encoder;

public final class ConnectionRedirect
extends Method {
    public static final int TYPE = 265;
    private short packing_flags = 0;
    private String host;
    private List<Object> knownHosts;

    @Override
    public final int getStructType() {
        return 265;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 0;
    }

    @Override
    public final boolean isConnectionControl() {
        return true;
    }

    public ConnectionRedirect() {
    }

    public ConnectionRedirect(String host, List<Object> knownHosts, Option ... _options) {
        if (host != null) {
            this.setHost(host);
        }
        if (knownHosts != null) {
            this.setKnownHosts(knownHosts);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.connectionRedirect(context, this);
    }

    public final boolean hasHost() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ConnectionRedirect clearHost() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.host = null;
        this.dirty = true;
        return this;
    }

    public final String getHost() {
        return this.host;
    }

    public final ConnectionRedirect setHost(String value) {
        this.host = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final ConnectionRedirect host(String value) {
        return this.setHost(value);
    }

    public final boolean hasKnownHosts() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ConnectionRedirect clearKnownHosts() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.knownHosts = null;
        this.dirty = true;
        return this;
    }

    public final List<Object> getKnownHosts() {
        return this.knownHosts;
    }

    public final ConnectionRedirect setKnownHosts(List<Object> value) {
        this.knownHosts = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final ConnectionRedirect knownHosts(List<Object> value) {
        return this.setKnownHosts(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr16(this.host);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeArray(this.knownHosts);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.host = dec.readStr16();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.knownHosts = dec.readArray();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("host", this.getHost());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("knownHosts", this.getKnownHosts());
        }
        return result;
    }
}

