/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing.amqp_0_9;

import org.wso2.andes.AMQException;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQMethodBody;
import org.wso2.andes.framing.AMQMethodBodyInstanceFactory;
import org.wso2.andes.framing.MethodDispatcher;
import org.wso2.andes.framing.StreamQosBody;
import org.wso2.andes.framing.amqp_0_9.AMQMethodBody_0_9;
import org.wso2.andes.framing.amqp_0_9.MethodDispatcher_0_9;
import org.wso2.org.apache.mina.common.ByteBuffer;

public class StreamQosBodyImpl
extends AMQMethodBody_0_9
implements StreamQosBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new StreamQosBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 10;
    private final long _prefetchSize;
    private final int _prefetchCount;
    private final long _consumeRate;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamQosBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._prefetchSize = this.readUnsignedInteger(buffer);
        this._prefetchCount = this.readUnsignedShort(buffer);
        this._consumeRate = this.readUnsignedInteger(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public StreamQosBodyImpl(long prefetchSize, int prefetchCount, long consumeRate, boolean global) {
        this._prefetchSize = prefetchSize;
        this._prefetchCount = prefetchCount;
        this._consumeRate = consumeRate;
        byte bitfield0 = 0;
        if (global) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 80;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final long getPrefetchSize() {
        return this._prefetchSize;
    }

    @Override
    public final int getPrefetchCount() {
        return this._prefetchCount;
    }

    @Override
    public final long getConsumeRate() {
        return this._consumeRate;
    }

    @Override
    public final boolean getGlobal() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 11;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedInteger(buffer, this._prefetchSize);
        this.writeUnsignedShort(buffer, this._prefetchCount);
        this.writeUnsignedInteger(buffer, this._consumeRate);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchStreamQos(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamQosBodyImpl: ");
        buf.append("prefetchSize=");
        buf.append(this.getPrefetchSize());
        buf.append(", ");
        buf.append("prefetchCount=");
        buf.append(this.getPrefetchCount());
        buf.append(", ");
        buf.append("consumeRate=");
        buf.append(this.getConsumeRate());
        buf.append(", ");
        buf.append("global=");
        buf.append(this.getGlobal());
        buf.append("]");
        return buf.toString();
    }
}

