/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.framing;

import java.math.BigDecimal;
import org.wso2.andes.framing.AMQFrameDecodingException;
import org.wso2.andes.framing.AMQTypedValue;
import org.wso2.andes.framing.EncodingUtils;
import org.wso2.andes.framing.FieldTable;
import org.wso2.org.apache.mina.common.ByteBuffer;

public enum AMQType {
    LONG_STRING('S'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongStringLength((String)value);
        }

        @Override
        public String toNativeValue(Object value) {
            if (value != null) {
                return value.toString();
            }
            throw new NullPointerException("Cannot convert: null to String.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeLongStringBytes(buffer, (String)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readLongString(buffer);
        }
    }
    ,
    INTEGER('i'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.unsignedIntegerLength();
        }

        @Override
        public Long toNativeValue(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof String || value == null) {
                return Long.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to int.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeUnsignedInteger(buffer, (Long)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readUnsignedInteger(buffer);
        }
    }
    ,
    DECIMAL('D'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedByteLength() + EncodingUtils.encodedIntegerLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to BigDecimal.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            BigDecimal bd = (BigDecimal)value;
            byte places = new Integer(bd.scale()).byteValue();
            int unscaled = bd.intValue();
            EncodingUtils.writeByte(buffer, places);
            EncodingUtils.writeInteger(buffer, unscaled);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            byte places = EncodingUtils.readByte(buffer);
            int unscaled = EncodingUtils.readInteger(buffer);
            BigDecimal bd = new BigDecimal(unscaled);
            return bd.setScale(places);
        }
    }
    ,
    TIMESTAMP('T'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to timestamp.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeLong(buffer, (Long)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readLong(buffer);
        }
    }
    ,
    FIELD_TABLE('F'){

        @Override
        public int getEncodingSize(Object value) {
            if (!(value instanceof FieldTable)) {
                throw new IllegalArgumentException("Value is not a FieldTable.");
            }
            FieldTable ftValue = (FieldTable)value;
            return EncodingUtils.encodedFieldTableLength(ftValue);
        }

        @Override
        public Object toNativeValue(Object value) {
            if (!(value instanceof FieldTable)) {
                throw new IllegalArgumentException("Value is not a FieldTable.");
            }
            return (FieldTable)value;
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            if (!(value instanceof FieldTable)) {
                throw new IllegalArgumentException("Value is not a FieldTable.");
            }
            FieldTable ftValue = (FieldTable)value;
            ftValue.writeToBuffer(buffer);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            try {
                return EncodingUtils.readFieldTable(buffer);
            }
            catch (AMQFrameDecodingException e) {
                throw new IllegalArgumentException("Unable to read field table from buffer.", e);
            }
        }
    }
    ,
    VOID('V'){

        @Override
        public int getEncodingSize(Object value) {
            return 0;
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value == null) {
                return null;
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to null String.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return null;
        }
    }
    ,
    BINARY('x'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongstrLength((byte[])value);
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof byte[] || value == null) {
                return value;
            }
            throw new IllegalArgumentException("Value: " + value + " (" + value.getClass().getName() + ") cannot be converted to byte[]");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeLongstr(buffer, (byte[])value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readLongstr(buffer);
        }
    }
    ,
    ASCII_STRING('c'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongStringLength((String)value);
        }

        @Override
        public String toNativeValue(Object value) {
            if (value != null) {
                return value.toString();
            }
            throw new NullPointerException("Cannot convert: null to String.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeLongStringBytes(buffer, (String)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readLongString(buffer);
        }
    }
    ,
    WIDE_STRING('C'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongStringLength((String)value);
        }

        @Override
        public String toNativeValue(Object value) {
            if (value != null) {
                return value.toString();
            }
            throw new NullPointerException("Cannot convert: null to String.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeLongStringBytes(buffer, (String)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readLongString(buffer);
        }
    }
    ,
    BOOLEAN('t'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedBooleanLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String || value == null) {
                return Boolean.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to boolean.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeBoolean(buffer, (Boolean)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readBoolean(buffer);
        }
    }
    ,
    ASCII_CHARACTER('k'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedCharLength();
        }

        @Override
        public Character toNativeValue(Object value) {
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value == null) {
                throw new NullPointerException("Cannot convert null into char");
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to char.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeChar(buffer, ((Character)value).charValue());
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return Character.valueOf(EncodingUtils.readChar(buffer));
        }
    }
    ,
    BYTE('b'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedByteLength();
        }

        @Override
        public Byte toNativeValue(Object value) {
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof String || value == null) {
                return Byte.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to byte.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeByte(buffer, (Byte)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readByte(buffer);
        }
    }
    ,
    SHORT('s'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedShortLength();
        }

        @Override
        public Short toNativeValue(Object value) {
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Byte) {
                return ((Byte)value).shortValue();
            }
            if (value instanceof String || value == null) {
                return Short.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to short.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeShort(buffer, (Short)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readShort(buffer);
        }
    }
    ,
    INT('I'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedIntegerLength();
        }

        @Override
        public Integer toNativeValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Short) {
                return ((Short)value).intValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).intValue();
            }
            if (value instanceof String || value == null) {
                return Integer.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to int.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeInteger(buffer, (Integer)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readInteger(buffer);
        }
    }
    ,
    LONG('l'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedLongLength();
        }

        @Override
        public Object toNativeValue(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof Short) {
                return ((Short)value).longValue();
            }
            if (value instanceof Byte) {
                return ((Byte)value).longValue();
            }
            if (value instanceof String || value == null) {
                return Long.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to long.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeLong(buffer, (Long)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readLong(buffer);
        }
    }
    ,
    FLOAT('f'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedFloatLength();
        }

        @Override
        public Float toNativeValue(Object value) {
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof String || value == null) {
                return Float.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to float.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeFloat(buffer, (Float)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return Float.valueOf(EncodingUtils.readFloat(buffer));
        }
    }
    ,
    DOUBLE('d'){

        @Override
        public int getEncodingSize(Object value) {
            return EncodingUtils.encodedDoubleLength();
        }

        @Override
        public Double toNativeValue(Object value) {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Float) {
                return ((Float)value).doubleValue();
            }
            if (value instanceof String || value == null) {
                return Double.valueOf((String)value);
            }
            throw new NumberFormatException("Cannot convert: " + value + "(" + value.getClass().getName() + ") to double.");
        }

        @Override
        public void writeValueImpl(Object value, ByteBuffer buffer) {
            EncodingUtils.writeDouble(buffer, (Double)value);
        }

        @Override
        public Object readValueFromBuffer(ByteBuffer buffer) {
            return EncodingUtils.readDouble(buffer);
        }
    };

    private final byte _identifier;

    private AMQType(char identifier) {
        this._identifier = (byte)identifier;
    }

    public final byte identifier() {
        return this._identifier;
    }

    public abstract int getEncodingSize(Object var1);

    public abstract Object toNativeValue(Object var1);

    public AMQTypedValue asTypedValue(Object value) {
        return new AMQTypedValue(this, this.toNativeValue(value));
    }

    public void writeToBuffer(Object value, ByteBuffer buffer) {
        buffer.put(this.identifier());
        this.writeValueImpl(value, buffer);
    }

    abstract void writeValueImpl(Object var1, ByteBuffer var2);

    abstract Object readValueFromBuffer(ByteBuffer var1);
}

