/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.filter;

import org.wso2.andes.AMQInternalException;
import org.wso2.andes.client.message.AbstractJMSMessage;
import org.wso2.andes.filter.BinaryExpression;
import org.wso2.andes.filter.BooleanExpression;

public abstract class LogicExpression
extends BinaryExpression
implements BooleanExpression {
    public static BooleanExpression createOR(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(AbstractJMSMessage message) throws AMQInternalException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv != null && lv.booleanValue()) {
                    return Boolean.TRUE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            @Override
            public String getExpressionSymbol() {
                return "OR";
            }
        };
    }

    public static BooleanExpression createAND(BooleanExpression lvalue, BooleanExpression rvalue) {
        return new LogicExpression(lvalue, rvalue){

            @Override
            public Object evaluate(AbstractJMSMessage message) throws AMQInternalException {
                Boolean lv = (Boolean)this.left.evaluate(message);
                if (lv == null) {
                    return null;
                }
                if (!lv.booleanValue()) {
                    return Boolean.FALSE;
                }
                Boolean rv = (Boolean)this.right.evaluate(message);
                return rv == null ? null : rv;
            }

            @Override
            public String getExpressionSymbol() {
                return "AND";
            }
        };
    }

    public LogicExpression(BooleanExpression left, BooleanExpression right) {
        super(left, right);
    }

    @Override
    public abstract Object evaluate(AbstractJMSMessage var1) throws AMQInternalException;

    @Override
    public boolean matches(AbstractJMSMessage message) throws AMQInternalException {
        Object object = this.evaluate(message);
        return object != null && object == Boolean.TRUE;
    }
}

