/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.security.AMQCallbackHandler;
import org.wso2.andes.client.security.DynamicSaslRegistrar;
import org.wso2.andes.util.FileUtils;

public class CallbackHandlerRegistry {
    private static final Logger _logger = LoggerFactory.getLogger(CallbackHandlerRegistry.class);
    private static final String FILE_PROPERTY = "amq.callbackhandler.properties";
    public static final String DEFAULT_RESOURCE_NAME = "org/wso2/andes/client/security/CallbackHandlerRegistry.properties";
    private static CallbackHandlerRegistry _instance = new CallbackHandlerRegistry();
    private Map<String, Class> _mechanismToHandlerClassMap = new HashMap<String, Class>();
    private String _mechanisms;

    public static CallbackHandlerRegistry getInstance() {
        return _instance;
    }

    public Class getCallbackHandlerClass(String mechanism) {
        return this._mechanismToHandlerClassMap.get(mechanism);
    }

    public String getMechanisms() {
        return this._mechanisms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallbackHandlerRegistry() {
        DynamicSaslRegistrar.registerSaslProviders();
        String filename = System.getProperty(FILE_PROPERTY);
        InputStream is = FileUtils.openFileOrDefaultResource(filename, DEFAULT_RESOURCE_NAME, CallbackHandlerRegistry.class.getClassLoader());
        try {
            Properties props = new Properties();
            props.load(is);
            this.parseProperties(props);
            _logger.info("Callback handlers available for SASL mechanisms: " + this._mechanisms);
        }
        catch (IOException e) {
            _logger.error("Error reading properties: " + e, (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _logger.error("Unable to close properties stream: " + e, (Throwable)e);
                }
            }
        }
    }

    private void parseProperties(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            int period = propertyName.indexOf(".");
            if (period < 0) {
                _logger.warn("Unable to parse property " + propertyName + " when configuring SASL providers");
                continue;
            }
            String mechanism = propertyName.substring(period + 1);
            String className = props.getProperty(propertyName);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
                if (!AMQCallbackHandler.class.isAssignableFrom(clazz)) {
                    _logger.warn("SASL provider " + clazz + " does not implement " + AMQCallbackHandler.class + ". Skipping");
                    continue;
                }
                this._mechanismToHandlerClassMap.put(mechanism, clazz);
                if (this._mechanisms == null) {
                    this._mechanisms = mechanism;
                    continue;
                }
                this._mechanisms = this._mechanisms + " " + mechanism;
            }
            catch (ClassNotFoundException ex) {
                _logger.warn("Unable to load class " + className + ". Skipping that SASL provider");
            }
        }
    }
}

