/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.mina;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.network.NetworkConnection;
import org.wso2.andes.transport.network.mina.MinaSender;
import org.wso2.org.apache.mina.common.CloseFuture;
import org.wso2.org.apache.mina.common.IdleStatus;
import org.wso2.org.apache.mina.common.IoSession;

public class MinaNetworkConnection
implements NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinaNetworkConnection.class);
    private static final int TIMEOUT = Integer.getInteger("amqj.networkTimeout", 30000);
    private IoSession _session;
    private Sender<ByteBuffer> _sender;
    private volatile boolean _blocked = false;

    public MinaNetworkConnection(IoSession session) {
        this._session = session;
        this._sender = new MinaSender(this._session);
    }

    @Override
    public Sender<ByteBuffer> getSender() {
        return this._sender;
    }

    @Override
    public void close() {
        CloseFuture closeFuture = this._session.close();
        closeFuture.join(TIMEOUT);
        if (!closeFuture.isClosed()) {
            LOGGER.error("Couldn't close network connection within {} milliseconds", (Object)TIMEOUT);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._session.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._session.getLocalAddress();
    }

    public long getReadBytes() {
        return this._session.getReadBytes();
    }

    public long getWrittenBytes() {
        return this._session.getWrittenBytes();
    }

    @Override
    public void setMaxWriteIdle(int sec) {
        this._session.setIdleTime(IdleStatus.WRITER_IDLE, sec);
    }

    @Override
    public void setMaxReadIdle(int sec) {
        this._session.setIdleTime(IdleStatus.READER_IDLE, sec);
    }

    @Override
    public void block() {
        this._blocked = true;
        this._session.suspendRead();
    }

    @Override
    public boolean isBlocked() {
        return this._blocked;
    }

    @Override
    public void unblock() {
        this._blocked = false;
        this._session.resumeRead();
    }
}

