/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.tools.utils;

import java.util.ArrayList;
import java.util.UUID;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.kernel.AndesAckData;
import org.wso2.andes.kernel.AndesChannel;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.dtx.AndesPreparedMessageMetadata;
import org.wso2.andes.kernel.dtx.DtxBranch;
import org.wso2.andes.kernel.slot.Slot;

public class MessageTracer {
    private static Log log = LogFactory.getLog(MessageTracer.class);
    public static final String REACHED_ANDES_CORE = "reached Andes core";
    public static final String ENQUEUED_DTX_MESSAGE = "dtx message enqueued";
    public static final String PUBLISHING_DTX_PREPARE_ENQUEUE_RECORDS_TO_DISRUPTOR = "submitting dtx prepare enqueue records to inbound disruptor";
    public static final String PUBLISHING_DTX_PREPARE_DEQUEUE_RECORDS_TO_DISRUPTOR = "submitting dtx prepare dequeue records to inbound disruptor";
    public static final String DTX_MESSAGE_WRITTEN_TO_DB = "message written to database on dtx.commit";
    public static final String DTX_ROLLBACK_DEQUEUED_RECORDS = "message restored on dtx.rollback with a new message id";
    public static final String STORED_PREPARED_ENQUEUE_RECORDS_TO_DB = "stored prepared incoming messages to dtx store";
    public static final String MOVE_PREPARED_DEQUEUE_RECORDS_TO_DB = "moved acknowledged messages to dtx store from message store";
    public static final String SENDING_MESSAGE_TO_SUBSCRIBER = "sending message to subscriber";
    public static final String DTX_RECORD_METADATA_COUNT_IN_SLOT = "slot information updated for message on dtx.commit";
    public static final String MESSAGE_RECEIVED_TO_AMQ_CHANNEL = " message received to AMQChannel";
    public static final String DTX_MESSAGE_RECEIVED_TO_AMQ_CHANNEL = "dtx message received to AMQChannel";
    public static final String ACK_RECEIVED_TO_AMQ_CHANNEL = "acknowledgment received to AMQChannel";
    public static final String PUBLISHED_TO_INBOUND_DISRUPTOR = "messaging event submitted to inbound disruptor";
    public static final String ENQUEUE_EVENT_PUBLISHED_TO_INBOUND_DISRUPTOR = "enqueue event submitted to inbound disruptor";
    public static final String MESSAGE_ID_MAPPED = "mapped to andes message";
    public static final String MESSAGE_CLONED = "cloned with message id";
    public static final String TRANSACTION_COMMIT_EVENT_PUBLISHED_TO_INBOUND_DISRUPTOR = "transaction commit event submitted to inbound disruptor";
    public static final String TRANSACTION_ROLLBACK_EVENT_PUBLISHED_TO_INBOUND_DISRUPTOR = "transaction rollback event submitted to inbound disruptor";
    public static final String TRANSACTION_CLOSE_EVENT_PUBLISHED_TO_INBOUND_DISRUPTOR = "transaction close event submitted to inbound disruptor";
    public static final String CONTENT_WRITTEN_TO_DB = "content written to database";
    public static final String SLOT_INFO_UPDATED = "slot information updated";
    public static final String PUBLISHED_TO_OUTBOUND_DISRUPTOR = "submitted to outbound disruptor";
    public static final String METADATA_READ_FROM_DB = "metadata read from database";
    public static final String METADATA_BUFFERED_FOR_DELIVERY = "metadata buffered for delivery";
    public static final String CONTENT_READ = "content read from database";
    public static final String DISPATCHED_TO_PROTOCOL = "dispatched to protocol level for delivery";
    public static final String MESSAGE_REJECTED = "message rejected";
    public static final String MESSAGE_REQUEUED_SUBSCRIBER = "message re-queued to subscriber";
    public static final String MOVED_TO_DLC = "message moved to DLC";
    public static final String MESSAGE_DELETED = "message deleted";
    public static final String ACK_RECEIVED_FROM_PROTOCOL = "ACK received from protocol";
    public static final String ACK_PUBLISHED_TO_DISRUPTOR = "ACK event submitted to disruptor";
    public static final String ACK_MESSAGE_REFERENCE_SET_BY_DISRUPTOR = "ACK metadata reference set by disruptor";
    public static final String MESSAGE_REQUEUED_BUFFER = "message re-queued to buffer";
    public static final String CONTENT_DECOMPRESSION_HANDLER_MESSAGE = "Content decompressed";
    public static final String MESSAGE_BEYOND_LAST_ROLLBACK = "Message is beyond the last rollback point. Therefore deliveryCount is not increased.";
    public static final String DISCARD_STALE_MESSAGE = "discarding delivery as message is stale";
    public static final String EXPIRED_MESSAGE_DETECTED_AND_QUEUED = "expired message detected in the flusher and queued for batch delete";
    public static final String EXPIRED_MESSAGE_DETECTED_FROM_DATABASE = "expired messages detected from the database";
    public static final String EXPIRED_MESSAGE_DETECTED_FROM_DLC = "expired message detected fromthe DLC";

    public static void trace(long messageId, String destination, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setDestination(destination);
            if (messageId > 0L) {
                traceBuilder.setMessageId(messageId);
            }
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void traceAck(AndesAckData ackData, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Ack { ");
            traceBuilder.setMessageId(ackData.getMessageId()).setChannelId(ackData.getChannelId());
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(AndesMessage message, String description) {
        MessageTracer.trace(message.getMetadata().getMessageID(), message.getMetadata().getDestination(), description);
    }

    public static void trace(AndesMessageMetadata metadata, String description) {
        MessageTracer.trace(metadata.getMessageID(), metadata.getDestination(), description);
    }

    public static boolean isEnabled() {
        return log.isTraceEnabled();
    }

    private static void traceTransaction(long messageId, String destination, String channelId, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setDestination(destination);
            if (messageId > 0L) {
                traceBuilder.setMessageId(messageId);
            }
            traceBuilder.setChannelIdentifier(channelId);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void traceTransaction(AndesChannel channel, int size, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Transaction { ");
            traceBuilder.setChannelIdentifier(channel.getIdentifier()).setTxBatchSize(size);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void traceTransaction(AndesMessage message, AndesChannel channel, String description) {
        MessageTracer.traceTransaction(message.getMetadata().getMessageID(), message.getMetadata().getDestination(), channel.getIdentifier(), description);
    }

    public static void trace(Xid xid, UUID channelId, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Dtx { ");
            traceBuilder.setXid(xid).setChannelId(channelId);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(AndesMessageMetadata metadata, Xid xid, DtxBranch.State state, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setMessageId(metadata.getMessageID()).setDestination(metadata.getDestination()).setXid(xid).setBranchState(state);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(AndesAckData ackData, Xid xid, DtxBranch.State state, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Ack { ");
            traceBuilder.setMessageId(ackData.getMessageId()).setBranchState(state).setChannelId(ackData.getChannelId()).setXid(xid);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(AndesPreparedMessageMetadata preparedMessageMetadata, Xid xid, DtxBranch.State state, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setMessageId(preparedMessageMetadata.getMessageID()).setOldMessageId(preparedMessageMetadata.getOldMessageId()).setXid(xid).setDestination(preparedMessageMetadata.getDestination()).setBranchState(state);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(String description) {
        log.trace((Object)description);
    }

    public static void trace(long messageId, String routingKey, UUID channelId, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setMessageId(messageId).setDestination(routingKey).setChannelId(channelId);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(String destination, UUID channelId, String channelIdentifier, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setDestination(destination).setChannelId(channelId).setChannelIdentifier(channelIdentifier);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(long messageId, long deliveryTag, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setMessageId(messageId).setDeliveryTag(deliveryTag);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(String destination, UUID channelId, String channelIdentifier, boolean isDtx, long deliveryTag, boolean isMultiple, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Ack { ");
            traceBuilder.setDestination(destination).setDeliveryTag(deliveryTag).setChannelId(channelId).setChannelIdentifier(channelIdentifier).setDeliveryTag(deliveryTag).setAckMultiple(isMultiple).setIsDtx(isDtx);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(DeliverableAndesMetadata metadata, Slot slot, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setDestination(metadata.getDestination()).setMessageId(metadata.getMessageID()).setSlotId(slot.getId());
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    public static void trace(long messageId, int deliveryCount, UUID channelId, String description) {
        if (log.isTraceEnabled()) {
            TraceBuilder traceBuilder = new TraceBuilder("Message { ");
            traceBuilder.setMessageId(messageId).setChannelId(channelId).setDeliveryCount(deliveryCount);
            log.trace((Object)traceBuilder.toString(description));
        }
    }

    private static class TraceBuilder {
        private static final String TX_BATCH_SIZE = "txBatchSize: ";
        private static final String MESSAGE_ID = "id: ";
        private static final String OLD_MESSAGE_ID = "oldId: ";
        private static final String DESTINATION = "destination: ";
        private static final String DELIVERY_TAG = "deliveryTag: ";
        private static final String CHANNEL_ID = "channelId: ";
        private static final String CHANNEL_IDENTIFIER = "channelIdentifier: ";
        private static final String XID = "xid: ";
        private static final String DTX_BRANCH_STATE = "branchState: ";
        private static final String ACK_MULTIPLE = "ackMultiple: ";
        private static final String IS_DTX = "isDtx: ";
        private static final String SLOT_ID = "slotId: ";
        private static final String DELIVERY_COUNT = "deliveryCount: ";
        static final String MESSAGE_TRACE = "Message { ";
        static final String ACKNOWLEDGMENT_TRACE = "Ack { ";
        static final String DTX_TRACE = "Dtx { ";
        static final String TX_TRACE = "Transaction { ";
        private static final String FIELD_SEPARATOR = " , ";
        static final String POSTFIX = " } ";
        private final ArrayList<String> fields;
        private final String messagePrefix;

        TraceBuilder(String messagePrefix) {
            this.messagePrefix = messagePrefix;
            this.fields = new ArrayList();
        }

        TraceBuilder setMessageId(long id) {
            this.fields.add(MESSAGE_ID + id);
            return this;
        }

        TraceBuilder setOldMessageId(long oldId) {
            this.fields.add(OLD_MESSAGE_ID + oldId);
            return this;
        }

        TraceBuilder setDestination(String destination) {
            this.fields.add(DESTINATION + destination);
            return this;
        }

        TraceBuilder setDeliveryTag(long deliveryTag) {
            this.fields.add(DELIVERY_TAG + deliveryTag);
            return this;
        }

        TraceBuilder setChannelId(UUID channelId) {
            this.fields.add(CHANNEL_ID + channelId);
            return this;
        }

        TraceBuilder setChannelIdentifier(String channelIdentifier) {
            this.fields.add(CHANNEL_IDENTIFIER + channelIdentifier);
            return this;
        }

        TraceBuilder setXid(Xid xid) {
            this.fields.add(XID + xid);
            return this;
        }

        TraceBuilder setBranchState(DtxBranch.State state) {
            this.fields.add(DTX_BRANCH_STATE + (Object)((Object)state));
            return this;
        }

        TraceBuilder setAckMultiple(boolean ackMultiple) {
            this.fields.add(ACK_MULTIPLE + ackMultiple);
            return this;
        }

        TraceBuilder setIsDtx(boolean isDtx) {
            this.fields.add(IS_DTX + isDtx);
            return this;
        }

        TraceBuilder setTxBatchSize(int txBatchSize) {
            this.fields.add(TX_BATCH_SIZE + txBatchSize);
            return this;
        }

        TraceBuilder setSlotId(String slotId) {
            this.fields.add(SLOT_ID + slotId);
            return this;
        }

        TraceBuilder setDeliveryCount(int deliveryCount) {
            this.fields.add(DELIVERY_COUNT + deliveryCount);
            return this;
        }

        public String toString() {
            return this.getTraceMessage(POSTFIX);
        }

        String toString(String description) {
            return this.getTraceMessage(POSTFIX + description);
        }

        private String getTraceMessage(String postfix) {
            String fieldString = StringUtils.join(this.fields, (String)FIELD_SEPARATOR);
            return this.messagePrefix + fieldString + postfix;
        }
    }
}

