/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.tools.messagestore.commands;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wso2.andes.tools.messagestore.MessageStoreTool;
import org.wso2.andes.tools.messagestore.commands.AbstractCommand;
import org.wso2.andes.tools.messagestore.commands.Command;

public class Help
extends AbstractCommand {
    public Help(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public String help() {
        return "Provides detailed help on commands.";
    }

    @Override
    public String getCommand() {
        return "help";
    }

    @Override
    public String usage() {
        return "help [<command>]";
    }

    @Override
    public void execute(String ... args) {
        assert (args.length > 0);
        assert (args[0].equals(this.getCommand()));
        if (args.length > 1) {
            Command command = this._tool.getCommands().get(args[1]);
            if (command != null) {
                this._console.println(command.help());
                this._console.println("Usage:" + command.usage());
            } else {
                this.commandError("Command not found: ", args);
            }
        } else {
            LinkedList<List> data = new LinkedList<List>();
            LinkedList<String> commandName = new LinkedList<String>();
            LinkedList<String> commandDescription = new LinkedList<String>();
            data.add(commandName);
            data.add(commandDescription);
            commandName.add("Command");
            commandDescription.add("Description");
            commandName.add("*divider");
            commandDescription.add("*divider");
            Map<String, Command> commands = this._tool.getCommands();
            for (Command command : commands.values()) {
                commandName.add(command.getCommand());
                commandDescription.add(command.help());
            }
            this._console.printMap("Available Commands", data);
        }
    }
}

