/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.tools.messagestore.commands;

import org.wso2.andes.server.queue.AMQQueue;
import org.wso2.andes.server.txn.LocalTransaction;
import org.wso2.andes.tools.messagestore.MessageStoreTool;
import org.wso2.andes.tools.messagestore.commands.Move;

public class Copy
extends Move {
    public Copy(MessageStoreTool tool) {
        super(tool);
    }

    @Override
    public String help() {
        return "Copy messages between queues.";
    }

    @Override
    public String usage() {
        return "copy to=<queue> [from=<queue>] [msgids=<msgids eg, 1,2,4-10>]";
    }

    @Override
    public String getCommand() {
        return "copy";
    }

    @Override
    protected void doCommand(AMQQueue fromQueue, long start, long end, AMQQueue toQueue) {
        LocalTransaction txn = new LocalTransaction(fromQueue.getVirtualHost().getTransactionLog());
        fromQueue.copyMessagesToAnotherQueue(start, end, toQueue.getNameShortString().toString(), txn);
        txn.commit();
    }
}

