/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.thrift;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.server.cluster.ClusterAgent;
import org.wso2.andes.thrift.exception.ThriftClientException;
import org.wso2.andes.thrift.slot.gen.SlotManagementService;

public class ThriftClientFactory
extends BasePooledObjectFactory<SlotManagementService.Client> {
    private static final Log log = LogFactory.getLog(ThriftClientFactory.class);

    public SlotManagementService.Client create() throws Exception {
        ClusterAgent clusterAgent = AndesContext.getInstance().getClusterAgent();
        InetSocketAddress thriftAddressOfCoordinator = clusterAgent.getThriftAddressOfCoordinator();
        if (null == thriftAddressOfCoordinator) {
            throw new ThriftClientException("Thrift coordinator details are not updated in the map yet");
        }
        int soTimeout = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_THRIFT_SO_TIMEOUT);
        String thriftHost = thriftAddressOfCoordinator.getHostName();
        int thriftPort = thriftAddressOfCoordinator.getPort();
        TSocket transport = new TSocket(thriftHost, thriftPort, soTimeout);
        try {
            transport.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
            return new SlotManagementService.Client((TProtocol)protocol);
        }
        catch (TTransportException e) {
            throw new TTransportException("Could not initialize the Thrift client to connect to Thrift server at, " + thriftHost + ":" + thriftPort, (Throwable)e);
        }
    }

    public PooledObject<SlotManagementService.Client> wrap(SlotManagementService.Client client) {
        return new DefaultPooledObject((Object)client);
    }

    public void destroyObject(PooledObject<SlotManagementService.Client> client) throws Exception {
        ((SlotManagementService.Client)client.getObject()).getInputProtocol().getTransport().close();
        super.destroyObject(client);
    }

    public boolean validateObject(PooledObject<SlotManagementService.Client> client) {
        try {
            return ((SlotManagementService.Client)client.getObject()).healthCheck();
        }
        catch (TException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Connection is not active. Hence removing the connection from pool.", (Throwable)e);
            }
            return false;
        }
    }
}

