/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.thrift;

import org.apache.thrift.TException;
import org.wso2.andes.kernel.AndesContext;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotManagerClusterMode;
import org.wso2.andes.thrift.slot.gen.SlotInfo;
import org.wso2.andes.thrift.slot.gen.SlotManagementService;

public class SlotManagementServiceImpl
implements SlotManagementService.Iface {
    private static SlotManagerClusterMode slotManager = SlotManagerClusterMode.getInstance();

    @Override
    public SlotInfo getSlotInfo(String queueName, String nodeId) throws TException {
        if (AndesContext.getInstance().getClusterAgent().isCoordinator()) {
            SlotInfo slotInfo = new SlotInfo();
            try {
                Slot slot = slotManager.getSlot(queueName, nodeId);
                if (null != slot) {
                    slotInfo = new SlotInfo(slot.getStartMessageId(), slot.getEndMessageId(), slot.getStorageQueueName(), nodeId, slot.isAnOverlappingSlot());
                }
            }
            catch (AndesException e) {
                throw new TException("Failed to get slot info for queue: " + queueName + " nodeId: " + nodeId, (Throwable)e);
            }
            return slotInfo;
        }
        throw new TException("This node is not the slot coordinator right now");
    }

    @Override
    public void updateMessageId(String queueName, String nodeId, long startMessageId, long endMessageId, long localSafeZone) throws TException {
        if (AndesContext.getInstance().getClusterAgent().isCoordinator()) {
            try {
                slotManager.updateMessageID(queueName, nodeId, startMessageId, endMessageId, localSafeZone);
            }
            catch (AndesException e) {
                throw new TException("Failed to update message id for queue: " + queueName + " nodeId: " + nodeId, (Throwable)e);
            }
        } else {
            throw new TException("This node is not the slot coordinator right now");
        }
    }

    @Override
    public boolean deleteSlot(String queueName, SlotInfo slotInfo, String nodeId) throws TException {
        if (AndesContext.getInstance().getClusterAgent().isCoordinator()) {
            Slot slot = new Slot();
            boolean result = false;
            slot.setStartMessageId(slotInfo.getStartMessageId());
            slot.setEndMessageId(slotInfo.getEndMessageId());
            slot.setStorageQueueName(slotInfo.getQueueName());
            try {
                result = slotManager.deleteSlot(queueName, slot, nodeId);
            }
            catch (AndesException e) {
                throw new TException("Failed to delete slot for queue:" + queueName, (Throwable)e);
            }
            return result;
        }
        throw new TException("This node is not the slot coordinator right now");
    }

    @Override
    public boolean healthCheck() throws TException {
        return true;
    }

    @Override
    public void reAssignSlotWhenNoSubscribers(String nodeId, String queueName) throws TException {
        if (AndesContext.getInstance().getClusterAgent().isCoordinator()) {
            try {
                slotManager.reAssignSlotWhenNoSubscribers(nodeId, queueName);
            }
            catch (AndesException e) {
                throw new TException("Failed to reAssign slot for node:" + nodeId + " queue:" + queueName, (Throwable)e);
            }
        } else {
            throw new TException("This node is not the slot coordinator right now");
        }
    }

    @Override
    public long updateCurrentMessageIdForSafeZone(long messageId, String nodeId) throws TException {
        if (!AndesContext.getInstance().getClusterAgent().isCoordinator()) {
            throw new TException("This node is not the slot coordinator right now");
        }
        long slotDeletionSafeZone = slotManager.updateAndReturnSlotDeleteSafeZone(nodeId, messageId);
        return slotDeletionSafeZone;
    }

    @Override
    public void clearAllActiveSlotRelationsToQueue(String queueName) throws TException {
        if (AndesContext.getInstance().getClusterAgent().isCoordinator()) {
            try {
                slotManager.clearAllActiveSlotRelationsToQueue(queueName);
            }
            catch (AndesException e) {
                throw new TException("Failed to clear active slots for queue:" + queueName, (Throwable)e);
            }
        } else {
            throw new TException("This node is not the slot coordinator right now");
        }
    }
}

