/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.thrift;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.thrift.SlotManagementServiceImpl;
import org.wso2.andes.thrift.slot.gen.SlotManagementService;

public class MBThriftServer {
    private static final int THRIFT_SERVER_REQUEST_TIMEOUT = 20;
    private static Log log = LogFactory.getLog(MBThriftServer.class);
    private static MBThriftServer mbThriftServer = new MBThriftServer();
    private SlotManagementServiceImpl slotManagementServerHandler = new SlotManagementServiceImpl();
    private TServer server;

    private MBThriftServer() {
    }

    public void start(String hostName, int port, String taskName) throws AndesException {
        if ("0.0.0.0".equals(hostName)) {
            throw new AndesException("Invalid thrift server host 0.0.0.0");
        }
        try {
            int socketTimeout = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_THRIFT_SO_TIMEOUT);
            TServerSocket socket = new TServerSocket(new InetSocketAddress(hostName, port), socketTimeout);
            SlotManagementService.Processor<SlotManagementServiceImpl> processor = new SlotManagementService.Processor<SlotManagementServiceImpl>(this.slotManagementServerHandler);
            TBinaryProtocol.Factory protocolFactory = new TBinaryProtocol.Factory();
            this.server = new TThreadPoolServer(((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).processor(processor)).inputProtocolFactory((TProtocolFactory)protocolFactory)).requestTimeoutUnit(TimeUnit.SECONDS).requestTimeout(20));
            log.info((Object)("Starting the Message Broker Thrift server on host '" + hostName + "' on port '" + port + "'..."));
            new Thread((Runnable)new MBServerMainLoop(this.server), taskName).start();
        }
        catch (TTransportException e) {
            throw new AndesException("Cannot start Thrift server on port " + port + " on host " + hostName, e);
        }
    }

    public void stop() {
        log.info((Object)"Stopping the Message Broker Thrift server...");
        if (this.server != null) {
            this.server.stop();
            try {
                boolean terminationSuccessful = this.awaitTermination(20L, TimeUnit.SECONDS);
                if (!terminationSuccessful) {
                    log.warn((Object)"Could not stop the Message Broker Thrift server");
                }
            }
            catch (InterruptedException e) {
                log.warn((Object)"Thrift server shutdown was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutInMillis = unit.toMillis(timeout);
        long shutDownStartTime = System.currentTimeMillis();
        long timeElapsed = 0L;
        while (this.server.isServing() && timeElapsed < timeoutInMillis) {
            TimeUnit.MILLISECONDS.sleep(100L);
            timeElapsed = System.currentTimeMillis() - shutDownStartTime;
        }
        return this.server.isServing();
    }

    public boolean isServerAlive() {
        return this.server != null && this.server.isServing();
    }

    public static MBThriftServer getInstance() {
        return mbThriftServer;
    }

    private static class MBServerMainLoop
    implements Runnable {
        private TServer server;

        private MBServerMainLoop(TServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.serve();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start the MBThrift server", e);
            }
        }
    }
}

