/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.thrift;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.slot.ConnectionException;
import org.wso2.andes.kernel.slot.CoordinatorConnectionListener;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.thrift.ThriftClientFactory;
import org.wso2.andes.thrift.slot.gen.SlotInfo;
import org.wso2.andes.thrift.slot.gen.SlotManagementService;

public class MBThriftClient {
    private boolean reconnecting = false;
    private int reconnectionAttemptCounter = 0;
    private final Log log = LogFactory.getLog(MBThriftClient.class);
    private final Queue<CoordinatorConnectionListener> connectionListenerQueue = new ConcurrentLinkedQueue<CoordinatorConnectionListener>();
    private AtomicBoolean isConnected = new AtomicBoolean(false);
    private PooledObjectFactory<SlotManagementService.Client> thriftClientFactory = new ThriftClientFactory();
    private int socketTimeout = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATION_THRIFT_SO_TIMEOUT);
    private ObjectPool<SlotManagementService.Client> thriftClientPool;
    private static final int RETRY_COUNT = 1;
    private long lastReconnectionSuccessTimestamp = 0L;

    public MBThriftClient() {
        this.initializeThriftConnectionPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slot getSlot(String queueName, String nodeId) throws ConnectionException {
        for (int i = 0; i <= 1; ++i) {
            SlotManagementService.Client client = null;
            try {
                client = this.getServiceClient();
                SlotInfo slotInfo = client.getSlotInfo(queueName, nodeId);
                Slot slot = this.convertSlotInforToSlot(slotInfo);
                return slot;
            }
            catch (TException e) {
                this.invalidateServiceClient(client);
                this.log.error((Object)("Attempt " + i + " failed requesting a slot from coordinator"), (Throwable)e);
                continue;
            }
            finally {
                if (client != null) {
                    this.returnServiceClient(client);
                }
            }
        }
        this.handleCoordinatorChanges();
        throw new ConnectionException("Coordinator has changed");
    }

    public void addConnectionListener(CoordinatorConnectionListener connectionListener) {
        this.connectionListenerQueue.add(connectionListener);
    }

    private Slot convertSlotInforToSlot(SlotInfo slotInfo) {
        Slot slot = new Slot();
        slot.setStartMessageId(slotInfo.getStartMessageId());
        slot.setEndMessageId(slotInfo.getEndMessageId());
        slot.setStorageQueueName(slotInfo.getQueueName());
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateMessageId(String queueName, String nodeId, long startMessageId, long endMessageId, long localSafeZone) throws ConnectionException {
        boolean updateSuccess = false;
        for (int i = 0; i <= 1 && !updateSuccess; ++i) {
            SlotManagementService.Client client = null;
            try {
                client = this.getServiceClient();
                client.updateMessageId(queueName, nodeId, startMessageId, endMessageId, localSafeZone);
                updateSuccess = true;
                continue;
            }
            catch (TException e) {
                this.invalidateServiceClient(client);
                this.log.error((Object)("Attempt " + i + " failed updating message Id"), (Throwable)e);
                continue;
            }
            finally {
                if (client != null) {
                    this.returnServiceClient(client);
                }
            }
        }
        if (!updateSuccess) {
            this.handleCoordinatorChanges();
            throw new ConnectionException("Coordinator has changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteSlot(String queueName, Slot slot, String nodeId) throws ConnectionException {
        SlotInfo slotInfo = new SlotInfo(slot.getStartMessageId(), slot.getEndMessageId(), slot.getStorageQueueName(), nodeId, slot.isAnOverlappingSlot());
        for (int i = 0; i <= 1; ++i) {
            SlotManagementService.Client client = null;
            try {
                client = this.getServiceClient();
                boolean bl = client.deleteSlot(queueName, slotInfo, nodeId);
                return bl;
            }
            catch (TException e) {
                this.invalidateServiceClient(client);
                this.log.error((Object)("Attempt " + i + " failed deleting slot"));
                continue;
            }
            finally {
                if (client != null) {
                    this.returnServiceClient(client);
                }
            }
        }
        this.handleCoordinatorChanges();
        throw new ConnectionException("Coordinator has changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reAssignSlotWhenNoSubscribers(String nodeId, String queueName) throws ConnectionException {
        boolean reassignSuccess = false;
        for (int i = 0; i <= 1 && !reassignSuccess; ++i) {
            SlotManagementService.Client client = null;
            try {
                client = this.getServiceClient();
                client.reAssignSlotWhenNoSubscribers(nodeId, queueName);
                reassignSuccess = true;
                continue;
            }
            catch (TException e) {
                this.invalidateServiceClient(client);
                this.log.error((Object)("Attempt " + i + " failed reassigning slot"), (Throwable)e);
                continue;
            }
            finally {
                if (client != null) {
                    this.returnServiceClient(client);
                }
            }
        }
        if (!reassignSuccess) {
            this.handleCoordinatorChanges();
            throw new ConnectionException("Coordinator has changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearAllActiveSlotRelationsToQueue(String queueName) throws ConnectionException {
        boolean success = false;
        for (int i = 0; i <= 1 && !success; ++i) {
            SlotManagementService.Client client = null;
            try {
                client = this.getServiceClient();
                client.clearAllActiveSlotRelationsToQueue(queueName);
                success = true;
                continue;
            }
            catch (TException e) {
                this.invalidateServiceClient(client);
                this.log.error((Object)("Attempt " + i + " failed clearing active slot relations to queue"), (Throwable)e);
                continue;
            }
            finally {
                if (client != null) {
                    this.returnServiceClient(client);
                }
            }
        }
        if (!success) {
            this.handleCoordinatorChanges();
            throw new ConnectionException("Coordinator has changed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long updateSlotDeletionSafeZone(long safeZoneMessageID, String nodeID) throws ConnectionException {
        for (int i = 0; i <= 1; ++i) {
            SlotManagementService.Client client = null;
            try {
                client = this.getServiceClient();
                long l = client.updateCurrentMessageIdForSafeZone(safeZoneMessageID, nodeID);
                return l;
            }
            catch (TException e) {
                this.invalidateServiceClient(client);
                this.log.error((Object)("Attempt " + i + " failed updating slot delete safe zone"), (Throwable)e);
                continue;
            }
            finally {
                if (client != null) {
                    this.returnServiceClient(client);
                }
            }
        }
        this.handleCoordinatorChanges();
        throw new ConnectionException("Coordinator has changed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCoordinatorChanges() {
        long attemptStartTimeMillis = System.currentTimeMillis();
        MBThriftClient mBThriftClient = this;
        synchronized (mBThriftClient) {
            if (!this.isReconnecting() && this.lastReconnectionSuccessTimestamp < attemptStartTimeMillis) {
                this.notifyDisconnection();
                this.setReconnectingFlag();
                this.startReconnecting();
            }
        }
    }

    private void notifyDisconnection() {
        if (this.isConnected.compareAndSet(true, false)) {
            for (CoordinatorConnectionListener listener : this.connectionListenerQueue) {
                listener.onCoordinatorDisconnect();
            }
        }
    }

    private void reConnectToServer() throws TTransportException {
        Long reconnectTimeout = (Long)AndesConfigurationManager.readValue(AndesConfiguration.COORDINATOR_THRIFT_RECONNECT_TIMEOUT) * 1000L;
        try {
            Thread.sleep(reconnectTimeout);
            this.thriftClientPool.close();
            this.initializeThriftConnectionPool();
            SlotManagementService.Client client = (SlotManagementService.Client)this.thriftClientPool.borrowObject();
            this.reconnecting = false;
            this.lastReconnectionSuccessTimestamp = System.currentTimeMillis();
            this.thriftClientPool.returnObject((Object)client);
            this.notifyConnection();
        }
        catch (TTransportException e) {
            this.log.error((Object)"Could not connect to the Thrift Server", (Throwable)e);
            throw new TTransportException("Could not connect to the Thrift Server", (Throwable)e);
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            this.log.error((Object)"Could not connect to the Thrift Server", (Throwable)e);
        }
    }

    private void notifyConnection() {
        if (this.isConnected.compareAndSet(false, true)) {
            for (CoordinatorConnectionListener listener : this.connectionListenerQueue) {
                listener.onCoordinatorReconnect();
            }
        }
    }

    private void startReconnecting() {
        while (this.reconnecting) {
            ++this.reconnectionAttemptCounter;
            try {
                this.reConnectToServer();
                this.reconnecting = false;
                this.reconnectionAttemptCounter = 0;
            }
            catch (Throwable e) {
                this.log.error((Object)("Error occurred while reconnecting to slot coordinator. Reconnection attempt " + this.reconnectionAttemptCounter), e);
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean isReconnecting() {
        return this.reconnecting;
    }

    public void setReconnectingFlag() {
        this.reconnecting = true;
    }

    private void initializeThriftConnectionPool() {
        int thriftClientPoolSize = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_THRIFT_CLIENT_POOL_SIZE);
        GenericObjectPool thriftConnectionPool = new GenericObjectPool(this.thriftClientFactory);
        thriftConnectionPool.setMaxTotal(thriftClientPoolSize);
        thriftConnectionPool.setTestOnBorrow(true);
        if (this.socketTimeout > 0) {
            thriftConnectionPool.setTimeBetweenEvictionRunsMillis((long)(this.socketTimeout / 2));
            thriftConnectionPool.setMinEvictableIdleTimeMillis((long)this.socketTimeout);
        }
        this.thriftClientPool = thriftConnectionPool;
    }

    private SlotManagementService.Client getServiceClient() throws ConnectionException {
        try {
            return (SlotManagementService.Client)this.thriftClientPool.borrowObject();
        }
        catch (Exception e) {
            throw new ConnectionException("Error borrowing a connection from thrift connection pool", e);
        }
    }

    private void returnServiceClient(SlotManagementService.Client client) {
        try {
            this.thriftClientPool.returnObject((Object)client);
        }
        catch (Exception e) {
            this.log.warn((Object)"Error returning thrift client back to the pool. Coordinator might have changed.", (Throwable)e);
        }
    }

    private void invalidateServiceClient(SlotManagementService.Client client) throws ConnectionException {
        if (client != null) {
            try {
                this.thriftClientPool.invalidateObject((Object)client);
            }
            catch (Exception e) {
                throw new ConnectionException("Error invalidating a connection from thrift connection pool", e);
            }
        }
    }
}

