/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.task;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.wso2.andes.task.Task;

final class TaskHolder<T extends Task>
implements Delayed {
    private final T task;
    private final AtomicBoolean isDisabled;
    private AtomicBoolean isProcessing;
    private long expiryTime;

    TaskHolder(T task) {
        this.task = task;
        this.isDisabled = new AtomicBoolean(false);
        this.isProcessing = new AtomicBoolean(false);
        this.expiryTime = System.currentTimeMillis();
    }

    final Task.TaskHint executeTask() throws Exception {
        Task.TaskHint hint = Task.TaskHint.IDLE;
        if (this.isProcessing.compareAndSet(false, true)) {
            try {
                if (!this.isDisabled.get()) {
                    hint = (Task.TaskHint)((Object)this.task.call());
                }
            }
            finally {
                this.isProcessing.set(false);
            }
        }
        return hint;
    }

    public T getTask() {
        return this.task;
    }

    public String toString() {
        return "Task id " + ((Task)this.task).getId();
    }

    boolean isDisabled() {
        return this.isDisabled.get();
    }

    void disableProcessing() {
        this.isDisabled.set(true);
        while (this.isProcessing.get()) {
            Thread.yield();
        }
    }

    String getId() {
        return ((Task)this.task).getId();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expiryTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    void setDelay(long delay, TimeUnit timeUnit) {
        this.expiryTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(delay, timeUnit);
    }

    @Override
    public int compareTo(Delayed delayedObject) {
        int order = Long.compare(this.expiryTime, ((TaskHolder)delayedObject).expiryTime);
        if (order == 0) {
            order = this.getId().compareTo(((TaskHolder)delayedObject).getId());
        }
        return order;
    }

    public boolean equals(Object obj) {
        boolean isEqual = obj instanceof TaskHolder ? ((TaskHolder)obj).getId().compareTo(this.getId()) == 0 : this.equals(obj);
        return isEqual;
    }

    void onRemoveTask() {
        ((Task)this.task).onRemove();
    }
}

