/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store.rdbms;

import com.google.common.base.Splitter;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.util.ConfigurationProperties;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.store.AndesBatchUpdateException;
import org.wso2.andes.store.AndesDataException;
import org.wso2.andes.store.AndesDataIntegrityViolationException;
import org.wso2.andes.store.AndesStoreUnavailableException;
import org.wso2.andes.store.AndesTransactionRollbackException;

public class RDBMSStoreUtils {
    private static final Logger log = Logger.getLogger(RDBMSStoreUtils.class);
    private Set<String> storeUnavailableSQLStatesClassCodes;
    private Set<String> dataIntegrityViolationSQLStateClassCodes;
    private Set<String> dataErrorSQLStateClassCodes;
    private Set<String> transactionRollbackSQLStateClassCodes;

    public RDBMSStoreUtils(ConfigurationProperties connectionProperties) {
        this.storeUnavailableSQLStatesClassCodes = this.extractAndFill(connectionProperties, "storeUnavailableSQLStateClasses");
        this.dataIntegrityViolationSQLStateClassCodes = this.extractAndFill(connectionProperties, "integrityViolationSQLStateClasses");
        this.dataErrorSQLStateClassCodes = this.extractAndFill(connectionProperties, "dataErrorSQLStateClasses");
        this.transactionRollbackSQLStateClassCodes = this.extractAndFill(connectionProperties, "transactionRollbackSQLStateClasses");
    }

    public AndesException convertSQLException(String message, SQLException sqlException) {
        AndesException convertedException = this.convertBySQLException(message, sqlException);
        if (null == convertedException) {
            convertedException = this.convertBySQLState(message, sqlException);
        }
        if (null == convertedException) {
            convertedException = new AndesException(message, sqlException.getSQLState(), sqlException);
        }
        return convertedException;
    }

    private AndesException convertBySQLException(String message, SQLException sqlException) {
        AndesException convertedException = null;
        if (SQLNonTransientConnectionException.class.isInstance(sqlException) || SQLTransientConnectionException.class.isInstance(sqlException) || SQLInvalidAuthorizationSpecException.class.isInstance(sqlException) || SQLClientInfoException.class.isInstance(sqlException) || SQLTimeoutException.class.isInstance(sqlException)) {
            String sqlState = this.extractSqlState(sqlException);
            convertedException = new AndesStoreUnavailableException(message, sqlState, sqlException);
        } else if (SQLIntegrityConstraintViolationException.class.isInstance(sqlException)) {
            String sqlState = this.extractSqlState(sqlException);
            convertedException = new AndesDataIntegrityViolationException(message, sqlState, sqlException);
        } else if (SQLTransactionRollbackException.class.isInstance(sqlException)) {
            String sqlState = this.extractSqlState(sqlException);
            convertedException = new AndesTransactionRollbackException(message, sqlState, sqlException);
        } else if (DataTruncation.class.isInstance(sqlException) || SQLDataException.class.isInstance(sqlException)) {
            String sqlState = this.extractSqlState(sqlException);
            convertedException = new AndesDataException(message, sqlState, sqlException);
        }
        return convertedException;
    }

    private AndesException convertBySQLState(String message, SQLException sqlException) {
        AndesException convertedException = null;
        String sqlState = this.extractSqlState(sqlException);
        String sqlStateClassCode = this.determineSqlStateClassCode(sqlState);
        if (this.storeUnavailableSQLStatesClassCodes.contains(sqlStateClassCode)) {
            convertedException = new AndesStoreUnavailableException(message, sqlState, sqlException);
        } else if (this.dataIntegrityViolationSQLStateClassCodes.contains(sqlStateClassCode)) {
            convertedException = new AndesDataIntegrityViolationException(message, sqlState, sqlException);
        } else if (this.transactionRollbackSQLStateClassCodes.contains(sqlStateClassCode)) {
            convertedException = new AndesTransactionRollbackException(message, sqlState, sqlException);
        } else if (this.dataErrorSQLStateClassCodes.contains(sqlStateClassCode)) {
            convertedException = new AndesDataException(message, sqlState, sqlException);
        }
        return convertedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testInsert(Connection connection, String testString, long testTime) throws SQLException {
        boolean canInsert = false;
        PreparedStatement preparedStatement = null;
        try {
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("INSERT INTO MB_MSG_STORE_STATUS (NODE_ID,TIME_STAMP ) VALUES ( ?,? )");
            preparedStatement.setString(1, testString);
            preparedStatement.setLong(2, testTime);
            preparedStatement.executeUpdate();
            connection.commit();
            canInsert = true;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "testing data can be inserted to message store." + String.format("test data : [%s, %d]", testString, testTime));
            }
            catch (Throwable throwable) {
                String msg = "testing data can be inserted to message store." + String.format("test data : [%s, %d]", testString, testTime);
                this.close(preparedStatement, msg);
                this.close(connection, msg);
                throw throwable;
            }
            String msg = "testing data can be inserted to message store." + String.format("test data : [%s, %d]", testString, testTime);
            this.close(preparedStatement, msg);
            this.close(connection, msg);
        }
        String msg = "testing data can be inserted to message store." + String.format("test data : [%s, %d]", testString, testTime);
        this.close(preparedStatement, msg);
        this.close(connection, msg);
        return canInsert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testRead(Connection connection, String testString, long testTime) throws SQLException {
        ResultSet results;
        PreparedStatement selectPreparedStatement;
        boolean canRead;
        block4: {
            canRead = false;
            selectPreparedStatement = null;
            results = null;
            try {
                selectPreparedStatement = connection.prepareStatement("SELECT NODE_ID, TIME_STAMP FROM MB_MSG_STORE_STATUS WHERE NODE_ID=? AND TIME_STAMP=?");
                selectPreparedStatement.setString(1, testString);
                selectPreparedStatement.setLong(2, testTime);
                results = selectPreparedStatement.executeQuery();
                if (!results.next()) break block4;
                canRead = true;
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("testing data can be read from message store." + String.format("test data : [%s, %d]", testString, testTime)), (Throwable)e);
                }
                catch (Throwable throwable) {
                    String msg = "testing data can be read from message store." + String.format("test data : [%s, %d]", testString, testTime);
                    this.close(results, msg);
                    this.close(selectPreparedStatement, msg);
                    this.close(connection, msg);
                    throw throwable;
                }
                String msg = "testing data can be read from message store." + String.format("test data : [%s, %d]", testString, testTime);
                this.close(results, msg);
                this.close(selectPreparedStatement, msg);
                this.close(connection, msg);
            }
        }
        String msg = "testing data can be read from message store." + String.format("test data : [%s, %d]", testString, testTime);
        this.close(results, msg);
        this.close(selectPreparedStatement, msg);
        this.close(connection, msg);
        return canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDelete(Connection connection, String testString, long testTime) throws SQLException {
        boolean canDelete = false;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        try {
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("DELETE FROM MB_MSG_STORE_STATUS WHERE NODE_ID = ? AND TIME_STAMP = ?");
            preparedStatement.setString(1, testString);
            preparedStatement.setLong(2, testTime);
            preparedStatement.executeUpdate();
            connection.commit();
            canDelete = true;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "testing data can be deleted from message store." + String.format("test data : [%s, %d]", testString, testTime));
            }
            catch (Throwable throwable) {
                String msg = "testing data can be deleted from message store." + String.format("test data : [%s, %d]", testString, testTime);
                this.close(results, msg);
                this.close(preparedStatement, msg);
                this.close(connection, msg);
                throw throwable;
            }
            String msg = "testing data can be deleted from message store." + String.format("test data : [%s, %d]", testString, testTime);
            this.close(results, msg);
            this.close(preparedStatement, msg);
            this.close(connection, msg);
        }
        String msg = "testing data can be deleted from message store." + String.format("test data : [%s, %d]", testString, testTime);
        this.close(results, msg);
        this.close(preparedStatement, msg);
        this.close(connection, msg);
        return canDelete;
    }

    private void close(PreparedStatement preparedStatement, String task) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                log.error((Object)("Closing prepared statement failed after " + task), (Throwable)e);
            }
        }
    }

    private void close(ResultSet resultSet, String task) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)("Closing result set failed after " + task), (Throwable)e);
            }
        }
    }

    private void close(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.setAutoCommit(true);
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)("Failed to close connection after " + task), (Throwable)e);
            }
        }
    }

    private void rollback(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                log.warn((Object)("Rollback failed on " + task), (Throwable)e);
            }
        }
    }

    public <T> void raiseBatchUpdateException(List<T> dataList, Connection connection, BatchUpdateException bue, String task) throws AndesBatchUpdateException {
        int[] updateCountsOfFailedBatch = bue.getUpdateCounts();
        ArrayList<T> failed = new ArrayList<T>();
        ArrayList<T> succeded = new ArrayList<T>();
        for (int i = 0; i < updateCountsOfFailedBatch.length; ++i) {
            T msgPart = dataList.get(i);
            if (-3 == updateCountsOfFailedBatch[i]) {
                failed.add(msgPart);
                continue;
            }
            succeded.add(msgPart);
        }
        this.rollback(connection, task);
        AndesBatchUpdateException insertEx = new AndesBatchUpdateException(task + " failed", bue.getSQLState(), bue, failed, succeded);
        throw insertEx;
    }

    private Set<String> extractAndFill(ConfigurationProperties connectionProperties, String configParam) {
        Set<String> configValues = Collections.emptySet();
        String value = connectionProperties.getProperty(configParam);
        if (StringUtils.isNotBlank((String)value)) {
            Iterable splitValues = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)value);
            configValues = new HashSet<String>();
            for (String state : splitValues) {
                configValues.add(state);
            }
        }
        return configValues;
    }

    private int extractErrorCode(SQLException sqlException) {
        int errorCode = sqlException.getErrorCode();
        for (SQLException nextEx = sqlException.getNextException(); errorCode == 0 && nextEx != null; nextEx = nextEx.getNextException()) {
            errorCode = nextEx.getErrorCode();
        }
        return errorCode;
    }

    private String extractSqlState(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        for (SQLException nextEx = sqlException.getNextException(); sqlState == null && nextEx != null; nextEx = nextEx.getNextException()) {
            sqlState = nextEx.getSQLState();
        }
        return sqlState;
    }

    private String determineSqlStateClassCode(String sqlState) {
        if (sqlState == null || sqlState.length() < 2) {
            return sqlState;
        }
        return sqlState.substring(0, 2);
    }
}

