/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store.rdbms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.util.ConfigurationProperties;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DeliverableAndesMetadata;
import org.wso2.andes.kernel.DtxStore;
import org.wso2.andes.kernel.DurableStoreConnection;
import org.wso2.andes.kernel.MessageStore;
import org.wso2.andes.kernel.slot.RecoverySlotCreator;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.andes.store.AndesDataIntegrityViolationException;
import org.wso2.andes.store.cache.AndesMessageCache;
import org.wso2.andes.store.cache.MessageCacheFactory;
import org.wso2.andes.store.rdbms.RDBMSConnection;
import org.wso2.andes.store.rdbms.RDBMSDtxStoreImpl;
import org.wso2.andes.store.rdbms.RDBMSStoreUtils;
import org.wso2.andes.tools.utils.MessageTracer;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;

public class RDBMSMessageStoreImpl
implements MessageStore {
    private static final Logger log = Logger.getLogger(RDBMSMessageStoreImpl.class);
    private RDBMSConnection rdbmsConnection;
    private RDBMSStoreUtils rdbmsStoreUtils;
    private AndesMessageCache messageCache;
    private static final int STAT_PUBLISHING_INTERVAL = 10000;
    private static final String PS_SELECT_CONTENT_PART = "SELECT MESSAGE_CONTENT, MESSAGE_ID, CONTENT_OFFSET FROM MB_CONTENT WHERE MESSAGE_ID IN (";
    private LoadingCache<String, Integer> queueMappings;
    private DtxStore dtxStore;

    @Override
    public DurableStoreConnection initializeMessageStore(AndesContextStore contextStore, ConfigurationProperties connectionProperties) throws AndesException {
        this.rdbmsConnection = new RDBMSConnection();
        this.rdbmsConnection.initialize(connectionProperties);
        this.rdbmsStoreUtils = new RDBMSStoreUtils(connectionProperties);
        this.messageCache = new MessageCacheFactory().create();
        this.initializeQueueMappingCache();
        this.dtxStore = new RDBMSDtxStoreImpl(this, this.rdbmsStoreUtils);
        log.info((Object)"Message Store initialised");
        return this.rdbmsConnection;
    }

    private void initializeQueueMappingCache() {
        int QUEUE_CACHE_SIZE = 2;
        int QUEUE_CACHE_CONCURRENCY_LEVEL = 4;
        this.queueMappings = CacheBuilder.newBuilder().concurrencyLevel(4).maximumWeight(0x200000L).weigher((Weigher)new Weigher<String, Integer>(){

            public int weigh(String s, Integer integer) {
                return s.length();
            }
        }).build((CacheLoader)new CacheLoader<String, Integer>(){

            public Integer load(String queueName) throws AndesException {
                try {
                    Integer queueID = RDBMSMessageStoreImpl.this.getQueueID(queueName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loaded queue: " + queueName + " to the cache from database"));
                    }
                    return queueID;
                }
                catch (SQLException e) {
                    throw new AndesException("Error retrieving queue id for queue: " + queueName, e);
                }
            }
        });
    }

    @Override
    public void storeMessagePart(List<AndesMessagePart> partList) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context messageContentAdditionContext = MetricManager.timer((String)"org.wso2.mb.store.messagePart.add", (Level)Level.INFO).start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_CONTENT(MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) VALUES (?, ?, ?)");
            for (AndesMessagePart messagePart : partList) {
                this.addContentToBatch(preparedStatement, messagePart);
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (BatchUpdateException bue) {
            this.rdbmsStoreUtils.raiseBatchUpdateException(partList, connection, bue, "storing message parts.");
        }
        catch (SQLException e) {
            this.rollback(connection, "storing message parts.");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while adding message content to DB ", e);
        }
        finally {
            messageContentAdditionContext.stop();
            contextWrite.stop();
            this.close(connection, preparedStatement, "storing message parts.");
        }
    }

    private void addContentToBatch(PreparedStatement preparedStatement, AndesMessagePart messagePart) throws SQLException {
        preparedStatement.setLong(1, messagePart.getMessageID());
        preparedStatement.setInt(2, messagePart.getOffset());
        preparedStatement.setBytes(3, messagePart.getData());
        preparedStatement.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AndesMessagePart getContent(long messageId, int offsetValue) throws AndesException {
        AndesMessagePart messagePart = null;
        Timer.Context messageContentRetrievalContext = MetricManager.timer((String)"org.wso2.mb.store.content.get", (Level)Level.INFO).start();
        try {
            messagePart = this.getContentFromCache(messageId, offsetValue);
            if (null == messagePart) {
                messagePart = this.getContentFromStorage(messageId, offsetValue);
            }
        }
        finally {
            messageContentRetrievalContext.stop();
        }
        return messagePart;
    }

    private AndesMessagePart getContentFromStorage(long messageId, int offsetValue) throws AndesException {
        AndesMessagePart messagePart = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_CONTENT FROM MB_CONTENT WHERE MESSAGE_ID=? AND CONTENT_OFFSET=?");
            preparedStatement.setLong(1, messageId);
            preparedStatement.setInt(2, offsetValue);
            results = preparedStatement.executeQuery();
            if (results.next()) {
                messagePart = this.createMessagePart(results, messageId, offsetValue);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving message parts.");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving message content from DB [msg_id= " + messageId + " ]", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving message parts.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving message parts.");
        return messagePart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongObjectHashMap<List<AndesMessagePart>> getContent(LongArrayList messageIDList) throws AndesException {
        LongObjectHashMap<List<AndesMessagePart>> contentList = new LongObjectHashMap<List<AndesMessagePart>>(messageIDList.size());
        Timer.Context messageContentRetrievalContext = MetricManager.timer((String)"org.wso2.mb.store.contentBatch.get", (Level)Level.INFO).start();
        try {
            if (messageIDList.isEmpty()) {
                LongObjectHashMap<List<AndesMessagePart>> longObjectHashMap = contentList;
                return longObjectHashMap;
            }
            this.fillContentFromCache(messageIDList, contentList);
            if (!messageIDList.isEmpty()) {
                this.fillContentFromStorage(messageIDList, contentList);
            }
        }
        finally {
            messageContentRetrievalContext.stop();
        }
        return contentList;
    }

    private void fillContentFromStorage(LongArrayList messageIDList, LongObjectHashMap<List<AndesMessagePart>> contentList) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(this.getSelectContentPreparedStmt(messageIDList.size()));
            for (int mesageIDCounter = 0; mesageIDCounter < messageIDList.size(); ++mesageIDCounter) {
                preparedStatement.setLong(mesageIDCounter + 1, messageIDList.get(mesageIDCounter));
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long messageID = resultSet.getLong("MESSAGE_ID");
                int offset = resultSet.getInt("CONTENT_OFFSET");
                List<AndesMessagePart> partList = contentList.get(messageID);
                if (null == partList) {
                    partList = new ArrayList<AndesMessagePart>();
                    contentList.put(messageID, partList);
                }
                AndesMessagePart msgPart = this.createMessagePart(resultSet, messageID, offset);
                partList.add(msgPart);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving content for multiple messages");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving message content from DB for " + messageIDList.size() + " messages ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, resultSet, "retrieving content for multiple messages");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, resultSet, "retrieving content for multiple messages");
    }

    private AndesMessagePart createMessagePart(ResultSet results, long messageId, int offsetValue) throws SQLException {
        byte[] b = results.getBytes("MESSAGE_CONTENT");
        AndesMessagePart messagePart = new AndesMessagePart();
        messagePart.setMessageID(messageId);
        messagePart.setData(b);
        messagePart.setOffSet(offsetValue);
        return messagePart;
    }

    private String getSelectContentPreparedStmt(int messageCount) {
        StringBuilder stmtBuilder = new StringBuilder(PS_SELECT_CONTENT_PART);
        for (int i = 0; i < messageCount - 1; ++i) {
            stmtBuilder.append("?,");
        }
        stmtBuilder.append("?)");
        return stmtBuilder.toString();
    }

    @Override
    public void storeMessages(List<AndesMessage> messageList) throws AndesException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.prepareToStoreMessages(connection, messageList);
            connection.commit();
            this.addToCache(messageList);
        }
        catch (BatchUpdateException bue) {
            log.warn((Object)"Error occurred while inserting message list. Messages will be stored individually.", (Throwable)bue);
            this.rollback(connection, "adding metadata.");
            for (AndesMessage message : messageList) {
                this.storeMessage(message);
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "adding metadata.");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while inserting messages to queue ", e);
        }
        catch (AndesException e) {
            this.rollback(connection, "adding metadata.");
            throw e;
        }
        finally {
            this.close(connection, "adding messages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareToStoreMessages(Connection connection, List<AndesMessage> messageList) throws AndesException, SQLException {
        PreparedStatement storeMetadataPS = null;
        PreparedStatement storeContentPS = null;
        PreparedStatement storeExpiryMetadataPS = null;
        boolean messageWithExpirationDetected = false;
        try {
            storeMetadataPS = connection.prepareStatement("INSERT INTO MB_METADATA (MESSAGE_ID,QUEUE_ID,DLC_QUEUE_ID,MESSAGE_METADATA) VALUES ( ?,?,-1,? )");
            storeContentPS = connection.prepareStatement("INSERT INTO MB_CONTENT(MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) VALUES (?, ?, ?)");
            storeExpiryMetadataPS = connection.prepareStatement("INSERT INTO MB_EXPIRATION_DATA (MESSAGE_ID,EXPIRATION_TIME,DLC_QUEUE_ID,MESSAGE_DESTINATION) VALUES ( ?,?,-1,? )");
            for (AndesMessage message : messageList) {
                this.addMetadataToBatch(storeMetadataPS, message.getMetadata(), message.getMetadata().getStorageQueueName());
                if (message.getMetadata().isExpirationDefined()) {
                    messageWithExpirationDetected = true;
                    this.addExpiryTableEntryToBatch(storeExpiryMetadataPS, message.getMetadata());
                }
                for (AndesMessagePart messagePart : message.getContentChunkList()) {
                    this.addContentToBatch(storeContentPS, messagePart);
                }
            }
            storeMetadataPS.executeBatch();
            storeContentPS.executeBatch();
            if (messageWithExpirationDetected) {
                storeExpiryMetadataPS.executeBatch();
            }
            this.close(storeExpiryMetadataPS, "adding messages");
            this.close(storeMetadataPS, "adding messages");
            this.close(storeContentPS, "adding messages");
        }
        catch (Throwable throwable) {
            this.close(storeExpiryMetadataPS, "adding messages");
            this.close(storeMetadataPS, "adding messages");
            this.close(storeContentPS, "adding messages");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeMessage(AndesMessage message) throws AndesException {
        Connection connection = null;
        PreparedStatement storeMetadataPS = null;
        PreparedStatement storeContentPS = null;
        PreparedStatement storeExpiryMetadataPS = null;
        AndesMessageMetadata metadata = null;
        try {
            connection = this.getConnection();
            storeMetadataPS = connection.prepareStatement("INSERT INTO MB_METADATA (MESSAGE_ID,QUEUE_ID,DLC_QUEUE_ID,MESSAGE_METADATA) VALUES ( ?,?,-1,? )");
            storeExpiryMetadataPS = connection.prepareStatement("INSERT INTO MB_EXPIRATION_DATA (MESSAGE_ID,EXPIRATION_TIME,DLC_QUEUE_ID,MESSAGE_DESTINATION) VALUES ( ?,?,-1,? )");
            storeContentPS = connection.prepareStatement("INSERT INTO MB_CONTENT(MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) VALUES (?, ?, ?)");
            metadata = message.getMetadata();
            storeMetadataPS.setLong(1, metadata.getMessageID());
            storeMetadataPS.setInt(2, this.getCachedQueueID(metadata.getStorageQueueName()));
            storeMetadataPS.setBytes(3, metadata.getMetadata());
            storeMetadataPS.execute();
            for (AndesMessagePart messagePart : message.getContentChunkList()) {
                this.addContentToBatch(storeContentPS, messagePart);
            }
            storeContentPS.executeBatch();
            if (metadata.isExpirationDefined()) {
                storeExpiryMetadataPS.setLong(1, metadata.getMessageID());
                storeExpiryMetadataPS.setLong(2, metadata.getExpirationTime());
                storeExpiryMetadataPS.setString(3, metadata.getStorageQueueName());
                storeExpiryMetadataPS.execute();
            }
            connection.commit();
            this.addToCache(message);
            this.close(storeExpiryMetadataPS, "adding message.");
            this.close(storeMetadataPS, "adding message.");
            this.close(storeContentPS, "adding message.");
            this.close(connection, "adding message.");
            return;
        }
        catch (AndesException e) {
            try {
                this.rollback(connection, "adding message.");
                throw e;
                catch (SQLException e2) {
                    AndesException andesException;
                    if (metadata != null) {
                        log.warn((Object)("Dropped message with metadata :: " + metadata.toString()));
                    }
                    if (AndesDataIntegrityViolationException.class.isInstance(andesException = this.rdbmsStoreUtils.convertSQLException("Error occurred while inserting message to queue ", e2))) {
                        log.warn((Object)("Dropped message with ID: " + message.getMetadata().getMessageID() + " since queue: " + message.getMetadata().getStorageQueueName() + " does not exist"), (Throwable)e2);
                        this.close(storeExpiryMetadataPS, "adding message.");
                        this.close(storeMetadataPS, "adding message.");
                        this.close(storeContentPS, "adding message.");
                        this.close(connection, "adding message.");
                        return;
                    }
                    this.rollback(connection, "adding message.");
                    throw andesException;
                }
            }
            catch (Throwable throwable) {
                this.close(storeExpiryMetadataPS, "adding message.");
                this.close(storeMetadataPS, "adding message.");
                this.close(storeContentPS, "adding message.");
                this.close(connection, "adding message.");
                throw throwable;
            }
        }
    }

    @Override
    public void moveMetadataToQueue(long messageId, String currentQueueName, String targetQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_METADATA SET QUEUE_ID = ? WHERE MESSAGE_ID = ? AND QUEUE_ID = ?");
            preparedStatement.setInt(1, this.getCachedQueueID(targetQueueName));
            preparedStatement.setLong(2, messageId);
            preparedStatement.setInt(3, this.getCachedQueueID(currentQueueName));
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "updating message meta data queue." + targetQueueName);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while updating message metadata to destination queue " + targetQueueName, e);
        }
        finally {
            contextWrite.stop();
            this.close(connection, preparedStatement, "updating message meta data queue." + targetQueueName);
        }
    }

    @Override
    public void moveMetadataToDLC(long messageId, String dlcQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement metadataPS = null;
        PreparedStatement expiryDataPS = null;
        Timer.Context moveMetadataToDLCContext = MetricManager.timer((String)"org.wso2.mb.store.messageMetadataToDLC.Move", (Level)Level.INFO).start();
        this.removeFromCache(messageId);
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            metadataPS = connection.prepareStatement("UPDATE MB_METADATA SET DLC_QUEUE_ID=? WHERE MESSAGE_ID=?");
            int cachedQueueId = this.getCachedQueueID(dlcQueueName);
            metadataPS.setInt(1, cachedQueueId);
            metadataPS.setLong(2, messageId);
            metadataPS.execute();
            expiryDataPS = connection.prepareStatement("UPDATE MB_EXPIRATION_DATA SET DLC_QUEUE_ID=? WHERE MESSAGE_ID=?");
            expiryDataPS.setInt(1, cachedQueueId);
            expiryDataPS.setLong(2, messageId);
            expiryDataPS.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "moving message metadata to dlc.");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while moving message metadata to dead letter channel.", e);
            }
            catch (Throwable throwable) {
                contextWrite.stop();
                moveMetadataToDLCContext.stop();
                this.close(connection, "moving message metadata to dlc.");
                this.close(metadataPS, "moving message metadata to dlc.");
                this.close(expiryDataPS, "moving message metadata to dlc.");
                throw throwable;
            }
        }
        contextWrite.stop();
        moveMetadataToDLCContext.stop();
        this.close(connection, "moving message metadata to dlc.");
        this.close(metadataPS, "moving message metadata to dlc.");
        this.close(expiryDataPS, "moving message metadata to dlc.");
    }

    @Override
    public void moveMetadataToDLC(List<AndesMessageMetadata> messages, String dlcQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement metadataPS = null;
        PreparedStatement expiryDataPS = null;
        Timer.Context moveMetadataToDLCContext = MetricManager.timer((String)"org.wso2.mb.store.messageMetadataToDLC.Move", (Level)Level.INFO).start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        LongArrayList messageIDsToRemoveFromCache = new LongArrayList();
        try {
            connection = this.getConnection();
            metadataPS = connection.prepareStatement("UPDATE MB_METADATA SET DLC_QUEUE_ID=? WHERE MESSAGE_ID=?");
            int cachedQueueId = this.getCachedQueueID(dlcQueueName);
            expiryDataPS = connection.prepareStatement("UPDATE MB_EXPIRATION_DATA SET DLC_QUEUE_ID=? WHERE MESSAGE_ID=?");
            for (AndesMessageMetadata message : messages) {
                messageIDsToRemoveFromCache.add(message.getMessageID());
                metadataPS.setInt(1, cachedQueueId);
                metadataPS.setLong(2, message.getMessageID());
                expiryDataPS.setInt(1, cachedQueueId);
                expiryDataPS.setLong(2, message.getMessageID());
                metadataPS.addBatch();
                expiryDataPS.addBatch();
            }
            metadataPS.executeBatch();
            expiryDataPS.executeBatch();
            this.removeFromCache(messageIDsToRemoveFromCache);
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "moving message metadata to dlc.");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while moving message metadata to dead letter channel.", e);
        }
        finally {
            contextWrite.stop();
            moveMetadataToDLCContext.stop();
            this.close(connection, "moving message metadata to dlc.");
            this.close(metadataPS, "moving message metadata to dlc.");
            this.close(expiryDataPS, "moving message metadata to dlc.");
        }
    }

    @Override
    public void updateMetadataInformation(String currentQueueName, List<AndesMessageMetadata> metadataList) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context metaUpdateContext = MetricManager.timer((String)"org.wso2.mb.store.metadata.update", (Level)Level.INFO).start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_METADATA SET QUEUE_ID = ?,MESSAGE_METADATA = ? WHERE MESSAGE_ID = ? AND QUEUE_ID = ?");
            for (AndesMessageMetadata metadata : metadataList) {
                preparedStatement.setInt(1, this.getCachedQueueID(metadata.getStorageQueueName()));
                preparedStatement.setBytes(2, metadata.getMetadata());
                preparedStatement.setLong(3, metadata.getMessageID());
                preparedStatement.setInt(4, this.getCachedQueueID(currentQueueName));
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
            connection.commit();
        }
        catch (BatchUpdateException bue) {
            this.rdbmsStoreUtils.raiseBatchUpdateException(metadataList, connection, bue, "updating message meta data.");
        }
        catch (SQLException e) {
            this.rollback(connection, "updating message meta data.");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while updating message metadata list.", e);
        }
        finally {
            metaUpdateContext.stop();
            contextWrite.stop();
            this.close(connection, preparedStatement, "updating message meta data.");
        }
    }

    void addMetadataToBatch(PreparedStatement preparedStatement, AndesMessageMetadata metadata, String queueName) throws AndesException {
        Timer.Context metaAdditionToBatchContext = MetricManager.timer((String)"org.wso2.mb.store.metadataToBatch.add", (Level)Level.INFO).start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            preparedStatement.setLong(1, metadata.getMessageID());
            preparedStatement.setInt(2, this.getCachedQueueID(queueName));
            preparedStatement.setBytes(3, metadata.getMetadata());
            preparedStatement.addBatch();
        }
        catch (SQLException e) {
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while adding metadata with messaged id: " + metadata.getMessageID() + " to batch", e);
        }
        finally {
            metaAdditionToBatchContext.stop();
            contextWrite.stop();
        }
    }

    private void addExpiryTableEntryToBatch(PreparedStatement preparedStatement, AndesMessageMetadata metadata) throws SQLException {
        preparedStatement.setLong(1, metadata.getMessageID());
        preparedStatement.setLong(2, metadata.getExpirationTime());
        preparedStatement.setString(3, metadata.getStorageQueueName());
        preparedStatement.addBatch();
    }

    @Override
    public AndesMessageMetadata getMetadata(long messageId) throws AndesException {
        AndesMessage cached = this.getMessageFromCache(messageId);
        if (null != cached) {
            return cached.getMetadata();
        }
        AndesMessageMetadata md = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context metaRetrievalContext = MetricManager.timer((String)"org.wso2.mb.store.metadata.get", (Level)Level.INFO).start();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_METADATA FROM MB_METADATA WHERE MESSAGE_ID=?");
            preparedStatement.setLong(1, messageId);
            results = preparedStatement.executeQuery();
            if (results.next()) {
                byte[] b = results.getBytes("MESSAGE_METADATA");
                md = new AndesMessageMetadata(messageId, b, true);
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "retrieving metadata for message id. ");
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving message metadata for msg id:" + messageId, e);
        }
        finally {
            metaRetrievalContext.stop();
            contextRead.stop();
            this.close(connection, preparedStatement, results, "retrieving metadata for message id. " + messageId);
        }
        return md;
    }

    @Override
    public List<DeliverableAndesMetadata> getMetadataList(Slot slot, String storageQueueName, long firstMsgId, long lastMsgID) throws AndesException {
        ArrayList<DeliverableAndesMetadata> metadataList = new ArrayList<DeliverableAndesMetadata>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long getMetadataListExecutionStart = 0L;
        Timer.Context metaListRetrievalContext = MetricManager.timer((String)"org.wso2.mb.store.metadataList.get", (Level)Level.INFO).start();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID,MESSAGE_METADATA FROM MB_METADATA WHERE QUEUE_ID=? AND DLC_QUEUE_ID=-1 AND MESSAGE_ID BETWEEN ? AND ? ORDER BY MESSAGE_ID");
            preparedStatement.setInt(1, this.getCachedQueueID(storageQueueName));
            preparedStatement.setLong(2, firstMsgId);
            preparedStatement.setLong(3, lastMsgID);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started executing get metadata range query for queue :" + storageQueueName));
                getMetadataListExecutionStart = System.currentTimeMillis();
            }
            resultSet = preparedStatement.executeQuery();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time elapsed for execute get metadata range query " + storageQueueName + " : " + (System.currentTimeMillis() - getMetadataListExecutionStart) + " milliseconds."));
            }
            while (resultSet.next()) {
                DeliverableAndesMetadata md = new DeliverableAndesMetadata(slot, resultSet.getLong("MESSAGE_ID"), resultSet.getBytes("MESSAGE_METADATA"), true);
                md.setStorageQueueName(storageQueueName);
                metadataList.add(md);
                MessageTracer.trace(md, slot, "metadata read from database");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("request: metadata range (" + firstMsgId + " , " + lastMsgID + ") in destination queue " + storageQueueName + ", response: metadata count " + metadataList.size()));
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving metadata within a range from queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving messages between msg id " + firstMsgId + " and " + lastMsgID + " from queue " + storageQueueName, e);
            }
            catch (Throwable throwable) {
                metaListRetrievalContext.stop();
                contextRead.stop();
                this.close(connection, preparedStatement, resultSet, "retrieving metadata within a range from queue. " + storageQueueName);
                throw throwable;
            }
        }
        metaListRetrievalContext.stop();
        contextRead.stop();
        this.close(connection, preparedStatement, resultSet, "retrieving metadata within a range from queue. " + storageQueueName);
        return metadataList;
    }

    @Override
    public long getMessageCountForQueueInRange(String storageQueueName, long firstMessageId, long lastMessageId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long messageCount = 0L;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT COUNT(MESSAGE_ID) AS count FROM MB_METADATA WHERE QUEUE_ID=? AND MESSAGE_ID BETWEEN ? AND ? AND DLC_QUEUE_ID=-1");
            preparedStatement.setInt(1, this.getCachedQueueID(storageQueueName));
            preparedStatement.setLong(2, firstMessageId);
            preparedStatement.setLong(3, lastMessageId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                messageCount = resultSet.getInt("count");
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving ranged message count for queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving ranged message count for message ids between " + firstMessageId + " and " + lastMessageId + " from queue " + storageQueueName, e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, resultSet, "retrieving ranged message count for queue. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, resultSet, "retrieving ranged message count for queue. ");
        return messageCount;
    }

    @Override
    public int recoverSlotsForQueue(String storageQueueName, long firstMsgId, int messageLimitPerSlot, RecoverySlotCreator.CallBack callBack) throws AndesException {
        long messageCountForQueue = this.getMessageCountForQueue(storageQueueName);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        int restoreMessagesCounter = 0;
        Timer.Context nextMessageIdsRetrievalContext = MetricManager.timer((String)"org.wso2.mb.store.nextMessageIDsFromQueue.get", (Level)Level.INFO).start();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_METADATA WHERE MESSAGE_ID>? AND QUEUE_ID=? AND DLC_QUEUE_ID=-1 ORDER BY MESSAGE_ID");
            preparedStatement.setLong(1, firstMsgId - 1L);
            preparedStatement.setInt(2, this.getCachedQueueID(storageQueueName));
            results = preparedStatement.executeQuery();
            long lastStatPublishTime = System.currentTimeMillis();
            long batchStartMessageID = 0L;
            int currentBatchCount = 0;
            long currentMessageId = 0L;
            while (results.next()) {
                currentMessageId = results.getLong("MESSAGE_ID");
                if (currentBatchCount == 0) {
                    batchStartMessageID = currentMessageId;
                }
                if (++currentBatchCount == messageLimitPerSlot) {
                    callBack.initializeSlotMapForQueue(storageQueueName, batchStartMessageID, currentMessageId, messageLimitPerSlot);
                    restoreMessagesCounter += currentBatchCount;
                    currentBatchCount = 0;
                }
                lastStatPublishTime = this.publishStat(storageQueueName, messageCountForQueue, restoreMessagesCounter, lastStatPublishTime);
            }
            if (currentBatchCount > 0 && currentBatchCount < messageLimitPerSlot) {
                restoreMessagesCounter += currentBatchCount;
                callBack.initializeSlotMapForQueue(storageQueueName, batchStartMessageID, currentMessageId, messageLimitPerSlot);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving message id list from queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving message ids from queue ", e);
            }
            catch (Throwable throwable) {
                nextMessageIdsRetrievalContext.stop();
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving message id list from queue. ");
                throw throwable;
            }
        }
        nextMessageIdsRetrievalContext.stop();
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving message id list from queue. ");
        return restoreMessagesCounter;
    }

    private long publishStat(String storageQueueName, long messageCountForQueue, int restoreMessagesCounter, long lastStatPublishTime) {
        long currentTimeInMillis = System.currentTimeMillis();
        if (currentTimeInMillis - lastStatPublishTime > 10000L) {
            double recoveredPercentage = (double)restoreMessagesCounter / ((double)messageCountForQueue * 1.0) * 100.0;
            log.info((Object)(restoreMessagesCounter + "/" + messageCountForQueue + " (" + Math.round(recoveredPercentage) + "%) messages recovered for queue \"" + storageQueueName + "\""));
            lastStatPublishTime = currentTimeInMillis;
        }
        return lastStatPublishTime;
    }

    @Override
    public List<AndesMessageMetadata> getNextNMessageMetadataFromQueue(String storageQueueName, long firstMsgId, int count) throws AndesException {
        ArrayList<AndesMessageMetadata> mdList = new ArrayList<AndesMessageMetadata>(count);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context nextMetaRetrievalContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.nextMessageMetadataFromQueue.get").start();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID,MESSAGE_METADATA FROM MB_METADATA WHERE MESSAGE_ID>? AND QUEUE_ID=? AND DLC_QUEUE_ID=-1 ORDER BY MESSAGE_ID");
            preparedStatement.setLong(1, firstMsgId - 1L);
            preparedStatement.setInt(2, this.getCachedQueueID(storageQueueName));
            results = preparedStatement.executeQuery();
            for (int resultCount = 0; results.next() && resultCount != count; ++resultCount) {
                AndesMessageMetadata md = new AndesMessageMetadata(results.getLong("MESSAGE_ID"), results.getBytes("MESSAGE_METADATA"), true);
                md.setStorageQueueName(storageQueueName);
                mdList.add(md);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving metadata list from queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving message metadata from queue ", e);
            }
            catch (Throwable throwable) {
                nextMetaRetrievalContext.stop();
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving metadata list from queue. ");
                throw throwable;
            }
        }
        nextMetaRetrievalContext.stop();
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving metadata list from queue. ");
        return mdList;
    }

    @Override
    public List<AndesMessageMetadata> getNextNMessageMetadataForQueueFromDLC(String storageQueueName, String dlcQueueName, long firstMsgId, int count) throws AndesException {
        ArrayList<AndesMessageMetadata> mdList = new ArrayList<AndesMessageMetadata>(count);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context nextMetaRetrievalContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.nextMessageMetadataInDLCForQueue.get").start();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID,MESSAGE_METADATA FROM MB_METADATA WHERE MESSAGE_ID>? AND QUEUE_ID=? AND DLC_QUEUE_ID=? ORDER BY MESSAGE_ID");
            preparedStatement.setLong(1, firstMsgId - 1L);
            preparedStatement.setInt(2, this.getCachedQueueID(storageQueueName));
            preparedStatement.setInt(3, this.getCachedQueueID(dlcQueueName));
            results = preparedStatement.executeQuery();
            for (int resultCount = 0; results.next() && resultCount != count; ++resultCount) {
                AndesMessageMetadata md = new AndesMessageMetadata(results.getLong("MESSAGE_ID"), results.getBytes("MESSAGE_METADATA"), true);
                md.setStorageQueueName(storageQueueName);
                mdList.add(md);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving metadata list in DLC for queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving message metadata from queue ", e);
            }
            catch (Throwable throwable) {
                nextMetaRetrievalContext.stop();
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving metadata list in DLC for queue. ");
                throw throwable;
            }
        }
        nextMetaRetrievalContext.stop();
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving metadata list in DLC for queue. ");
        return mdList;
    }

    @Override
    public List<AndesMessageMetadata> getNextNMessageMetadataFromDLC(String dlcQueueName, long firstMsgId, int count) throws AndesException {
        ArrayList<AndesMessageMetadata> mdList = new ArrayList<AndesMessageMetadata>(count);
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context nextMetaRetrievalContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.nextMessageMetadataInDLC.get").start();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID,MESSAGE_METADATA FROM MB_METADATA WHERE MESSAGE_ID>? AND DLC_QUEUE_ID=? ORDER BY MESSAGE_ID");
            preparedStatement.setLong(1, firstMsgId - 1L);
            preparedStatement.setInt(2, this.getCachedQueueID(dlcQueueName));
            results = preparedStatement.executeQuery();
            for (int resultCount = 0; results.next() && resultCount != count; ++resultCount) {
                AndesMessageMetadata md = new AndesMessageMetadata(results.getLong("MESSAGE_ID"), results.getBytes("MESSAGE_METADATA"), true);
                md.setStorageQueueName(dlcQueueName);
                mdList.add(md);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving metadata list from DLC ");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving message metadata from queue ", e);
            }
            catch (Throwable throwable) {
                nextMetaRetrievalContext.stop();
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving metadata list from DLC ");
                throw throwable;
            }
        }
        nextMetaRetrievalContext.stop();
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving metadata list from DLC ");
        return mdList;
    }

    @Override
    public void deleteMessageMetadataFromQueue(String storageQueueName, List<AndesMessageMetadata> messagesToRemove) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context metaDeletionContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.messageMetadataFromQueue.delete").start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            int queueID = this.getCachedQueueID(storageQueueName);
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE  FROM MB_METADATA WHERE QUEUE_ID=? AND MESSAGE_ID=?");
            for (AndesMessageMetadata messageID : messagesToRemove) {
                preparedStatement.setInt(1, queueID);
                preparedStatement.setLong(2, messageID.getMessageID());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Metadata removed. " + messagesToRemove.size() + " metadata from destination " + storageQueueName));
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting metadata" + storageQueueName);
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while deleting message metadata from queue ", e);
        }
        finally {
            metaDeletionContext.stop();
            contextWrite.stop();
            this.close(connection, preparedStatement, "deleting metadata" + storageQueueName);
        }
    }

    @Override
    public void deleteMessages(Collection<? extends AndesMessageMetadata> messagesToRemove) throws AndesException {
        Connection connection = null;
        PreparedStatement metadataRemovalPreparedStatement = null;
        Timer.Context messageDeletionContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.messageMetadataAndContent.delete").start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            this.prepareToDeleteMessages(connection, messagesToRemove);
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Metadata and content removed for " + messagesToRemove.size() + " messages."));
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting metadata");
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while deleting message metadata and content ", e);
        }
        finally {
            messageDeletionContext.stop();
            contextWrite.stop();
            this.close(connection, metadataRemovalPreparedStatement, "deleting metadata");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareToDeleteMessages(Connection connection, Collection<? extends AndesMessageMetadata> messagesToRemove) throws AndesException, SQLException {
        PreparedStatement metadataRemovalPreparedStatement = null;
        try {
            LongArrayList messageIDsToRemoveFromCache = new LongArrayList();
            metadataRemovalPreparedStatement = connection.prepareStatement("DELETE  FROM MB_METADATA WHERE MESSAGE_ID=?");
            for (AndesMessageMetadata andesMessageMetadata : messagesToRemove) {
                messageIDsToRemoveFromCache.add(andesMessageMetadata.getMessageID());
                metadataRemovalPreparedStatement.setLong(1, andesMessageMetadata.getMessageID());
                metadataRemovalPreparedStatement.addBatch();
            }
            this.removeFromCache(messageIDsToRemoveFromCache);
            metadataRemovalPreparedStatement.executeBatch();
            this.close(metadataRemovalPreparedStatement, "deleting metadata");
        }
        catch (Throwable throwable) {
            this.close(metadataRemovalPreparedStatement, "deleting metadata");
            throw throwable;
        }
    }

    @Override
    public void deleteMessages(List<Long> messagesToRemove) throws AndesException {
        Connection connection = null;
        PreparedStatement metadataRemovalPreparedStatement = null;
        Timer.Context messageDeletionContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.messageMetadataAndContent.delete").start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            LongArrayList messageIDsToRemoveFromCache = new LongArrayList();
            connection = this.getConnection();
            metadataRemovalPreparedStatement = connection.prepareStatement("DELETE  FROM MB_METADATA WHERE MESSAGE_ID=?");
            for (long messageID : messagesToRemove) {
                messageIDsToRemoveFromCache.add(messageID);
                metadataRemovalPreparedStatement.setLong(1, messageID);
                metadataRemovalPreparedStatement.addBatch();
            }
            this.removeFromCache(messageIDsToRemoveFromCache);
            metadataRemovalPreparedStatement.executeBatch();
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Metadata and content removed: " + messagesToRemove.size()));
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting message parts.");
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while deleting message metadata and content for queue ", e);
        }
        finally {
            messageDeletionContext.stop();
            contextWrite.stop();
            this.close(connection, metadataRemovalPreparedStatement, "deleting message parts.");
        }
    }

    @Override
    public void deleteDLCMessages(List<AndesMessageMetadata> messagesToRemove) throws AndesException {
        Connection connection = null;
        PreparedStatement metadataRemovalPreparedStatement = null;
        Timer.Context messageDeletionContext = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.store.messageMetadataAndContent.delete").start();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            metadataRemovalPreparedStatement = connection.prepareStatement("DELETE  FROM MB_METADATA WHERE MESSAGE_ID=? AND DLC_QUEUE_ID!= -1");
            for (AndesMessageMetadata message : messagesToRemove) {
                metadataRemovalPreparedStatement.setLong(1, message.getMessageID());
                metadataRemovalPreparedStatement.addBatch();
            }
            metadataRemovalPreparedStatement.executeBatch();
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Messages removed: " + messagesToRemove.size() + " from DLC"));
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting message from dlc. ");
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while deleting message in dlc.", e);
        }
        finally {
            messageDeletionContext.stop();
            contextWrite.stop();
            this.close(connection, metadataRemovalPreparedStatement, "deleting message from dlc. ");
        }
    }

    @Override
    public List<Long> getExpiredMessages(long lowerBoundMessageID, String queueName) throws AndesException {
        ArrayList<Long> arrayList;
        Connection connection = null;
        ArrayList<Long> list = new ArrayList<Long>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID,MESSAGE_DESTINATION FROM MB_EXPIRATION_DATA WHERE EXPIRATION_TIME<? AND MESSAGE_ID>=? AND MESSAGE_DESTINATION=?");
            preparedStatement.setLong(1, System.currentTimeMillis());
            preparedStatement.setLong(2, lowerBoundMessageID);
            preparedStatement.setString(3, queueName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                list.add(resultSet.getLong("MESSAGE_ID"));
            }
            connection.commit();
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving expired messages.");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving expired messages.", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, resultSet, "retrieving expired messages.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, resultSet, "retrieving expired messages.");
        return arrayList;
    }

    @Override
    public List<Long> getExpiredMessagesFromDLC(long messageCount) throws AndesException {
        ArrayList<Long> arrayList;
        Connection connection = null;
        ArrayList<Long> list = new ArrayList<Long>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_EXPIRATION_DATA WHERE EXPIRATION_TIME<? AND DLC_QUEUE_ID != -1");
            preparedStatement.setLong(1, System.currentTimeMillis());
            resultSet = preparedStatement.executeQuery();
            for (long resultCount = 0L; resultSet.next() && resultCount != messageCount; ++resultCount) {
                list.add(resultSet.getLong("MESSAGE_ID"));
            }
            connection.commit();
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving expired messages.");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving expired messages.", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, resultSet, "retrieving expired messages.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, resultSet, "retrieving expired messages.");
        return arrayList;
    }

    @Override
    public void close() {
    }

    @Override
    public DtxStore getDtxStore() {
        return this.dtxStore;
    }

    protected int getCachedQueueID(String destinationQueueName) throws AndesException {
        try {
            return (Integer)this.queueMappings.get((Object)destinationQueueName);
        }
        catch (ExecutionException e) {
            throw new AndesException("Error retrieving queue id for queue: " + destinationQueueName + " from cache", e);
        }
    }

    private int getQueueID(String destinationQueueName) throws SQLException {
        int queueID = -1;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT QUEUE_ID FROM MB_QUEUE_MAPPING WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, destinationQueueName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                queueID = resultSet.getInt("QUEUE_ID");
            }
            resultSet.close();
            if (queueID == -1) {
                this.createNewQueue(connection, destinationQueueName);
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                queueID = resultSet.getInt("QUEUE_ID");
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "retrieving queue id for queue. ");
            log.error((Object)("Error occurred while retrieving destination queue id for destination queue " + destinationQueueName), (Throwable)e);
            throw e;
        }
        finally {
            contextRead.stop();
            this.close(connection, preparedStatement, resultSet, "retrieving queue id for queue. " + destinationQueueName);
        }
        return queueID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewQueue(Connection connection, String destinationQueueName) throws SQLException {
        block7: {
            PreparedStatement preparedStatement = null;
            Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
            try {
                preparedStatement = connection.prepareStatement("INSERT INTO MB_QUEUE_MAPPING (QUEUE_NAME)  VALUES (?)");
                preparedStatement.setString(1, destinationQueueName);
                preparedStatement.executeUpdate();
                connection.commit();
                preparedStatement.close();
                int queueId = this.getQueueID(destinationQueueName);
                if (-1 != queueId) {
                    this.queueMappings.put((Object)destinationQueueName, (Object)queueId);
                }
            }
            catch (SQLException e) {
                AndesException andesException = this.rdbmsStoreUtils.convertSQLException("Error occurred while creating queue", e);
                if (andesException instanceof AndesDataIntegrityViolationException) {
                    log.warn((Object)("Queue already created. Skipping insert destination queue [" + destinationQueueName + "] to database "));
                    break block7;
                }
                log.error((Object)("Error occurred while inserting destination queue [" + destinationQueueName + "] to database "));
                throw e;
            }
            finally {
                contextWrite.stop();
                String task = "creating queue. " + destinationQueueName;
                this.close(preparedStatement, task);
            }
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.rdbmsConnection.getDataSource().getConnection();
    }

    protected void close(Connection connection, String task) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Failed to close connection after " + task), (Throwable)e);
        }
    }

    protected void rollback(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                log.warn((Object)("Rollback failed on " + task), (Throwable)e);
            }
        }
    }

    protected void close(PreparedStatement preparedStatement, String task) {
        try {
            if (preparedStatement != null && !preparedStatement.isClosed()) {
                preparedStatement.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Closing prepared statement failed after " + task), (Throwable)e);
        }
    }

    private void close(Connection connection, PreparedStatement preparedStatement, String task) {
        this.close(preparedStatement, task);
        this.close(connection, task);
    }

    private void close(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet, String task) {
        this.close(resultSet, task);
        this.close(preparedStatement, task);
        this.close(connection, task);
    }

    protected void close(ResultSet resultSet, String task) {
        try {
            if (resultSet != null && !resultSet.isClosed()) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)("Closing result set failed after " + task), (Throwable)e);
        }
    }

    @Override
    public void addMessageToExpiryQueue(Long messageId, Long expirationTime, boolean isMessageForTopic, String destination) throws AndesException {
    }

    @Override
    public int deleteAllMessageMetadata(String storageQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        int deletedMessagecount = 0;
        try {
            int queueID = this.getCachedQueueID(storageQueueName);
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE  FROM MB_METADATA WHERE QUEUE_ID=?");
            preparedStatement.setInt(1, queueID);
            deletedMessagecount = preparedStatement.executeUpdate();
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DELETED all message metadata from " + storageQueueName + " with queue ID " + queueID));
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting metadata" + storageQueueName);
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while clearing message metadata from queue :" + storageQueueName, e);
        }
        finally {
            contextWrite.stop();
            this.close(connection, preparedStatement, "deleting metadata" + storageQueueName);
        }
        return deletedMessagecount;
    }

    @Override
    public int clearDLCQueue(String dlcQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        int deletedMessagecount = 0;
        try {
            int queueID = this.getCachedQueueID(dlcQueueName);
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE  FROM MB_METADATA WHERE DLC_QUEUE_ID=?");
            preparedStatement.setInt(1, queueID);
            deletedMessagecount = preparedStatement.executeUpdate();
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("DELETED all message metadata for dlc queue " + dlcQueueName + " with queue ID " + queueID));
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "clearing dlc queue. " + dlcQueueName);
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while clearing dlc queue:" + dlcQueueName, e);
        }
        finally {
            contextWrite.stop();
            this.close(connection, preparedStatement, "clearing dlc queue. " + dlcQueueName);
        }
        return deletedMessagecount;
    }

    @Override
    public LongArrayList getMessageIDsAddressedToQueue(String storageQueueName, Long startMessageID) throws AndesException {
        LongArrayList messageIDs = new LongArrayList();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_METADATA WHERE QUEUE_ID=? ORDER BY MESSAGE_ID");
            preparedStatement.setInt(1, this.getCachedQueueID(storageQueueName));
            results = preparedStatement.executeQuery();
            while (results.next()) {
                messageIDs.add(results.getLong("MESSAGE_ID"));
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "retrieving message ID list from queue. ");
            throw this.rdbmsStoreUtils.convertSQLException("Error while getting message IDs for queue : " + storageQueueName, e);
        }
        finally {
            contextRead.stop();
            this.close(connection, preparedStatement, results, "retrieving message ID list from queue. " + storageQueueName);
        }
        return messageIDs;
    }

    @Override
    public void addQueue(String destinationQueueName) throws AndesException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.getCachedQueueID(destinationQueueName);
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "creating queue. ");
            throw this.rdbmsStoreUtils.convertSQLException("Error while creating queue: " + destinationQueueName, e);
        }
        finally {
            this.close(connection, "creating queue. " + destinationQueueName);
        }
    }

    @Override
    public Map<String, Integer> getMessageCountForAllQueues(List<String> queueNames) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        HashMap<String, Integer> queueMessageCountForName = new HashMap<String, Integer>();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT QUEUE_NAME, count FROM MB_QUEUE_MAPPING LEFT OUTER JOIN (SELECT QUEUE_ID, COUNT(QUEUE_ID) AS count FROM MB_METADATA WHERE DLC_QUEUE_ID=-1 GROUP BY QUEUE_ID ) QUEUE_COUNT ON MB_QUEUE_MAPPING.QUEUE_ID=QUEUE_COUNT.QUEUE_ID");
            results = preparedStatement.executeQuery();
            while (results.next()) {
                String queueName = results.getString("QUEUE_NAME");
                if (DLCQueueUtils.isDeadLetterQueue(queueName) || !queueNames.contains(queueName)) continue;
                queueMessageCountForName.put(queueName, results.getInt("count"));
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "retrieving message count for queue. ");
            throw this.rdbmsStoreUtils.convertSQLException("Error while getting message count for all queues", e);
        }
        finally {
            contextRead.stop();
            this.close(connection, preparedStatement, results, "retrieving message count for queue. ");
        }
        return queueMessageCountForName;
    }

    @Override
    public long getMessageCountForQueue(String storageQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        long messageCount = 0L;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT COUNT(QUEUE_ID) AS count FROM MB_METADATA WHERE QUEUE_ID=? AND DLC_QUEUE_ID=-1");
            preparedStatement.setInt(1, this.getCachedQueueID(storageQueueName));
            results = preparedStatement.executeQuery();
            while (results.next()) {
                messageCount = results.getLong("count");
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "retrieving message count for queue. ");
            throw this.rdbmsStoreUtils.convertSQLException("Error while getting message count from queue " + storageQueueName, e);
        }
        finally {
            contextRead.stop();
            this.close(connection, preparedStatement, results, "retrieving message count for queue. " + storageQueueName);
        }
        return messageCount;
    }

    @Override
    public long getApproximateQueueMessageCount(String storageQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        long messageCount = 0L;
        Timer.Context contextRead = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.database.read").start();
        int previousTransactionIsolationValue = -1;
        try {
            connection = this.getConnection();
            if (connection.getMetaData().supportsTransactionIsolationLevel(1)) {
                previousTransactionIsolationValue = connection.getTransactionIsolation();
                connection.setTransactionIsolation(1);
            }
            preparedStatement = connection.prepareStatement("SELECT COUNT(QUEUE_ID) AS count FROM MB_METADATA WHERE QUEUE_ID=? AND DLC_QUEUE_ID=-1");
            preparedStatement.setInt(1, this.getCachedQueueID(storageQueueName));
            results = preparedStatement.executeQuery();
            while (results.next()) {
                messageCount = results.getLong("count");
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "retrieving message count for queue. ");
            throw this.rdbmsStoreUtils.convertSQLException("Error while getting message count from queue " + storageQueueName, e);
        }
        finally {
            contextRead.stop();
            try {
                if (connection != null && previousTransactionIsolationValue != -1) {
                    connection.setTransactionIsolation(previousTransactionIsolationValue);
                }
            }
            catch (SQLException e) {
                log.error((Object)("Error while reverting transaction isolation value after reading queue count for" + storageQueueName), (Throwable)e);
            }
            this.close(connection, preparedStatement, results, "retrieving message count for queue. " + storageQueueName);
        }
        return messageCount;
    }

    @Override
    public long getMessageCountForQueueInDLC(String storageQueueName, String dlcQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        long messageCount = 0L;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT COUNT(MESSAGE_ID) AS count FROM MB_METADATA WHERE QUEUE_ID=? AND DLC_QUEUE_ID=?");
            preparedStatement.setInt(1, this.getCachedQueueID(storageQueueName));
            preparedStatement.setInt(2, this.getCachedQueueID(dlcQueueName));
            results = preparedStatement.executeQuery();
            while (results.next()) {
                messageCount = results.getLong("count");
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving message count in DLC for queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error while getting message count in DLC from queue " + storageQueueName, e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving message count in DLC for queue. " + storageQueueName);
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving message count in DLC for queue. " + storageQueueName);
        return messageCount;
    }

    @Override
    public long getMessageCountForDLCQueue(String dlcQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        long messageCount = 0L;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT COUNT(MESSAGE_ID) AS count FROM MB_METADATA WHERE DLC_QUEUE_ID=?");
            preparedStatement.setInt(1, this.getCachedQueueID(dlcQueueName));
            results = preparedStatement.executeQuery();
            while (results.next()) {
                messageCount = results.getLong("count");
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving message count in DLC for queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error while getting message count in DLC from queue ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving message count in DLC for queue. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving message count in DLC for queue. ");
        return messageCount;
    }

    @Override
    public void resetMessageCounterForQueue(String storageQueueName) throws AndesException {
    }

    @Override
    public void removeQueue(String storageQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_QUEUE_MAPPING WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, storageQueueName);
            preparedStatement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting queue mapping");
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while deleting queue mapping for queue: " + storageQueueName + "from database.", e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "deleting queue mapping");
            this.close(connection, "deleting queue mapping");
        }
    }

    @Override
    public void removeLocalQueueData(String storageQueueName) {
        this.queueMappings.invalidate((Object)storageQueueName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Queue: " + storageQueueName + " removed from cache."));
        }
    }

    @Override
    public void incrementMessageCountForQueue(String destinationQueueName, long incrementBy) throws AndesException {
    }

    @Override
    public void decrementMessageCountForQueue(String destinationQueueName, long decrementBy) throws AndesException {
    }

    @Override
    public void storeRetainedMessages(Map<String, AndesMessage> retainMap) throws AndesException {
        Connection connection = null;
        PreparedStatement updateMetadataPreparedStatement = null;
        PreparedStatement deleteContentPreparedStatement = null;
        PreparedStatement deleteMetadataPreparedStatement = null;
        PreparedStatement insertContentPreparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        boolean batchEmpty = true;
        try {
            connection = this.getConnection();
            updateMetadataPreparedStatement = connection.prepareStatement("UPDATE MB_RETAINED_METADATA SET MESSAGE_ID = ?, MESSAGE_METADATA = ? WHERE TOPIC_ID = ?");
            deleteContentPreparedStatement = connection.prepareStatement("DELETE FROM MB_RETAINED_CONTENT WHERE MESSAGE_ID=?");
            deleteMetadataPreparedStatement = connection.prepareStatement("DELETE FROM MB_RETAINED_METADATA WHERE MESSAGE_ID=?");
            insertContentPreparedStatement = connection.prepareStatement("INSERT INTO MB_RETAINED_CONTENT(MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) VALUES (?, ?, ?)");
            for (AndesMessage message : retainMap.values()) {
                AndesMessageMetadata metadata = message.getMetadata();
                String destination = metadata.getDestination();
                RetainedItemData retainedItemData = this.getRetainedTopicID(connection, destination);
                if (null != retainedItemData) {
                    if (batchEmpty) {
                        batchEmpty = false;
                    }
                    this.addRetainedMessageToUpdateBatch(updateMetadataPreparedStatement, deleteContentPreparedStatement, deleteMetadataPreparedStatement, insertContentPreparedStatement, message, metadata, retainedItemData);
                    retainedItemData.messageID = metadata.getMessageID();
                    continue;
                }
                if (message.getContentChunkList().isEmpty() || message.getContentChunkList().get(0).getDataLength() == 0) continue;
                this.createRetainedEntry(connection, message);
            }
            if (!batchEmpty) {
                deleteContentPreparedStatement.executeBatch();
                deleteMetadataPreparedStatement.executeBatch();
                updateMetadataPreparedStatement.executeBatch();
                insertContentPreparedStatement.executeBatch();
                connection.commit();
            }
        }
        catch (SQLException e) {
            this.rollback(connection, "storing retained messages.");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while adding retained message content to DB ", e);
        }
        finally {
            contextWrite.stop();
            this.close(updateMetadataPreparedStatement, "storing retained messages.");
            this.close(deleteContentPreparedStatement, "storing retained messages.");
            this.close(deleteMetadataPreparedStatement, "storing retained messages.");
            this.close(insertContentPreparedStatement, "storing retained messages.");
            this.close(connection, "storing retained messages.");
        }
    }

    private void addRetainedMessageToUpdateBatch(PreparedStatement updateMetadataPreparedStatement, PreparedStatement deleteContentPreparedStatement, PreparedStatement deleteMetadataPreparedStatement, PreparedStatement insertContentPreparedStatement, AndesMessage message, AndesMessageMetadata metadata, RetainedItemData retainedItemData) throws SQLException {
        boolean isRetainTopicSetToDelete = false;
        if (!message.getContentChunkList().isEmpty() && message.getContentChunkList().get(0).getDataLength() == 0) {
            isRetainTopicSetToDelete = true;
            deleteMetadataPreparedStatement.setLong(1, retainedItemData.messageID);
            deleteMetadataPreparedStatement.addBatch();
            deleteContentPreparedStatement.setLong(1, retainedItemData.messageID);
            deleteContentPreparedStatement.addBatch();
        }
        if (!isRetainTopicSetToDelete) {
            updateMetadataPreparedStatement.setLong(1, metadata.getMessageID());
            updateMetadataPreparedStatement.setBytes(2, metadata.getMetadata());
            updateMetadataPreparedStatement.setInt(3, retainedItemData.topicID);
            updateMetadataPreparedStatement.addBatch();
            deleteContentPreparedStatement.setLong(1, retainedItemData.messageID);
            deleteContentPreparedStatement.addBatch();
            for (AndesMessagePart messagePart : message.getContentChunkList()) {
                insertContentPreparedStatement.setLong(1, metadata.getMessageID());
                insertContentPreparedStatement.setInt(2, messagePart.getOffset());
                insertContentPreparedStatement.setBytes(3, messagePart.getData());
                insertContentPreparedStatement.addBatch();
            }
        }
    }

    private RetainedItemData getRetainedTopicID(Connection connection, String destination) throws AndesException {
        PreparedStatement preparedStatementForMetadataSelect = null;
        RetainedItemData itemData = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        ResultSet results = null;
        try {
            preparedStatementForMetadataSelect = connection.prepareStatement("SELECT TOPIC_ID, MESSAGE_ID FROM MB_RETAINED_METADATA WHERE TOPIC_NAME=?");
            preparedStatementForMetadataSelect.setString(1, destination);
            results = preparedStatementForMetadataSelect.executeQuery();
            if (results.next()) {
                int topicID = results.getInt("TOPIC_ID");
                long messageID = results.getLong("MESSAGE_ID");
                itemData = new RetainedItemData(topicID, messageID);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving retained  message id and topic id for given destination.");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving retained  message id and topic id for given destination.", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(results, "retrieving retained  message id and topic id for given destination.");
                this.close(preparedStatementForMetadataSelect, "retrieving retained  message id and topic id for given destination.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(results, "retrieving retained  message id and topic id for given destination.");
        this.close(preparedStatementForMetadataSelect, "retrieving retained  message id and topic id for given destination.");
        return itemData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetainedItemData createRetainedEntry(Connection connection, AndesMessage message) throws SQLException {
        RetainedItemData retainedItemData;
        PreparedStatement preparedStatementForContent = null;
        PreparedStatement preparedStatementForMetadata = null;
        AndesMessageMetadata metadata = message.getMetadata();
        String destination = metadata.getDestination();
        Integer topicID = destination.hashCode();
        long messageID = metadata.getMessageID();
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            preparedStatementForMetadata = connection.prepareStatement("INSERT INTO MB_RETAINED_METADATA (TOPIC_ID,TOPIC_NAME,MESSAGE_ID,MESSAGE_METADATA) VALUES ( ?,?,?,? )");
            preparedStatementForMetadata.setInt(1, topicID);
            preparedStatementForMetadata.setString(2, destination);
            preparedStatementForMetadata.setLong(3, messageID);
            preparedStatementForMetadata.setBytes(4, metadata.getMetadata());
            preparedStatementForMetadata.addBatch();
            preparedStatementForContent = connection.prepareStatement("INSERT INTO MB_RETAINED_CONTENT(MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) VALUES (?, ?, ?)");
            for (AndesMessagePart messagePart : message.getContentChunkList()) {
                preparedStatementForContent.setLong(1, messageID);
                preparedStatementForContent.setInt(2, messagePart.getOffset());
                preparedStatementForContent.setBytes(3, messagePart.getData());
                preparedStatementForContent.addBatch();
            }
            preparedStatementForMetadata.executeBatch();
            preparedStatementForContent.executeBatch();
            connection.commit();
            retainedItemData = new RetainedItemData(topicID, messageID);
        }
        catch (Throwable throwable) {
            contextWrite.stop();
            this.close(preparedStatementForContent, "storing retained messages.");
            this.close(preparedStatementForMetadata, "storing retained messages.");
            throw throwable;
        }
        contextWrite.stop();
        this.close(preparedStatementForContent, "storing retained messages.");
        this.close(preparedStatementForMetadata, "storing retained messages.");
        return retainedItemData;
    }

    @Override
    public List<String> getAllRetainedTopics() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatementForTopicSelect = null;
        ArrayList<String> topicList = new ArrayList<String>();
        ResultSet results = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatementForTopicSelect = connection.prepareStatement("SELECT TOPIC_NAME FROM MB_RETAINED_METADATA");
            results = preparedStatementForTopicSelect.executeQuery();
            while (results.next()) {
                topicList.add(results.getString("TOPIC_NAME"));
            }
            connection.commit();
            this.close(connection, preparedStatementForTopicSelect, results, "retrieving all retained topics");
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving all retained topics");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while reading retained topics ", e);
            }
            catch (Throwable throwable) {
                this.close(connection, preparedStatementForTopicSelect, results, "retrieving all retained topics");
                contextRead.stop();
                throw throwable;
            }
        }
        contextRead.stop();
        return topicList;
    }

    @Override
    public DeliverableAndesMetadata getRetainedMetadata(String destination) throws AndesException {
        DeliverableAndesMetadata metadata = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            RetainedItemData retainedItemData = this.getRetainedTopicID(connection, destination);
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID, MESSAGE_METADATA FROM MB_RETAINED_METADATA WHERE TOPIC_ID=?");
            preparedStatement.setLong(1, retainedItemData.topicID);
            results = preparedStatement.executeQuery();
            if (results.next()) {
                byte[] b = results.getBytes("MESSAGE_METADATA");
                long messageId = results.getLong("MESSAGE_ID");
                metadata = new DeliverableAndesMetadata(null, messageId, b, true);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "Retrieve retained message for destination");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while retrieving retained message for destination:" + destination, e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "Retrieve retained message for destination");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "Retrieve retained message for destination");
        return metadata;
    }

    @Override
    public Map<Integer, AndesMessagePart> getRetainedContentParts(long messageID) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        HashMap<Integer, AndesMessagePart> contentParts = new HashMap<Integer, AndesMessagePart>();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT CONTENT_OFFSET, MESSAGE_CONTENT FROM MB_RETAINED_CONTENT WHERE MESSAGE_ID=?");
            preparedStatement.setLong(1, messageID);
            results = preparedStatement.executeQuery();
            while (results.next()) {
                byte[] b = results.getBytes("MESSAGE_CONTENT");
                int offset = results.getInt("CONTENT_OFFSET");
                AndesMessagePart messagePart = new AndesMessagePart();
                messagePart.setMessageID(messageID);
                messagePart.setData(b);
                messagePart.setOffSet(offset);
                contentParts.put(offset, messagePart);
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving retained message parts.");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving retained message content from DB [msg_id=" + messageID + "]", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving retained message parts.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving retained message parts.");
        return contentParts;
    }

    @Override
    public boolean isOperational(String testString, long testTime) {
        try {
            return this.rdbmsStoreUtils.testInsert(this.getConnection(), testString, testTime) && this.rdbmsStoreUtils.testRead(this.getConnection(), testString, testTime) && this.rdbmsStoreUtils.testDelete(this.getConnection(), testString, testTime);
        }
        catch (SQLException e) {
            return false;
        }
    }

    private void addToCache(AndesMessage message) {
        this.messageCache.addToCache(message);
    }

    private void addToCache(List<AndesMessage> messages) {
        for (AndesMessage message : messages) {
            this.messageCache.addToCache(message);
        }
    }

    private void removeFromCache(LongArrayList messagesToRemove) {
        this.messageCache.removeFromCache(messagesToRemove);
    }

    private void removeFromCache(long messageToRemove) {
        this.messageCache.removeFromCache(messageToRemove);
    }

    private AndesMessage getMessageFromCache(long messageId) {
        return this.messageCache.getMessageFromCache(messageId);
    }

    private void fillContentFromCache(LongArrayList messageIDList, LongObjectHashMap<List<AndesMessagePart>> contentList) {
        this.messageCache.fillContentFromCache(messageIDList, contentList);
    }

    private AndesMessagePart getContentFromCache(long messageId, int offsetValue) {
        return this.messageCache.getContentFromCache(messageId, offsetValue);
    }

    @Override
    public List<Long> getMessageIdsInDLCForQueue(String sourceQueueName, String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        ArrayList<Long> messageIds = new ArrayList<Long>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context contextRead = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.database.read").start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_METADATA WHERE QUEUE_ID=? AND MESSAGE_ID>? AND DLC_QUEUE_ID=?  ORDER BY MESSAGE_ID");
            preparedStatement.setInt(1, this.getCachedQueueID(sourceQueueName));
            preparedStatement.setLong(2, startMessageId);
            preparedStatement.setInt(3, this.getCachedQueueID(dlcQueueName));
            results = preparedStatement.executeQuery();
            for (int resultCount = 0; results.next() && resultCount != messageLimit; ++resultCount) {
                messageIds.add(results.getLong("MESSAGE_ID"));
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving message ID list in DLC from queue. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error while getting message IDs in DLC for queue : " + sourceQueueName, e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving message ID list in DLC from queue. " + sourceQueueName);
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving message ID list in DLC from queue. " + sourceQueueName);
        return messageIds;
    }

    @Override
    public List<Long> getMessageIdsInDLC(String dlcQueueName, long startMessageId, int messageLimit) throws AndesException {
        ArrayList<Long> messageIds = new ArrayList<Long>();
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet results = null;
        Timer.Context contextRead = MetricManager.timer((Level)Level.INFO, (String)"org.wso2.mb.database.read").start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_METADATA WHERE MESSAGE_ID>? AND DLC_QUEUE_ID=?  ORDER BY MESSAGE_ID");
            preparedStatement.setLong(1, startMessageId);
            preparedStatement.setInt(2, this.getCachedQueueID(dlcQueueName));
            results = preparedStatement.executeQuery();
            for (int resultCount = 0; results.next() && resultCount != messageLimit; ++resultCount) {
                messageIds.add(results.getLong("MESSAGE_ID"));
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving message ID list in DLC.");
                throw this.rdbmsStoreUtils.convertSQLException("Error while getting message IDs in DLC", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(connection, preparedStatement, results, "retrieving message ID list in DLC.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(connection, preparedStatement, results, "retrieving message ID list in DLC.");
        return messageIds;
    }

    private static class RetainedItemData {
        public int topicID;
        public long messageID;

        private RetainedItemData(Integer topicID, long messageID) {
            this.topicID = topicID;
            this.messageID = messageID;
        }
    }
}

