/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.wso2.andes.dtx.XidImpl;
import org.wso2.andes.kernel.Andes;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessageMetadata;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.kernel.DtxStore;
import org.wso2.andes.kernel.dtx.AndesPreparedMessageMetadata;
import org.wso2.andes.kernel.dtx.DtxBranch;
import org.wso2.andes.server.ClusterResourceHolder;
import org.wso2.andes.store.rdbms.RDBMSMessageStoreImpl;
import org.wso2.andes.store.rdbms.RDBMSStoreUtils;

public class RDBMSDtxStoreImpl
implements DtxStore {
    private RDBMSMessageStoreImpl rdbmsMessageStore;
    private RDBMSStoreUtils rdbmsStoreUtils;
    private Andes uniqueIdGenerator;

    RDBMSDtxStoreImpl(RDBMSMessageStoreImpl rdbmsMessageStore, RDBMSStoreUtils rdbmsStoreUtils) {
        this.rdbmsMessageStore = rdbmsMessageStore;
        this.rdbmsStoreUtils = rdbmsStoreUtils;
        this.uniqueIdGenerator = Andes.getInstance();
    }

    @Override
    public long storeDtxRecords(Xid xid, List<AndesMessage> enqueueRecords, List<? extends AndesMessageMetadata> dequeueRecords) throws AndesException {
        Connection connection = null;
        String taskDescription = "Storing dtx enqueue/dequeue records for dtx.prepare";
        try {
            connection = this.rdbmsMessageStore.getConnection();
            long internalXid = this.prepareToStoreXid(xid, connection);
            this.prepareToStoreEnqueuedRecords(enqueueRecords, internalXid, connection);
            if (!dequeueRecords.isEmpty()) {
                this.prepareToBackupDequeueRecords(dequeueRecords, internalXid, connection);
                this.rdbmsMessageStore.prepareToDeleteMessages(connection, dequeueRecords);
            }
            connection.commit();
            long l = internalXid;
            return l;
        }
        catch (AndesException e) {
            this.rdbmsMessageStore.rollback(connection, taskDescription);
            throw e;
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, taskDescription);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while storing dtx records for dtx.prepare", e);
        }
        finally {
            this.rdbmsMessageStore.close(connection, taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareToBackupDequeueRecords(List<? extends AndesMessageMetadata> dequeueRecords, long internalXid, Connection connection) throws SQLException, AndesException {
        PreparedStatement storeDequeueRecordMetadataPS = null;
        PreparedStatement backupDequeueMessagesPS = null;
        String taskDescription = "prepare to store dequeued messages for dtx prepare stage";
        try {
            storeDequeueRecordMetadataPS = connection.prepareStatement("INSERT INTO MB_DTX_DEQUEUE_RECORD (INTERNAL_XID,MESSAGE_ID,QUEUE_NAME,MESSAGE_METADATA) VALUES ( ?,?,?,? )");
            backupDequeueMessagesPS = connection.prepareStatement("INSERT INTO MB_DTX_DEQUEUE_CONTENT (INTERNAL_XID,MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) SELECT ?,MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT FROM MB_CONTENT WHERE MESSAGE_ID=?");
            for (AndesMessageMetadata andesMessageMetadata : dequeueRecords) {
                storeDequeueRecordMetadataPS.setLong(1, internalXid);
                storeDequeueRecordMetadataPS.setLong(2, andesMessageMetadata.getMessageID());
                storeDequeueRecordMetadataPS.setString(3, andesMessageMetadata.getStorageQueueName());
                storeDequeueRecordMetadataPS.setBytes(4, andesMessageMetadata.getMetadata());
                storeDequeueRecordMetadataPS.addBatch();
                backupDequeueMessagesPS.setLong(1, internalXid);
                backupDequeueMessagesPS.setLong(2, andesMessageMetadata.getMessageID());
                backupDequeueMessagesPS.addBatch();
            }
            storeDequeueRecordMetadataPS.executeBatch();
            backupDequeueMessagesPS.executeBatch();
        }
        finally {
            this.rdbmsMessageStore.close(storeDequeueRecordMetadataPS, taskDescription);
            this.rdbmsMessageStore.close(backupDequeueMessagesPS, taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareToStoreEnqueuedRecords(List<AndesMessage> enqueueRecords, long internalXid, Connection connection) throws SQLException {
        PreparedStatement storeMetadataPS = null;
        PreparedStatement storeContentPS = null;
        String taskDescription = "prepare to store enqueued records for dtx prepare stage";
        try {
            storeMetadataPS = connection.prepareStatement("INSERT INTO MB_DTX_ENQUEUE_RECORD (INTERNAL_XID,MESSAGE_ID,MESSAGE_METADATA) VALUES ( ?,?,? )");
            storeContentPS = connection.prepareStatement("INSERT INTO MB_DTX_ENQUEUE_CONTENT(INTERNAL_XID,MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) VALUES (?, ?, ?, ?)");
            for (AndesMessage message : enqueueRecords) {
                long temporaryMessageId = this.uniqueIdGenerator.generateUniqueId();
                AndesMessageMetadata metadata = message.getMetadata();
                storeMetadataPS.setLong(1, internalXid);
                storeMetadataPS.setLong(2, temporaryMessageId);
                storeMetadataPS.setBytes(3, metadata.getMetadata());
                storeMetadataPS.addBatch();
                for (AndesMessagePart messagePart : message.getContentChunkList()) {
                    storeContentPS.setLong(1, internalXid);
                    storeContentPS.setLong(2, temporaryMessageId);
                    storeContentPS.setInt(3, messagePart.getOffset());
                    storeContentPS.setBytes(4, messagePart.getData());
                    storeContentPS.addBatch();
                }
            }
            storeMetadataPS.executeBatch();
            storeContentPS.executeBatch();
        }
        finally {
            this.rdbmsMessageStore.close(storeMetadataPS, taskDescription);
            this.rdbmsMessageStore.close(storeContentPS, taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long prepareToStoreXid(Xid xid, Connection connection) throws SQLException {
        PreparedStatement storeXidPS = null;
        String taskDescription = "prepare to store new Xid";
        try {
            storeXidPS = connection.prepareStatement("INSERT INTO MB_DTX_XID (INTERNAL_XID,NODE_ID,FORMAT_CODE,GLOBAL_ID,BRANCH_ID) VALUES ( ?,?,?,?,? )");
            String nodeId = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
            long internalXid = this.uniqueIdGenerator.generateUniqueId();
            storeXidPS.setLong(1, internalXid);
            storeXidPS.setString(2, nodeId);
            storeXidPS.setInt(3, xid.getFormatId());
            storeXidPS.setBytes(4, xid.getGlobalTransactionId());
            storeXidPS.setBytes(5, xid.getBranchQualifier());
            storeXidPS.executeUpdate();
            long l = internalXid;
            return l;
        }
        finally {
            this.rdbmsMessageStore.close(storeXidPS, taskDescription);
        }
    }

    @Override
    public void updateOnCommit(long internalXid, List<AndesMessage> enqueueRecords) throws AndesException {
        Connection connection = null;
        String task = "Updating records on dtx.commit ";
        try {
            connection = this.rdbmsMessageStore.getConnection();
            if (!enqueueRecords.isEmpty()) {
                this.rdbmsMessageStore.prepareToStoreMessages(connection, enqueueRecords);
            }
            this.removePreparedRecords(internalXid, connection);
            connection.commit();
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while executing dtx commit event", e);
        }
        finally {
            this.rdbmsMessageStore.close(connection, "executing dtx commit event.");
        }
    }

    @Override
    public void updateOnOnePhaseCommit(List<AndesMessage> enqueueRecords, List<AndesPreparedMessageMetadata> dequeueRecordsMetadata) throws AndesException {
        Connection connection = null;
        String task = "Updating records on dtx.onephase.commit ";
        try {
            connection = this.rdbmsMessageStore.getConnection();
            if (!enqueueRecords.isEmpty()) {
                this.rdbmsMessageStore.prepareToStoreMessages(connection, enqueueRecords);
            }
            if (!dequeueRecordsMetadata.isEmpty()) {
                this.rdbmsMessageStore.prepareToDeleteMessages(connection, dequeueRecordsMetadata);
            }
            connection.commit();
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while executing dtx commit event", e);
        }
        finally {
            this.rdbmsMessageStore.close(connection, "executing dtx commit event.");
        }
    }

    @Override
    public void updateOnRollback(long internalXid, List<AndesPreparedMessageMetadata> messagesToRestore) throws AndesException {
        Connection connection = null;
        String task = "Rolling back records on dtx.rollback ";
        try {
            connection = this.rdbmsMessageStore.getConnection();
            this.restoreRolledBackAcknowledgedMessages(messagesToRestore, connection);
            this.removePreparedRecords(internalXid, connection);
            connection.commit();
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while executing dtx commit event", e);
        }
        finally {
            this.rdbmsMessageStore.close(connection, "deleting dtx xid data from dtx store.");
        }
    }

    @Override
    public long recoverBranchData(DtxBranch branch, String nodeId) throws AndesException {
        Connection connection = null;
        String task = "Recovering DtxBranch in node " + nodeId;
        try {
            connection = this.rdbmsMessageStore.getConnection();
            long internalXid = this.getInternalXid(branch.getXid(), nodeId, connection);
            if (internalXid == -1L) {
                long l = -1L;
                return l;
            }
            this.recoverEnqueueMessages(internalXid, branch, connection);
            this.recoverDequeueMessages(internalXid, branch, connection);
            connection.commit();
            long l = internalXid;
            return l;
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while recovering DtxBranch ", e);
        }
        finally {
            this.rdbmsMessageStore.close(connection, task);
        }
    }

    @Override
    public Set<XidImpl> getStoredXidSet(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "Retrieving stored xids for node " + nodeId;
        HashSet<HashSet<XidImpl>> xidSet = new HashSet<HashSet<XidImpl>>();
        ResultSet resultSet = null;
        try {
            HashSet<XidImpl> xid;
            connection = this.rdbmsMessageStore.getConnection();
            preparedStatement = connection.prepareStatement("SELECT FORMAT_CODE,BRANCH_ID,GLOBAL_ID FROM MB_DTX_XID");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                xid = new XidImpl(resultSet.getBytes("BRANCH_ID"), resultSet.getInt("FORMAT_CODE"), resultSet.getBytes("GLOBAL_ID"));
                xidSet.add(xid);
            }
            connection.commit();
            xid = xidSet;
            this.rdbmsMessageStore.close(resultSet, task);
            this.rdbmsMessageStore.close(preparedStatement, task);
            this.rdbmsMessageStore.close(connection, task);
            return xid;
        }
        catch (SQLException e) {
            try {
                this.rdbmsMessageStore.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while recovering DtxBranch ", e);
            }
            catch (Throwable throwable) {
                this.rdbmsMessageStore.close(resultSet, task);
                this.rdbmsMessageStore.close(preparedStatement, task);
                this.rdbmsMessageStore.close(connection, task);
                throw throwable;
            }
        }
    }

    private void recoverDequeueMessages(long internalXid, DtxBranch branch, Connection connection) throws AndesException {
        PreparedStatement preparedStatement = null;
        String task = "Recovering dequeued messages for internal xid " + internalXid;
        try {
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID,QUEUE_NAME,MESSAGE_METADATA FROM MB_DTX_DEQUEUE_RECORD WHERE INTERNAL_XID=?");
            preparedStatement.setLong(1, internalXid);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<AndesPreparedMessageMetadata> dtxMetadataList = new ArrayList<AndesPreparedMessageMetadata>();
            while (resultSet.next()) {
                AndesMessageMetadata metadata = new AndesMessageMetadata(resultSet.getLong("MESSAGE_ID"), resultSet.getBytes("MESSAGE_METADATA"), true);
                metadata.setStorageQueueName(resultSet.getString("QUEUE_NAME"));
                AndesPreparedMessageMetadata dtxMetadata = new AndesPreparedMessageMetadata(metadata);
                dtxMetadataList.add(dtxMetadata);
            }
            branch.setMessagesToRestore(dtxMetadataList);
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while recovering DtxBranch ", e);
        }
    }

    private void recoverEnqueueMessages(long internalXid, DtxBranch branch, Connection connection) throws AndesException {
        PreparedStatement retrieveMetadataPS = null;
        PreparedStatement retrieveContentPS = null;
        ResultSet metadataResultSet = null;
        ResultSet contentResultSet = null;
        String task = "Recovering enqueue records for internal xid " + internalXid;
        try {
            retrieveMetadataPS = connection.prepareStatement("SELECT MESSAGE_ID,MESSAGE_METADATA FROM MB_DTX_ENQUEUE_RECORD WHERE INTERNAL_XID=?");
            retrieveContentPS = connection.prepareStatement("SELECT MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT FROM MB_DTX_ENQUEUE_CONTENT WHERE INTERNAL_XID=?");
            retrieveMetadataPS.setLong(1, internalXid);
            metadataResultSet = retrieveMetadataPS.executeQuery();
            HashMap<Long, AndesMessage> messageMap = new HashMap<Long, AndesMessage>();
            while (metadataResultSet.next()) {
                AndesMessageMetadata metadata = new AndesMessageMetadata(metadataResultSet.getLong("MESSAGE_ID"), metadataResultSet.getBytes("MESSAGE_METADATA"), true);
                AndesMessage andesMessage = new AndesMessage(metadata);
                messageMap.put(metadata.getMessageID(), andesMessage);
            }
            retrieveContentPS.setLong(1, internalXid);
            contentResultSet = retrieveContentPS.executeQuery();
            while (contentResultSet.next()) {
                long messageId = contentResultSet.getLong("MESSAGE_ID");
                AndesMessage message = (AndesMessage)messageMap.get(messageId);
                AndesMessagePart contentChunk = new AndesMessagePart();
                contentChunk.setMessageID(messageId);
                contentChunk.setOffSet(contentResultSet.getInt("CONTENT_OFFSET"));
                byte[] data = contentResultSet.getBytes("MESSAGE_CONTENT");
                contentChunk.setData(data);
                message.addMessagePart(contentChunk);
            }
            branch.setMessagesToStore(messageMap.values());
            this.rdbmsMessageStore.close(metadataResultSet, task);
            this.rdbmsMessageStore.close(retrieveMetadataPS, task);
            this.rdbmsMessageStore.close(contentResultSet, task);
            this.rdbmsMessageStore.close(retrieveContentPS, task);
        }
        catch (SQLException e) {
            try {
                this.rdbmsMessageStore.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while recovering enqueued messages for internal xid " + internalXid, e);
            }
            catch (Throwable throwable) {
                this.rdbmsMessageStore.close(metadataResultSet, task);
                this.rdbmsMessageStore.close(retrieveMetadataPS, task);
                this.rdbmsMessageStore.close(contentResultSet, task);
                this.rdbmsMessageStore.close(retrieveContentPS, task);
                throw throwable;
            }
        }
    }

    private long getInternalXid(Xid xid, String nodeId, Connection connection) throws AndesException {
        PreparedStatement retreiveXidPS = null;
        String task = "Recovering DtxBranch in node " + nodeId;
        try {
            retreiveXidPS = connection.prepareStatement("SELECT INTERNAL_XID FROM MB_DTX_XID WHERE FORMAT_CODE=? AND BRANCH_ID=? AND GLOBAL_ID=? AND NODE_ID=?");
            retreiveXidPS.setLong(1, xid.getFormatId());
            retreiveXidPS.setBytes(2, xid.getBranchQualifier());
            retreiveXidPS.setBytes(3, xid.getGlobalTransactionId());
            retreiveXidPS.setString(4, nodeId);
            ResultSet resultSet = retreiveXidPS.executeQuery();
            if (resultSet.first()) {
                long l = resultSet.getLong("INTERNAL_XID");
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (SQLException e) {
            this.rdbmsMessageStore.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while recovering DtxBranch internal Xid ", e);
        }
        finally {
            this.rdbmsMessageStore.close(retreiveXidPS, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreRolledBackAcknowledgedMessages(List<AndesPreparedMessageMetadata> messagesToRestore, Connection connection) throws SQLException, AndesException {
        PreparedStatement storeMetadataPS = null;
        PreparedStatement restoreContentPS = null;
        String taskDescription = "Restore acknowledged messages on dtx.rollback";
        try {
            storeMetadataPS = connection.prepareStatement("INSERT INTO MB_METADATA (MESSAGE_ID,QUEUE_ID,DLC_QUEUE_ID,MESSAGE_METADATA) VALUES ( ?,?,-1,? )");
            restoreContentPS = connection.prepareStatement("INSERT INTO MB_CONTENT (MESSAGE_ID,CONTENT_OFFSET,MESSAGE_CONTENT) SELECT ?,CONTENT_OFFSET,MESSAGE_CONTENT FROM MB_DTX_DEQUEUE_CONTENT WHERE MESSAGE_ID=?");
            for (AndesPreparedMessageMetadata metadata : messagesToRestore) {
                storeMetadataPS.setLong(1, metadata.getMessageID());
                storeMetadataPS.setLong(2, this.rdbmsMessageStore.getCachedQueueID(metadata.getStorageQueueName()));
                storeMetadataPS.setBytes(3, metadata.getMetadata());
                storeMetadataPS.addBatch();
                restoreContentPS.setLong(1, metadata.getMessageID());
                restoreContentPS.setLong(2, metadata.getOldMessageId());
                restoreContentPS.addBatch();
            }
            storeMetadataPS.executeBatch();
            restoreContentPS.executeBatch();
        }
        finally {
            this.rdbmsMessageStore.close(storeMetadataPS, taskDescription);
            this.rdbmsMessageStore.close(restoreContentPS, taskDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePreparedRecords(long internalXid, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            String nodeId = ClusterResourceHolder.getInstance().getClusterManager().getMyNodeID();
            statement = connection.prepareStatement("DELETE FROM MB_DTX_XID WHERE INTERNAL_XID =? AND NODE_ID =?");
            statement.setLong(1, internalXid);
            statement.setString(2, nodeId);
            statement.execute();
            this.rdbmsMessageStore.close(statement, "deleting dtx xid data from dtx store.");
        }
        catch (Throwable throwable) {
            this.rdbmsMessageStore.close(statement, "deleting dtx xid data from dtx store.");
            throw throwable;
        }
    }

    @Override
    public boolean isOperational(String testString, long testTime) {
        return this.rdbmsMessageStore.isOperational(testString, testTime);
    }
}

