/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.wso2.andes.configuration.util.ConfigurationProperties;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DurableStoreConnection;

public class RDBMSConnection
extends DurableStoreConnection {
    private static final Logger logger = Logger.getLogger(RDBMSConnection.class);
    private javax.sql.DataSource datasource;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void initialize(ConfigurationProperties connectionProperties) throws AndesException {
        super.initialize(connectionProperties);
        Connection connection = null;
        String jndiLookupName = "";
        String dataSourceUserName = "";
        try {
            DataSource tcDataSource;
            jndiLookupName = connectionProperties.getProperty("dataSource");
            this.datasource = (javax.sql.DataSource)InitialContext.doLookup(jndiLookupName);
            if (this.datasource instanceof DataSource && StringUtils.isNotBlank((String)(tcDataSource = (DataSource)this.datasource).getUsername())) {
                dataSourceUserName = tcDataSource.getUsername();
            }
            connection = this.datasource.getConnection();
            logger.info((Object)("JDBC connection established with jndi config " + jndiLookupName));
            String task = "Initialising database";
            this.close(connection, task);
            return;
        }
        catch (SQLException e) {
            try {
                throw new AndesException("Connecting to database failed with jndi lookup : " + jndiLookupName + ". data source username : " + dataSourceUserName + ". SQL Error message : " + e.getMessage(), e);
                catch (NamingException e2) {
                    throw new AndesException("Couldn't look up jndi entry for \"" + jndiLookupName + "\"", e2);
                }
            }
            catch (Throwable throwable) {
                String task = "Initialising database";
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    public javax.sql.DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public void close() {
    }

    @Override
    public Object getConnection() {
        return this;
    }

    private void close(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error((Object)("Failed to close connection after " + task), (Throwable)e);
            }
        }
    }
}

