/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store.rdbms;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.util.ConfigurationProperties;
import org.wso2.andes.kernel.AndesBinding;
import org.wso2.andes.kernel.AndesContextStore;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.DurableStoreConnection;
import org.wso2.andes.kernel.router.AndesMessageRouter;
import org.wso2.andes.kernel.router.MessageRouterFactory;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.kernel.slot.SlotState;
import org.wso2.andes.kernel.subscription.AndesSubscription;
import org.wso2.andes.kernel.subscription.StorageQueue;
import org.wso2.andes.server.cluster.NodeHeartBeatData;
import org.wso2.andes.server.cluster.coordination.ClusterNotification;
import org.wso2.andes.server.cluster.coordination.rdbms.MembershipEvent;
import org.wso2.andes.server.cluster.coordination.rdbms.MembershipEventType;
import org.wso2.andes.store.AndesDataIntegrityViolationException;
import org.wso2.andes.store.rdbms.RDBMSConnection;
import org.wso2.andes.store.rdbms.RDBMSConstants;
import org.wso2.andes.store.rdbms.RDBMSStoreUtils;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;

public class RDBMSAndesContextStoreImpl
implements AndesContextStore {
    private static final Logger logger = Logger.getLogger(RDBMSAndesContextStoreImpl.class);
    private DataSource datasource;
    private RDBMSStoreUtils rdbmsStoreUtils;

    @Override
    public DurableStoreConnection init(ConfigurationProperties connectionProperties) throws AndesException {
        RDBMSConnection rdbmsConnection = new RDBMSConnection();
        rdbmsConnection.initialize(connectionProperties);
        this.rdbmsStoreUtils = new RDBMSStoreUtils(connectionProperties);
        this.datasource = rdbmsConnection.getDataSource();
        logger.info((Object)"Andes Context Store initialised");
        return rdbmsConnection;
    }

    @Override
    public Map<String, List<String>> getAllStoredDurableSubscriptions() throws AndesException {
        Object destinationId;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<Object, ArrayList<String>> subscriberMap = new HashMap<Object, ArrayList<String>>();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT DESTINATION_IDENTIFIER,SUBSCRIPTION_DATA FROM MB_DURABLE_SUBSCRIPTION");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                destinationId = resultSet.getString("DESTINATION_IDENTIFIER");
                ArrayList<String> subscriberList = (ArrayList<String>)subscriberMap.get(destinationId);
                if (subscriberList == null) {
                    subscriberList = new ArrayList<String>();
                    subscriberMap.put(destinationId, subscriberList);
                }
                subscriberList.add(resultSet.getString("SUBSCRIPTION_DATA"));
            }
            connection.commit();
            destinationId = subscriberMap;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving all durable subscriptions. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving all durable subscriptions. ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving all durable subscriptions. ");
                this.close(preparedStatement, "retrieving all durable subscriptions. ");
                this.close(connection, "retrieving all durable subscriptions. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving all durable subscriptions. ");
        this.close(preparedStatement, "retrieving all durable subscriptions. ");
        this.close(connection, "retrieving all durable subscriptions. ");
        return destinationId;
    }

    @Override
    public Map<String, String> getAllDurableSubscriptionsByID() throws AndesException {
        Object subId;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<Object, String> subscriberMap = new HashMap<Object, String>();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT SUBSCRIPTION_ID,SUBSCRIPTION_DATA FROM MB_DURABLE_SUBSCRIPTION");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                subId = resultSet.getString("SUBSCRIPTION_ID");
                String subscriber = resultSet.getString("SUBSCRIPTION_DATA");
                subscriberMap.put(subId, subscriber);
            }
            connection.commit();
            subId = subscriberMap;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving all durable subscriptions. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving all durable subscriptions. ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving all durable subscriptions. ");
                this.close(preparedStatement, "retrieving all durable subscriptions. ");
                this.close(connection, "retrieving all durable subscriptions. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving all durable subscriptions. ");
        this.close(preparedStatement, "retrieving all durable subscriptions. ");
        this.close(connection, "retrieving all durable subscriptions. ");
        return subId;
    }

    @Override
    public boolean isSubscriptionExist(String subscriptionId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT 1 FROM MB_DURABLE_SUBSCRIPTION WHERE SUBSCRIPTION_ID=?");
            preparedStatement.setString(1, subscriptionId);
            resultSet = preparedStatement.executeQuery();
            connection.commit();
            boolean bl = resultSet.next();
            this.close(resultSet, "checking subscription existence");
            this.close(preparedStatement, "checking subscription existence");
            this.close(connection, "checking subscription existence");
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "checking subscription existence");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while checking subscription existence", e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "checking subscription existence");
                this.close(preparedStatement, "checking subscription existence");
                this.close(connection, "checking subscription existence");
                throw throwable;
            }
        }
    }

    @Override
    public void storeDurableSubscription(AndesSubscription subscription) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        String destinationIdentifier = this.getDestinationIdentifier(subscription);
        String subscriptionID = this.generateSubscriptionID(subscription);
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_DURABLE_SUBSCRIPTION (DESTINATION_IDENTIFIER, SUBSCRIPTION_ID, SUBSCRIPTION_DATA)  VALUES (?,?,?)");
            preparedStatement.setString(1, destinationIdentifier);
            preparedStatement.setString(2, subscriptionID);
            preparedStatement.setString(3, subscription.encodeAsStr());
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "storing durable subscription");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while storing durable subscription. sub id: " + subscriptionID + " destination identifier: " + destinationIdentifier, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "storing durable subscription");
            this.close(connection, "storing durable subscription");
        }
    }

    @Override
    public int updateDurableSubscription(AndesSubscription subscription) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        String destinationIdentifier = this.getDestinationIdentifier(subscription);
        String subscriptionID = this.generateSubscriptionID(subscription);
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_DURABLE_SUBSCRIPTION SET SUBSCRIPTION_DATA=? WHERE DESTINATION_IDENTIFIER=? AND SUBSCRIPTION_ID=?");
            preparedStatement.setString(1, subscription.encodeAsStr());
            preparedStatement.setString(2, destinationIdentifier);
            preparedStatement.setString(3, subscriptionID);
            int updateCount = preparedStatement.executeUpdate();
            connection.commit();
            int n = updateCount;
            return n;
        }
        catch (SQLException e) {
            this.rollback(connection, "updating durable subscription");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while updating durable subscription. sub id: " + subscriptionID + " destination identifier: " + destinationIdentifier, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "updating durable subscription");
            this.close(connection, "updating durable subscription");
        }
    }

    @Override
    public void updateOrInsertDurableSubscription(AndesSubscription subscription) throws AndesException {
        int updateCount = this.updateDurableSubscription(subscription);
        if (0 == updateCount) {
            this.storeDurableSubscription(subscription);
        }
    }

    @Override
    public void updateDurableSubscriptions(Map<String, String> subscriptions) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_DURABLE_SUBSCRIPTION SET SUBSCRIPTION_DATA=? WHERE SUBSCRIPTION_ID=?");
            for (Map.Entry<String, String> entry : subscriptions.entrySet()) {
                preparedStatement.setString(1, entry.getValue());
                preparedStatement.setString(2, entry.getKey());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "updating durable subscriptions");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while updating durable subscriptions.", e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "updating durable subscriptions");
            this.close(connection, "updating durable subscriptions");
        }
    }

    @Override
    public void removeDurableSubscription(AndesSubscription subscription) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String destinationIdentifier = this.getDestinationIdentifier(subscription);
        String subscriptionID = this.generateSubscriptionID(subscription);
        String task = "removing durable subscription. destination: " + destinationIdentifier + " sub id: " + subscriptionID;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_DURABLE_SUBSCRIPTION WHERE DESTINATION_IDENTIFIER=? AND SUBSCRIPTION_ID=?");
            preparedStatement.setString(1, destinationIdentifier);
            preparedStatement.setString(2, subscriptionID);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while " + task, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
    }

    @Override
    public void storeNodeDetails(String nodeID, String data) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "storing node informationnode id: " + nodeID;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_NODE ( NODE_ID,NODE_DATA) VALUES (?,?)");
            preparedStatement.setString(1, nodeID);
            preparedStatement.setString(2, data);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + task, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
    }

    @Override
    public Map<String, String> getAllStoredNodeData() throws AndesException {
        HashMap<String, String> hashMap;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        HashMap<String, String> nodeInfoMap = new HashMap<String, String>();
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT NODE_ID,NODE_DATA FROM MB_NODE");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                nodeInfoMap.put(resultSet.getString("NODE_ID"), resultSet.getString("NODE_DATA"));
            }
            connection.commit();
            hashMap = nodeInfoMap;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving all node information. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving all node information. ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving all node information. ");
                this.close(preparedStatement, "retrieving all node information. ");
                this.close(connection, "retrieving all node information. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving all node information. ");
        this.close(preparedStatement, "retrieving all node information. ");
        this.close(connection, "retrieving all node information. ");
        return hashMap;
    }

    @Override
    public void removeNodeData(String nodeID) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String task = "removing node information node id: " + nodeID;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_NODE WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeID);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, task);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + task, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
    }

    @Override
    public void addMessageCounterForQueue(String destinationQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            if (!this.isCounter4QueueExist(connection, destinationQueueName)) {
                preparedStatement = connection.prepareStatement("INSERT INTO MB_QUEUE_COUNTER (QUEUE_NAME,MESSAGE_COUNT ) VALUES ( ?,? )");
                preparedStatement.setString(1, destinationQueueName);
                preparedStatement.setLong(2, 0L);
                preparedStatement.executeUpdate();
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("counter for queue: " + destinationQueueName + " already exists."));
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "adding counter for queue");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while adding counter for queue", e);
            }
            catch (Throwable throwable) {
                contextWrite.stop();
                this.close(preparedStatement, "adding counter for queue");
                this.close(connection, "adding counter for queue");
                throw throwable;
            }
        }
        contextWrite.stop();
        this.close(preparedStatement, "adding counter for queue");
        this.close(connection, "adding counter for queue");
    }

    private boolean isCounter4QueueExist(Connection connection, String queueName) throws AndesException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_COUNT FROM MB_QUEUE_COUNTER WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, queueName);
            resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            this.close(resultSet, "checking queue counter exist");
            this.close(preparedStatement, "checking queue counter exist");
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "checking queue counter exist");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while adding counter for queue", e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "checking queue counter exist");
                this.close(preparedStatement, "checking queue counter exist");
                throw throwable;
            }
        }
    }

    @Override
    public long getMessageCountForQueue(String destinationQueueName) throws AndesException {
        long l;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_COUNT FROM MB_QUEUE_COUNTER WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, destinationQueueName);
            resultSet = preparedStatement.executeQuery();
            long count = 0L;
            if (resultSet.next()) {
                count = resultSet.getLong("MESSAGE_COUNT");
            }
            connection.commit();
            l = count;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving queue count");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving queue count", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving queue count");
                this.close(preparedStatement, "retrieving queue count");
                this.close(connection, "retrieving queue count");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving queue count");
        this.close(preparedStatement, "retrieving queue count");
        this.close(connection, "retrieving queue count");
        return l;
    }

    @Override
    public void resetMessageCounterForQueue(String storageQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_QUEUE_COUNTER SET MESSAGE_COUNT= 0 WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, storageQueueName);
            preparedStatement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "Resetting message counter for queue" + storageQueueName);
            throw this.rdbmsStoreUtils.convertSQLException("error occurred while resetting message count for queue :" + storageQueueName, e);
        }
        finally {
            contextWrite.stop();
            String task = "Resetting message counter for queue" + storageQueueName;
            this.close(preparedStatement, task);
            this.close(connection, task);
        }
    }

    @Override
    public void removeMessageCounterForQueue(String destinationQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_QUEUE_COUNTER WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, destinationQueueName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "deleting queue counter");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while deleting queue counter queue: " + destinationQueueName, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "deleting queue counter");
            this.close(connection, "deleting queue counter");
        }
    }

    @Override
    public void incrementMessageCountForQueue(String destinationQueueName, long incrementBy) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_QUEUE_COUNTER SET MESSAGE_COUNT=MESSAGE_COUNT+? WHERE QUEUE_NAME=?");
            preparedStatement.setLong(1, incrementBy);
            preparedStatement.setString(2, destinationQueueName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "incrementing queue count");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while incrementing queue count queue name: " + destinationQueueName, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "incrementing queue count");
            this.close(connection, "incrementing queue count");
        }
    }

    @Override
    public void decrementMessageCountForQueue(String destinationQueueName, long decrementBy) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_QUEUE_COUNTER SET MESSAGE_COUNT=MESSAGE_COUNT-? WHERE QUEUE_NAME=?");
            preparedStatement.setLong(1, decrementBy);
            preparedStatement.setString(2, destinationQueueName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            this.rollback(connection, "decrementing queue count");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while decrementing queue count queue name: " + destinationQueueName, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "decrementing queue count");
            this.close(connection, "decrementing queue count");
        }
    }

    @Override
    public void storeExchangeInformation(String exchangeName, String exchangeInfo) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            if (!this.isExchangeExist(connection, exchangeName)) {
                preparedStatement = connection.prepareStatement("INSERT INTO MB_EXCHANGE (EXCHANGE_NAME,EXCHANGE_DATA) VALUES (?,?)");
                preparedStatement.setString(1, exchangeName);
                preparedStatement.setString(2, exchangeInfo);
                preparedStatement.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "storing exchange information");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while storing exchange information exchange: " + exchangeName, e);
            }
            catch (Throwable throwable) {
                contextWrite.stop();
                this.close(preparedStatement, "storing exchange information");
                this.close(connection, "storing exchange information");
                throw throwable;
            }
        }
        contextWrite.stop();
        this.close(preparedStatement, "storing exchange information");
        this.close(connection, "storing exchange information");
    }

    private boolean isExchangeExist(Connection connection, String exchangeName) throws AndesException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT EXCHANGE_DATA FROM MB_EXCHANGE WHERE EXCHANGE_NAME=?");
            preparedStatement.setString(1, exchangeName);
            resultSet = preparedStatement.executeQuery();
            boolean bl = resultSet.next();
            this.close(resultSet, "checking whether an exchange exist. ");
            this.close(preparedStatement, "checking whether an exchange exist. ");
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "checking whether an exchange exist. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred retrieving exchange information for exchange: " + exchangeName, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "checking whether an exchange exist. ");
                this.close(preparedStatement, "checking whether an exchange exist. ");
                throw throwable;
            }
        }
    }

    @Override
    public List<AndesMessageRouter> getAllMessageRoutersStored() throws AndesException {
        ArrayList<AndesMessageRouter> arrayList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            ArrayList<AndesMessageRouter> messageRouters = new ArrayList<AndesMessageRouter>();
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT EXCHANGE_DATA FROM MB_EXCHANGE");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                MessageRouterFactory messageRouterFactory = new MessageRouterFactory();
                AndesMessageRouter messageRouter = messageRouterFactory.createMessageRouter(resultSet.getString("EXCHANGE_DATA"));
                messageRouters.add(messageRouter);
            }
            connection.commit();
            arrayList = messageRouters;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving all exchange information. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving all exchange information. ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving all exchange information. ");
                this.close(preparedStatement, "retrieving all exchange information. ");
                this.close(connection, "retrieving all exchange information. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving all exchange information. ");
        this.close(preparedStatement, "retrieving all exchange information. ");
        this.close(connection, "retrieving all exchange information. ");
        return arrayList;
    }

    @Override
    public void deleteExchangeInformation(String exchangeName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_EXCHANGE WHERE EXCHANGE_NAME=?");
            preparedStatement.setString(1, exchangeName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            String errMsg = "deleting an exchange  exchange: " + exchangeName;
            this.rollback(connection, errMsg);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "deleting an exchange ");
            this.close(connection, "deleting an exchange ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeQueueInformation(String queueName, String queueInfo) throws AndesException {
        block6: {
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
            try {
                connection = this.getConnection();
                preparedStatement = connection.prepareStatement("INSERT INTO MB_QUEUE (QUEUE_NAME,QUEUE_DATA) VALUES (?,?)");
                preparedStatement.setString(1, queueName);
                preparedStatement.setString(2, queueInfo);
                preparedStatement.executeUpdate();
                connection.commit();
            }
            catch (SQLException e) {
                AndesException andesException = this.rdbmsStoreUtils.convertSQLException("Error occurred while storing queue", e);
                String errMsg = "storing queue information  queue name:" + queueName;
                this.rollback(connection, errMsg);
                if (andesException instanceof AndesDataIntegrityViolationException) {
                    logger.warn((Object)("Queue already created. Skipping queue insert [" + queueName + "] to database "));
                    break block6;
                }
                logger.error((Object)("Error occurred while storing queue [" + queueName + "] to database "));
                throw new AndesException(andesException);
            }
            finally {
                contextWrite.stop();
                this.close(preparedStatement, "storing queue information ");
                this.close(connection, "storing queue information ");
            }
        }
    }

    @Override
    public List<StorageQueue> getAllQueuesStored() throws AndesException {
        ArrayList<StorageQueue> arrayList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT QUEUE_DATA FROM MB_QUEUE");
            resultSet = preparedStatement.executeQuery();
            ArrayList<StorageQueue> queueList = new ArrayList<StorageQueue>();
            while (resultSet.next()) {
                StorageQueue andesQueue = new StorageQueue(resultSet.getString("QUEUE_DATA"));
                queueList.add(andesQueue);
            }
            connection.commit();
            arrayList = queueList;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving all queue information. ");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving all queue information. ", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving all queue information. ");
                this.close(preparedStatement, "retrieving all queue information. ");
                this.close(connection, "retrieving all queue information. ");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving all queue information. ");
        this.close(preparedStatement, "retrieving all queue information. ");
        this.close(connection, "retrieving all queue information. ");
        return arrayList;
    }

    @Override
    public void deleteQueueInformation(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_QUEUE WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, queueName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            String errMsg = "deleting queue information. queue name: " + queueName;
            this.rollback(connection, errMsg);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "deleting queue information. ");
            this.close(connection, "deleting queue information. ");
        }
    }

    @Override
    public void storeBindingInformation(String exchange, String boundQueueName, String bindingInfo) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_BINDING ( EXCHANGE_NAME,QUEUE_NAME,BINDING_DETAILS ) VALUES (?,?,?)");
            preparedStatement.setString(1, exchange);
            preparedStatement.setString(2, boundQueueName);
            preparedStatement.setString(3, bindingInfo);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            String errMsg = "storing binding information.  exchange: " + exchange + " queue: " + boundQueueName + " routing key: " + bindingInfo;
            this.rollback(connection, errMsg);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "storing binding information. ");
            this.close(connection, "storing binding information. ");
        }
    }

    @Override
    public List<AndesBinding> getBindingsStoredForExchange(String exchangeName) throws AndesException {
        ArrayList<AndesBinding> arrayList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Timer.Context contextRead = MetricManager.timer((String)"org.wso2.mb.database.read", (Level)Level.INFO).start();
        try {
            ArrayList<AndesBinding> bindingList = new ArrayList<AndesBinding>();
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT BINDING_DETAILS FROM MB_BINDING WHERE EXCHANGE_NAME=?");
            preparedStatement.setString(1, exchangeName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String bindingInfo = resultSet.getString("BINDING_DETAILS");
                try {
                    AndesBinding andesBinding = new AndesBinding(bindingInfo);
                    bindingList.add(andesBinding);
                }
                catch (AndesException e) {
                    logger.error((Object)("Could not add binding: " + bindingInfo), (Throwable)e);
                }
            }
            connection.commit();
            arrayList = bindingList;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "retrieving binding information.");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while retrieving binding information.", e);
            }
            catch (Throwable throwable) {
                contextRead.stop();
                this.close(resultSet, "retrieving binding information.");
                this.close(preparedStatement, "retrieving binding information.");
                this.close(connection, "retrieving binding information.");
                throw throwable;
            }
        }
        contextRead.stop();
        this.close(resultSet, "retrieving binding information.");
        this.close(preparedStatement, "retrieving binding information.");
        this.close(connection, "retrieving binding information.");
        return arrayList;
    }

    @Override
    public void deleteBindingInformation(String exchangeName, String boundQueueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_BINDING WHERE EXCHANGE_NAME=? AND QUEUE_NAME=?");
            preparedStatement.setString(1, exchangeName);
            preparedStatement.setString(2, boundQueueName);
            preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            String errMsg = "deleting binding information.  exchange: " + exchangeName + " bound queue: " + boundQueueName;
            this.rollback(connection, errMsg);
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatement, "deleting binding information. ");
            this.close(connection, "deleting binding information. ");
        }
    }

    @Override
    public void close() {
    }

    protected Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    protected void close(Connection connection, String task) {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("Failed to close connection after " + task), (Throwable)e);
        }
    }

    protected void rollback(Connection connection, String task) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                logger.warn((Object)("Rollback failed on " + task), (Throwable)e);
            }
        }
    }

    protected void close(PreparedStatement preparedStatement, String task) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                logger.error((Object)("Closing prepared statement failed after " + task), (Throwable)e);
            }
        }
    }

    protected void close(ResultSet resultSet, String task) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                logger.error((Object)("Closing result set failed after " + task), (Throwable)e);
            }
        }
    }

    @Override
    public void createSlot(long startMessageId, long endMessageId, String storageQueueName, String assignedNodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_INSERT_SLOT);
            preparedStatement.setLong(1, startMessageId);
            preparedStatement.setLong(2, endMessageId);
            preparedStatement.setString(3, storageQueueName);
            preparedStatement.setString(4, assignedNodeId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "creating slot");
            this.close(connection, "creating slot");
        }
        catch (SQLException e) {
            try {
                String errMsg = "creating slot startMessageId: " + startMessageId + " endMessageId: " + endMessageId + " storageQueueName:" + storageQueueName + " assignedNodeId:" + assignedNodeId;
                this.rollback(connection, "creating slot");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "creating slot");
                this.close(connection, "creating slot");
                throw throwable;
            }
        }
    }

    @Override
    public boolean deleteNonOverlappingSlot(long startMessageId, long endMessageId) throws AndesException {
        Connection connection = null;
        PreparedStatement deleteNonOverlappingSlotPS = null;
        PreparedStatement getSlotPS = null;
        ResultSet resultSet = null;
        try {
            boolean slotDeleted;
            connection = this.getConnection();
            deleteNonOverlappingSlotPS = connection.prepareStatement(RDBMSConstants.PS_DELETE_NON_OVERLAPPING_SLOT);
            deleteNonOverlappingSlotPS.setLong(1, startMessageId);
            deleteNonOverlappingSlotPS.setLong(2, endMessageId);
            int rowsAffected = deleteNonOverlappingSlotPS.executeUpdate();
            connection.commit();
            if (rowsAffected == 0) {
                getSlotPS = connection.prepareStatement("SELECT SLOT_STATE,STORAGE_QUEUE_NAME FROM MB_SLOT WHERE START_MESSAGE_ID=? AND END_MESSAGE_ID=?");
                getSlotPS.setLong(1, startMessageId);
                getSlotPS.setLong(2, endMessageId);
                resultSet = getSlotPS.executeQuery();
                slotDeleted = !resultSet.next();
            } else {
                slotDeleted = true;
            }
            if (logger.isDebugEnabled()) {
                if (slotDeleted) {
                    logger.debug((Object)("Slot deleted, startMessageId " + startMessageId + " endMessageId" + endMessageId));
                } else {
                    logger.debug((Object)("Cannot delete slot, startMessageId " + startMessageId + " endMessageId" + endMessageId));
                }
            }
            connection.commit();
            boolean bl = slotDeleted;
            this.close(resultSet, "deleting slot");
            this.close(deleteNonOverlappingSlotPS, "deleting slot");
            this.close(getSlotPS, "deleting slot");
            this.close(connection, "deleting slot");
            return bl;
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting slot startMessageId: " + startMessageId + " endMessageId: " + endMessageId;
                this.rollback(connection, "deleting slot");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "deleting slot");
                this.close(deleteNonOverlappingSlotPS, "deleting slot");
                this.close(getSlotPS, "deleting slot");
                this.close(connection, "deleting slot");
                throw throwable;
            }
        }
    }

    @Override
    public boolean deleteSlot(long startMessageId, long endMessageId) throws AndesException {
        Connection connection = null;
        PreparedStatement deleteNonOverlappingSlotPS = null;
        PreparedStatement getSlotPS = null;
        ResultSet resultSet = null;
        try {
            boolean slotDeleted;
            connection = this.getConnection();
            deleteNonOverlappingSlotPS = connection.prepareStatement("DELETE FROM MB_SLOT WHERE START_MESSAGE_ID=? AND END_MESSAGE_ID=?");
            deleteNonOverlappingSlotPS.setLong(1, startMessageId);
            deleteNonOverlappingSlotPS.setLong(2, endMessageId);
            int rowsAffected = deleteNonOverlappingSlotPS.executeUpdate();
            connection.commit();
            if (rowsAffected == 0) {
                getSlotPS = connection.prepareStatement("SELECT SLOT_STATE,STORAGE_QUEUE_NAME FROM MB_SLOT WHERE START_MESSAGE_ID=? AND END_MESSAGE_ID=?");
                getSlotPS.setLong(1, startMessageId);
                getSlotPS.setLong(2, endMessageId);
                resultSet = getSlotPS.executeQuery();
                slotDeleted = !resultSet.next();
            } else {
                slotDeleted = true;
            }
            if (logger.isDebugEnabled()) {
                if (slotDeleted) {
                    logger.debug((Object)("Slot deleted, startMessageId " + startMessageId + " endMessageId" + endMessageId));
                } else {
                    logger.debug((Object)("Cannot delete slot, startMessageId " + startMessageId + " endMessageId" + endMessageId));
                }
            }
            connection.commit();
            boolean bl = slotDeleted;
            this.close(deleteNonOverlappingSlotPS, "deleting slot");
            this.close(getSlotPS, "deleting slot");
            this.close(connection, "deleting slot");
            return bl;
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting slot startMessageId: " + startMessageId + " endMessageId: " + endMessageId;
                this.rollback(connection, "deleting slot");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(deleteNonOverlappingSlotPS, "deleting slot");
                this.close(getSlotPS, "deleting slot");
                this.close(connection, "deleting slot");
                throw throwable;
            }
        }
    }

    @Override
    public void deleteSlotsByQueueName(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_SLOT WHERE STORAGE_QUEUE_NAME=?");
            preparedStatement.setString(1, queueName);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "deleting slot by queue name");
            this.close(connection, "deleting slot by queue name");
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting slot by queue name queueName: " + queueName;
                this.rollback(connection, "deleting slot by queue name");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "deleting slot by queue name");
                this.close(connection, "deleting slot by queue name");
                throw throwable;
            }
        }
    }

    @Override
    public void deleteMessageIdsByQueueName(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_SLOT_MESSAGE_ID WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, queueName);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "deleting message id by queue name");
            this.close(connection, "deleting message id by queue name");
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting message id by queue name queueName: " + queueName;
                this.rollback(connection, "deleting message id by queue name");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "deleting message id by queue name");
                this.close(connection, "deleting message id by queue name");
                throw throwable;
            }
        }
    }

    @Override
    public void createSlotAssignment(String nodeId, String queueName, long startMsgId, long endMsgId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_INSERT_SLOT_ASSIGNMENT);
            preparedStatement.setString(1, nodeId);
            preparedStatement.setString(2, queueName);
            preparedStatement.setLong(3, startMsgId);
            preparedStatement.setLong(4, endMsgId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "creating slot assignment");
            this.close(connection, "creating slot assignment");
        }
        catch (SQLException e) {
            try {
                String errMsg = "creating slot assignment nodeId: " + nodeId + " queueName: " + queueName + "startMsgId: " + startMsgId + "endMsgId: " + endMsgId;
                this.rollback(connection, "creating slot assignment");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "creating slot assignment");
                this.close(connection, "creating slot assignment");
                throw throwable;
            }
        }
    }

    @Override
    public void deleteSlotAssignment(long startMessageId, long endMessageId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT);
            preparedStatement.setLong(1, startMessageId);
            preparedStatement.setLong(2, endMessageId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "deleting slot assignment");
            this.close(connection, "deleting slot assignment");
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting slot assignment startMessageId: " + startMessageId + " endMessageId: " + endMessageId;
                this.rollback(connection, "deleting slot assignment");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "deleting slot assignment");
                this.close(connection, "deleting slot assignment");
                throw throwable;
            }
        }
    }

    @Override
    public void deleteSlotAssignmentByQueueName(String nodeId, String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME);
            preparedStatement.setString(1, nodeId);
            preparedStatement.setString(2, queueName);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME);
            this.close(connection, RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME);
        }
        catch (SQLException e) {
            try {
                String errMsg = RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME + " nodeId: " + nodeId + " queueName: " + queueName;
                this.rollback(connection, RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME);
                this.close(connection, RDBMSConstants.PS_DELETE_SLOT_ASSIGNMENT_BY_QUEUE_NAME);
                throw throwable;
            }
        }
    }

    @Override
    public Slot selectUnAssignedSlot(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Slot unAssignedSlot = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_SELECT_UNASSIGNED_SLOT);
            preparedStatement.setString(1, queueName);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                unAssignedSlot = new Slot(SlotState.RETURNED);
                unAssignedSlot.setStartMessageId(resultSet.getLong("START_MESSAGE_ID"));
                unAssignedSlot.setEndMessageId(resultSet.getLong("END_MESSAGE_ID"));
                unAssignedSlot.setStorageQueueName(resultSet.getString("STORAGE_QUEUE_NAME"));
            }
            connection.commit();
            Slot slot = unAssignedSlot;
            this.close(resultSet, "selecting unassigned slots");
            this.close(preparedStatement, "selecting unassigned slots");
            this.close(connection, "selecting unassigned slots");
            return slot;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "selecting unassigned slots");
                String errMsg = "selecting unassigned slots queueName: " + queueName;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "selecting unassigned slots");
                this.close(preparedStatement, "selecting unassigned slots");
                this.close(connection, "selecting unassigned slots");
                throw throwable;
            }
        }
    }

    @Override
    public long getQueueToLastAssignedId(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long messageId = 0L;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_QUEUE_TO_LAST_ASSIGNED_ID WHERE QUEUE_NAME=?");
            preparedStatement.setString(1, queueName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                messageId = resultSet.getLong("MESSAGE_ID");
            }
            connection.commit();
            long l = messageId;
            this.close(resultSet, "getting queue to last assigned id");
            this.close(preparedStatement, "getting queue to last assigned id");
            this.close(connection, "getting queue to last assigned id");
            return l;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting queue to last assigned id");
                String errMsg = "getting queue to last assigned id queueName: " + queueName;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting queue to last assigned id");
                this.close(preparedStatement, "getting queue to last assigned id");
                this.close(connection, "getting queue to last assigned id");
                throw throwable;
            }
        }
    }

    @Override
    public void setQueueToLastAssignedId(String queueName, long messageId) throws AndesException {
        Connection connection = null;
        PreparedStatement selectQueueToLastAssignIDPS = null;
        PreparedStatement updateQueueToLastAssignedIDPS = null;
        PreparedStatement insertQueueToLastAssignedIDPS = null;
        try {
            connection = this.getConnection();
            selectQueueToLastAssignIDPS = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_QUEUE_TO_LAST_ASSIGNED_ID WHERE QUEUE_NAME=?");
            selectQueueToLastAssignIDPS.setString(1, queueName);
            ResultSet resultSet = selectQueueToLastAssignIDPS.executeQuery();
            if (resultSet.next()) {
                updateQueueToLastAssignedIDPS = connection.prepareStatement("UPDATE MB_QUEUE_TO_LAST_ASSIGNED_ID SET MESSAGE_ID=? WHERE QUEUE_NAME=?");
                updateQueueToLastAssignedIDPS.setLong(1, messageId);
                updateQueueToLastAssignedIDPS.setString(2, queueName);
                updateQueueToLastAssignedIDPS.executeUpdate();
            } else {
                insertQueueToLastAssignedIDPS = connection.prepareStatement("INSERT INTO MB_QUEUE_TO_LAST_ASSIGNED_ID(QUEUE_NAME,MESSAGE_ID) VALUES (?,?)");
                insertQueueToLastAssignedIDPS.setString(1, queueName);
                insertQueueToLastAssignedIDPS.setLong(2, messageId);
                insertQueueToLastAssignedIDPS.executeUpdate();
            }
            connection.commit();
            this.close(selectQueueToLastAssignIDPS, "setting queue to last assigned id");
            this.close(updateQueueToLastAssignedIDPS, "setting queue to last assigned id");
            this.close(insertQueueToLastAssignedIDPS, "setting queue to last assigned id");
            this.close(connection, "setting queue to last assigned id");
        }
        catch (SQLException e) {
            try {
                String errMsg = "setting queue to last assigned id queueName: " + queueName + " messageId: " + messageId;
                this.rollback(connection, "setting queue to last assigned id");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(selectQueueToLastAssignIDPS, "setting queue to last assigned id");
                this.close(updateQueueToLastAssignedIDPS, "setting queue to last assigned id");
                this.close(insertQueueToLastAssignedIDPS, "setting queue to last assigned id");
                this.close(connection, "setting queue to last assigned id");
                throw throwable;
            }
        }
    }

    @Override
    public long getLocalSafeZoneOfNode(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        long messageId = 0L;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_NODE_TO_LAST_PUBLISHED_ID WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeId);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                messageId = resultSet.getLong("MESSAGE_ID");
            }
            connection.commit();
            long l = messageId;
            this.close(resultSet, "getting node to last published id");
            this.close(preparedStatement, "getting node to last published id");
            this.close(connection, "getting node to last published id");
            return l;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting node to last published id");
                String errMsg = "getting node to last published id nodeId: " + nodeId;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting node to last published id");
                this.close(preparedStatement, "getting node to last published id");
                this.close(connection, "getting node to last published id");
                throw throwable;
            }
        }
    }

    @Override
    public void setLocalSafeZoneOfNode(String nodeId, long messageId) throws AndesException {
        Connection connection = null;
        PreparedStatement selectNodeToLastPublishedIdPS = null;
        PreparedStatement updateNodeToLastPublishedIdPS = null;
        PreparedStatement insertNodeToLastPublishedIdPS = null;
        try {
            connection = this.getConnection();
            selectNodeToLastPublishedIdPS = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_NODE_TO_LAST_PUBLISHED_ID WHERE NODE_ID=?");
            selectNodeToLastPublishedIdPS.setString(1, nodeId);
            ResultSet resultSet = selectNodeToLastPublishedIdPS.executeQuery();
            if (resultSet.next()) {
                updateNodeToLastPublishedIdPS = connection.prepareStatement("UPDATE MB_NODE_TO_LAST_PUBLISHED_ID SET MESSAGE_ID=? WHERE NODE_ID=?");
                updateNodeToLastPublishedIdPS.setLong(1, messageId);
                updateNodeToLastPublishedIdPS.setString(2, nodeId);
                updateNodeToLastPublishedIdPS.executeUpdate();
            } else {
                insertNodeToLastPublishedIdPS = connection.prepareStatement("INSERT INTO MB_NODE_TO_LAST_PUBLISHED_ID(NODE_ID,MESSAGE_ID) VALUES (?,?)");
                insertNodeToLastPublishedIdPS.setString(1, nodeId);
                insertNodeToLastPublishedIdPS.setLong(2, messageId);
                insertNodeToLastPublishedIdPS.executeUpdate();
            }
            connection.commit();
            this.close(selectNodeToLastPublishedIdPS, "setting node to last published id");
            this.close(updateNodeToLastPublishedIdPS, "setting node to last published id");
            this.close(insertNodeToLastPublishedIdPS, "setting node to last published id");
            this.close(connection, "setting node to last published id");
        }
        catch (SQLException e) {
            try {
                String errMsg = "setting node to last published id nodeId: " + nodeId + " messageId: " + messageId;
                this.rollback(connection, "setting node to last published id");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(selectNodeToLastPublishedIdPS, "setting node to last published id");
                this.close(updateNodeToLastPublishedIdPS, "setting node to last published id");
                this.close(insertNodeToLastPublishedIdPS, "setting node to last published id");
                this.close(connection, "setting node to last published id");
                throw throwable;
            }
        }
    }

    @Override
    public void removePublisherNodeId(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_NODE_TO_LAST_PUBLISHED_ID WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "deleting message ids");
            this.close(connection, "deleting message ids");
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting publisher id node ID: " + nodeId;
                this.rollback(connection, "deleting message ids");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "deleting message ids");
                this.close(connection, "deleting message ids");
                throw throwable;
            }
        }
    }

    @Override
    public TreeSet<String> getMessagePublishedNodes() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<String> nodeList = new TreeSet<String>();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT NODE_ID FROM MB_NODE_TO_LAST_PUBLISHED_ID");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                nodeList.add(resultSet.getString("NODE_ID"));
            }
            connection.commit();
            TreeSet<String> treeSet = nodeList;
            this.close(resultSet, "getting message published nodes");
            this.close(preparedStatement, "getting message published nodes");
            this.close(connection, "getting message published nodes");
            return treeSet;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting message published nodes");
                String errMsg = "getting message published nodes";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting message published nodes");
                this.close(preparedStatement, "getting message published nodes");
                this.close(connection, "getting message published nodes");
                throw throwable;
            }
        }
    }

    @Override
    public void setSlotState(long startMessageId, long endMessageId, SlotState slotState) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_SLOT SET SLOT_STATE = ? WHERE START_MESSAGE_ID = ? AND END_MESSAGE_ID = ?");
            preparedStatement.setInt(1, slotState.getCode());
            preparedStatement.setLong(2, startMessageId);
            preparedStatement.setLong(3, endMessageId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "setting slot state");
            this.close(connection, "setting slot state");
        }
        catch (SQLException e) {
            try {
                String errMsg = "setting slot state startMessageId: " + startMessageId + " endMessageId: " + endMessageId + " slotState:" + (Object)((Object)slotState);
                this.rollback(connection, "setting slot state");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "setting slot state");
                this.close(connection, "setting slot state");
                throw throwable;
            }
        }
    }

    @Override
    public Slot getOverlappedSlot(String nodeId, String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Slot overlappedSlot = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_SELECT_OVERLAPPED_SLOT);
            preparedStatement.setString(1, queueName);
            preparedStatement.setString(2, nodeId);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                overlappedSlot = new Slot(SlotState.OVERLAPPED);
                overlappedSlot.setStartMessageId(resultSet.getLong("START_MESSAGE_ID"));
                overlappedSlot.setEndMessageId(resultSet.getLong("END_MESSAGE_ID"));
                overlappedSlot.setStorageQueueName(resultSet.getString("STORAGE_QUEUE_NAME"));
                overlappedSlot.setAnOverlappingSlot(true);
            }
            connection.commit();
            Slot slot = overlappedSlot;
            this.close(resultSet, "getting overlapped slot");
            this.close(preparedStatement, "getting overlapped slot");
            this.close(connection, "getting overlapped slot");
            return slot;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting overlapped slot");
                String errMsg = "getting overlapped slot queueName: " + queueName;
                logger.error((Object)("Error occurred while " + errMsg), (Throwable)e);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting overlapped slot");
                this.close(preparedStatement, "getting overlapped slot");
                this.close(connection, "getting overlapped slot");
                throw throwable;
            }
        }
    }

    @Override
    public void addMessageId(String queueName, long messageId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_SLOT_MESSAGE_ID(QUEUE_NAME,MESSAGE_ID) VALUES (?,?)");
            preparedStatement.setString(1, queueName);
            preparedStatement.setLong(2, messageId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "adding message id");
            this.close(connection, "adding message id");
        }
        catch (SQLException e) {
            try {
                String errMsg = "adding message id queueName: " + queueName + " messageId: " + messageId;
                this.rollback(connection, "adding message id");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "adding message id");
                this.close(connection, "adding message id");
                throw throwable;
            }
        }
    }

    @Override
    public TreeSet<Long> getMessageIds(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<Long> messageIdSet = new TreeSet<Long>();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT MESSAGE_ID FROM MB_SLOT_MESSAGE_ID WHERE QUEUE_NAME=? ORDER BY MESSAGE_ID");
            preparedStatement.setString(1, queueName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                messageIdSet.add(resultSet.getLong("MESSAGE_ID"));
            }
            connection.commit();
            TreeSet<Long> treeSet = messageIdSet;
            this.close(resultSet, "getting message ids");
            this.close(preparedStatement, "getting message ids");
            this.close(connection, "getting message ids");
            return treeSet;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting message ids");
                String errMsg = "getting message ids queueName: " + queueName;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting message ids");
                this.close(preparedStatement, "getting message ids");
                this.close(connection, "getting message ids");
                throw throwable;
            }
        }
    }

    @Override
    public void deleteMessageId(long messageId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_SLOT_MESSAGE_ID WHERE MESSAGE_ID=?");
            preparedStatement.setLong(1, messageId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "deleting message ids");
            this.close(connection, "deleting message ids");
        }
        catch (SQLException e) {
            try {
                String errMsg = "deleting message ids messageId: " + messageId;
                this.rollback(connection, "deleting message ids");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "deleting message ids");
                this.close(connection, "deleting message ids");
                throw throwable;
            }
        }
    }

    @Override
    public TreeSet<Slot> getAssignedSlotsByNodeId(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<Serializable> assignedSlotSet = new TreeSet<Serializable>();
        try {
            Serializable assignedSlot;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_GET_ASSIGNED_SLOTS_BY_NODE_ID);
            preparedStatement.setString(1, nodeId);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                assignedSlot = new Slot(SlotState.ASSIGNED);
                ((Slot)assignedSlot).setStartMessageId(resultSet.getLong("START_MESSAGE_ID"));
                ((Slot)assignedSlot).setEndMessageId(resultSet.getLong("END_MESSAGE_ID"));
                ((Slot)assignedSlot).setStorageQueueName(resultSet.getString("STORAGE_QUEUE_NAME"));
                assignedSlotSet.add(assignedSlot);
            }
            connection.commit();
            assignedSlot = assignedSlotSet;
            this.close(resultSet, "getting assigned slots by node id");
            this.close(preparedStatement, "getting assigned slots by node id");
            this.close(connection, "getting assigned slots by node id");
            return assignedSlot;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting assigned slots by node id");
                String errMsg = "getting assigned slots by node id nodeId: " + nodeId;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting assigned slots by node id");
                this.close(preparedStatement, "getting assigned slots by node id");
                this.close(connection, "getting assigned slots by node id");
                throw throwable;
            }
        }
    }

    @Override
    public TreeSet<Slot> getOverlappedSlotsByNodeId(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<Serializable> overlappedSlots = new TreeSet<Serializable>();
        try {
            Serializable overlappedSlot;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(RDBMSConstants.PS_GET_OVERLAPPED_SLOTS_BY_NODE_ID);
            preparedStatement.setString(1, nodeId);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                overlappedSlot = new Slot(SlotState.ASSIGNED);
                ((Slot)overlappedSlot).setStartMessageId(resultSet.getLong("START_MESSAGE_ID"));
                ((Slot)overlappedSlot).setEndMessageId(resultSet.getLong("END_MESSAGE_ID"));
                ((Slot)overlappedSlot).setStorageQueueName(resultSet.getString("STORAGE_QUEUE_NAME"));
                ((Slot)overlappedSlot).setAnOverlappingSlot(true);
                overlappedSlots.add(overlappedSlot);
            }
            connection.commit();
            overlappedSlot = overlappedSlots;
            this.close(resultSet, "getting assigned slots by node id");
            this.close(preparedStatement, "getting assigned slots by node id");
            this.close(connection, "getting assigned slots by node id");
            return overlappedSlot;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting assigned slots by node id");
                String errMsg = "getting assigned slots by node id nodeId: " + nodeId;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting assigned slots by node id");
                this.close(preparedStatement, "getting assigned slots by node id");
                this.close(connection, "getting assigned slots by node id");
                throw throwable;
            }
        }
    }

    @Override
    public TreeSet<Slot> getAllSlotsByQueueName(String queueName) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<Serializable> slotSet = new TreeSet<Serializable>();
        try {
            Serializable slot;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT START_MESSAGE_ID,END_MESSAGE_ID,STORAGE_QUEUE_NAME,SLOT_STATE FROM MB_SLOT WHERE STORAGE_QUEUE_NAME =? ORDER BY SLOT_ID");
            preparedStatement.setString(1, queueName);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                slot = new Slot(SlotState.getById(resultSet.getInt("SLOT_STATE")));
                ((Slot)slot).setStartMessageId(resultSet.getLong("START_MESSAGE_ID"));
                ((Slot)slot).setEndMessageId(resultSet.getLong("END_MESSAGE_ID"));
                ((Slot)slot).setStorageQueueName(resultSet.getString("STORAGE_QUEUE_NAME"));
                ((Slot)slot).setSlotInactive();
                slotSet.add(slot);
            }
            connection.commit();
            slot = slotSet;
            this.close(resultSet, "getting all slots by queue name");
            this.close(preparedStatement, "getting all slots by queue name");
            this.close(connection, "getting all slots by queue name");
            return slot;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting all slots by queue name");
                String errMsg = "getting all slots by queue name queueName: " + queueName;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting all slots by queue name");
                this.close(preparedStatement, "getting all slots by queue name");
                this.close(connection, "getting all slots by queue name");
                throw throwable;
            }
        }
    }

    @Override
    public Set<String> getAllQueues() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<String> queueList = new TreeSet<String>();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT DISTINCT STORAGE_QUEUE_NAME FROM MB_SLOT");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                queueList.add(resultSet.getString("STORAGE_QUEUE_NAME"));
            }
            connection.commit();
            TreeSet<String> treeSet = queueList;
            this.close(resultSet, "getting all queues");
            this.close(preparedStatement, "getting all queues");
            this.close(connection, "getting all queues");
            return treeSet;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting all queues");
                String errMsg = "getting all queues";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting all queues");
                this.close(preparedStatement, "getting all queues");
                this.close(connection, "getting all queues");
                throw throwable;
            }
        }
    }

    @Override
    public Set<String> getAllQueuesInSubmittedSlots() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        TreeSet<String> queueList = new TreeSet<String>();
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT DISTINCT QUEUE_NAME FROM MB_SLOT_MESSAGE_ID");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                queueList.add(resultSet.getString("QUEUE_NAME"));
            }
            connection.commit();
            TreeSet<String> treeSet = queueList;
            this.close(resultSet, "getting all queues in submitted slots");
            this.close(preparedStatement, "getting all queues in submitted slots");
            this.close(connection, "getting all queues in submitted slots");
            return treeSet;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting all queues in submitted slots");
                String errMsg = "getting all queues in submitted slots";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting all queues in submitted slots");
                this.close(preparedStatement, "getting all queues in submitted slots");
                this.close(connection, "getting all queues in submitted slots");
                throw throwable;
            }
        }
    }

    @Override
    public void clearSlotStorage() throws AndesException {
        Connection connection = null;
        PreparedStatement clearSlotTablePS = null;
        PreparedStatement clearSlotMessageIdTablePS = null;
        PreparedStatement clearNodeToLastPublisherIdPS = null;
        PreparedStatement clearQueueToLastAssignedIdPS = null;
        try {
            connection = this.getConnection();
            clearSlotTablePS = connection.prepareStatement("DELETE FROM MB_SLOT");
            clearSlotTablePS.executeUpdate();
            clearSlotMessageIdTablePS = connection.prepareStatement("DELETE FROM MB_SLOT_MESSAGE_ID");
            clearSlotMessageIdTablePS.executeUpdate();
            clearNodeToLastPublisherIdPS = connection.prepareStatement("DELETE FROM MB_NODE_TO_LAST_PUBLISHED_ID");
            clearNodeToLastPublisherIdPS.executeUpdate();
            clearQueueToLastAssignedIdPS = connection.prepareStatement("DELETE FROM MB_QUEUE_TO_LAST_ASSIGNED_ID");
            clearQueueToLastAssignedIdPS.executeUpdate();
            connection.commit();
            this.close(clearSlotTablePS, "clearing slot tables");
            this.close(clearSlotMessageIdTablePS, "clearing slot tables");
            this.close(clearNodeToLastPublisherIdPS, "clearing slot tables");
            this.close(clearQueueToLastAssignedIdPS, "clearing slot tables");
            this.close(connection, "clearing slot tables");
        }
        catch (SQLException e) {
            try {
                String errMsg = "clearing slot tables";
                this.rollback(connection, "clearing slot tables");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(clearSlotTablePS, "clearing slot tables");
                this.close(clearSlotMessageIdTablePS, "clearing slot tables");
                this.close(clearNodeToLastPublisherIdPS, "clearing slot tables");
                this.close(clearQueueToLastAssignedIdPS, "clearing slot tables");
                this.close(connection, "clearing slot tables");
                throw throwable;
            }
        }
    }

    @Override
    public boolean createCoordinatorEntry(String nodeId, InetSocketAddress thriftAddress) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_COORDINATOR_HEARTBEAT(ANCHOR,NODE_ID,LAST_HEARTBEAT,THRIFT_HOST,THRIFT_PORT) VALUES (?,?,?,?,?)");
            preparedStatement.setInt(1, 1);
            preparedStatement.setString(2, nodeId);
            preparedStatement.setLong(3, System.currentTimeMillis());
            preparedStatement.setString(4, thriftAddress.getAddress().getHostAddress());
            preparedStatement.setInt(5, thriftAddress.getPort());
            int updateCount = preparedStatement.executeUpdate();
            connection.commit();
            boolean bl = updateCount != 0;
            this.close(preparedStatement, "adding message id");
            this.close(connection, "adding message id");
            return bl;
        }
        catch (SQLException e) {
            AndesException andesException;
            block5: {
                try {
                    String errMsg = "adding coordinator row instance ID: " + nodeId;
                    this.rollback(connection, "adding message id");
                    andesException = this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
                    if (!(andesException instanceof AndesDataIntegrityViolationException)) break block5;
                    boolean bl = false;
                    this.close(preparedStatement, "adding message id");
                    this.close(connection, "adding message id");
                    return bl;
                }
                catch (Throwable throwable) {
                    this.close(preparedStatement, "adding message id");
                    this.close(connection, "adding message id");
                    throw throwable;
                }
            }
            throw andesException;
        }
    }

    @Override
    public boolean checkIsCoordinator(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT LAST_HEARTBEAT FROM MB_COORDINATOR_HEARTBEAT WHERE NODE_ID=? AND ANCHOR=1");
            preparedStatement.setString(1, nodeId);
            resultSet = preparedStatement.executeQuery();
            boolean isCoordinator = resultSet.next();
            connection.commit();
            boolean bl = isCoordinator;
            this.close(resultSet, "checking coordinator validity");
            this.close(preparedStatement, "checking coordinator validity");
            this.close(connection, "checking coordinator validity");
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "checking coordinator validity");
                String errMsg = "checking coordinator validity instance id: " + nodeId;
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "checking coordinator validity");
                this.close(preparedStatement, "checking coordinator validity");
                this.close(connection, "checking coordinator validity");
                throw throwable;
            }
        }
    }

    @Override
    public boolean updateCoordinatorHeartbeat(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatementForCoordinatorUpdate = null;
        Timer.Context contextWrite = MetricManager.timer((String)"org.wso2.mb.database.write", (Level)Level.INFO).start();
        try {
            connection = this.getConnection();
            preparedStatementForCoordinatorUpdate = connection.prepareStatement("UPDATE MB_COORDINATOR_HEARTBEAT SET LAST_HEARTBEAT =?  WHERE NODE_ID=? AND ANCHOR=1");
            preparedStatementForCoordinatorUpdate.setLong(1, System.currentTimeMillis());
            preparedStatementForCoordinatorUpdate.setString(2, nodeId);
            int updateCount = preparedStatementForCoordinatorUpdate.executeUpdate();
            connection.commit();
            boolean bl = updateCount != 0;
            return bl;
        }
        catch (SQLException e) {
            this.rollback(connection, "updating coordinator heartbeat");
            throw this.rdbmsStoreUtils.convertSQLException("Error occurred while updating coordinator heartbeat. instance ID: " + nodeId, e);
        }
        finally {
            contextWrite.stop();
            this.close(preparedStatementForCoordinatorUpdate, "updating coordinator heartbeat");
            this.close(connection, "updating coordinator heartbeat");
        }
    }

    @Override
    public boolean checkIfCoordinatorValid(int age) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            boolean isCoordinator;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT LAST_HEARTBEAT FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            resultSet = preparedStatement.executeQuery();
            long currentTimeMillis = System.currentTimeMillis();
            if (resultSet.next()) {
                long coordinatorHeartbeat = resultSet.getLong(1);
                long heartbeatAge = currentTimeMillis - coordinatorHeartbeat;
                boolean bl = isCoordinator = heartbeatAge <= (long)age;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("isCoordinator: " + isCoordinator + ", heartbeatAge: " + age + ", coordinatorHeartBeat: " + coordinatorHeartbeat + ", currentTime: " + currentTimeMillis));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No coordinator present in database");
                }
                isCoordinator = false;
            }
            connection.commit();
            boolean bl = isCoordinator;
            this.close(resultSet, "reading coordinator information");
            this.close(preparedStatement, "reading coordinator information");
            this.close(connection, "reading coordinator information");
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "reading coordinator information");
                String errMsg = "reading coordinator information";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "reading coordinator information");
                this.close(preparedStatement, "reading coordinator information");
                this.close(connection, "reading coordinator information");
                throw throwable;
            }
        }
    }

    @Override
    public String getCoordinatorNodeId() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String coordinatorNodeId;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT NODE_ID FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                coordinatorNodeId = resultSet.getString(1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Coordinator node ID: " + coordinatorNodeId));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No coordinator present in database");
                }
                coordinatorNodeId = null;
            }
            connection.commit();
            String string = coordinatorNodeId;
            this.close(resultSet, "reading coordinator information");
            this.close(preparedStatement, "reading coordinator information");
            this.close(connection, "reading coordinator information");
            return string;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "reading coordinator information");
                String errMsg = "reading coordinator information";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "reading coordinator information");
                this.close(preparedStatement, "reading coordinator information");
                this.close(connection, "reading coordinator information");
                throw throwable;
            }
        }
    }

    @Override
    public InetSocketAddress getCoordinatorThriftAddress() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            InetSocketAddress thriftAddress;
            String thriftHost;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT THRIFT_HOST,THRIFT_PORT FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                thriftHost = resultSet.getString(1);
                int thriftPort = resultSet.getInt(2);
                thriftAddress = new InetSocketAddress(thriftHost, thriftPort);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No coordinator present in database");
                }
                thriftAddress = null;
            }
            connection.commit();
            thriftHost = thriftAddress;
            this.close(resultSet, "reading coordinator information");
            this.close(preparedStatement, "reading coordinator information");
            this.close(connection, "reading coordinator information");
            return thriftHost;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "reading coordinator information");
                String errMsg = "reading coordinator information";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "reading coordinator information");
                this.close(preparedStatement, "reading coordinator information");
                this.close(connection, "reading coordinator information");
                throw throwable;
            }
        }
    }

    @Override
    public void removeCoordinator() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_COORDINATOR_HEARTBEAT WHERE ANCHOR=1");
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "removing coordinator heartbeat");
            this.close(connection, "removing coordinator heartbeat");
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "removing coordinator heartbeat");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while removing coordinator heartbeat", e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "removing coordinator heartbeat");
                this.close(connection, "removing coordinator heartbeat");
                throw throwable;
            }
        }
    }

    @Override
    public boolean updateNodeHeartbeat(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatementForNodeUpdate = null;
        try {
            connection = this.getConnection();
            preparedStatementForNodeUpdate = connection.prepareStatement("UPDATE MB_NODE_HEARTBEAT SET LAST_HEARTBEAT =?  WHERE NODE_ID=?");
            preparedStatementForNodeUpdate.setLong(1, System.currentTimeMillis());
            preparedStatementForNodeUpdate.setString(2, nodeId);
            int updateCount = preparedStatementForNodeUpdate.executeUpdate();
            connection.commit();
            boolean bl = updateCount != 0;
            this.close(preparedStatementForNodeUpdate, "updating node heartbeat");
            this.close(connection, "updating node heartbeat");
            return bl;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "updating node heartbeat");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while updating node heartbeat. Node ID: " + nodeId, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatementForNodeUpdate, "updating node heartbeat");
                this.close(connection, "updating node heartbeat");
                throw throwable;
            }
        }
    }

    @Override
    public void createNodeHeartbeatEntry(String nodeId, InetSocketAddress nodeAddress) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO MB_NODE_HEARTBEAT(NODE_ID,LAST_HEARTBEAT,CLUSTER_AGENT_HOST,CLUSTER_AGENT_PORT,IS_NEW_NODE) VALUES (?,?,?,?,1)");
            preparedStatement.setString(1, nodeId);
            preparedStatement.setLong(2, System.currentTimeMillis());
            preparedStatement.setString(3, nodeAddress.getHostString());
            preparedStatement.setInt(4, nodeAddress.getPort());
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "updating coordinator heartbeat");
            this.close(connection, "creating node heartbeat");
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "creating node heartbeat");
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while creating node heartbeat. Node ID: " + nodeId, e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "updating coordinator heartbeat");
                this.close(connection, "creating node heartbeat");
                throw throwable;
            }
        }
    }

    @Override
    public List<NodeHeartBeatData> getAllHeartBeatData() throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object nodeId;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT NODE_ID,LAST_HEARTBEAT,IS_NEW_NODE,CLUSTER_AGENT_HOST,CLUSTER_AGENT_PORT FROM MB_NODE_HEARTBEAT");
            resultSet = preparedStatement.executeQuery();
            ArrayList<NodeHeartBeatData> nodeDataList = new ArrayList<NodeHeartBeatData>();
            while (resultSet.next()) {
                nodeId = resultSet.getString(1);
                long lastHeartbeat = resultSet.getLong(2);
                boolean isNewNode = this.convertIntToBoolean(resultSet.getInt(3));
                String clusterAgentHost = resultSet.getString(4);
                int clusterAgentPort = resultSet.getInt(5);
                InetSocketAddress clusterAgentAddress = new InetSocketAddress(clusterAgentHost, clusterAgentPort);
                NodeHeartBeatData heartBeatData = new NodeHeartBeatData((String)nodeId, lastHeartbeat, isNewNode, clusterAgentAddress);
                nodeDataList.add(heartBeatData);
            }
            connection.commit();
            nodeId = nodeDataList;
            this.close(resultSet, "getting all node heartbeat data");
            this.close(preparedStatement, "getting all node heartbeat data");
            this.close(connection, "getting all node heartbeat data");
            return nodeId;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "getting all node heartbeat data");
                String errMsg = "getting all node heartbeat data";
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + errMsg, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, "getting all node heartbeat data");
                this.close(preparedStatement, "getting all node heartbeat data");
                this.close(connection, "getting all node heartbeat data");
                throw throwable;
            }
        }
    }

    @Override
    public void removeNodeHeartbeat(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM MB_NODE_HEARTBEAT WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeId);
            preparedStatement.executeUpdate();
            connection.commit();
            this.close(preparedStatement, "removing node heartbeat entry");
            this.close(connection, "removing node heartbeat entry");
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "removing node heartbeat entry");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while removing node heartbeat entry", e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "removing node heartbeat entry");
                this.close(connection, "removing node heartbeat entry");
                throw throwable;
            }
        }
    }

    @Override
    public void markNodeAsNotNew(String nodeId) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE MB_NODE_HEARTBEAT SET IS_NEW_NODE =0  WHERE NODE_ID=?");
            preparedStatement.setString(1, nodeId);
            int updateCount = preparedStatement.executeUpdate();
            if (updateCount == 0) {
                logger.warn((Object)"No record was updated while marking node as not new");
            }
            connection.commit();
            this.close(preparedStatement, "marking node as not new");
            this.close(connection, "marking node as not new");
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, "marking node as not new");
                throw this.rdbmsStoreUtils.convertSQLException("error occurred while marking node as not new", e);
            }
            catch (Throwable throwable) {
                this.close(preparedStatement, "marking node as not new");
                this.close(connection, "marking node as not new");
                throw throwable;
            }
        }
    }

    private boolean convertIntToBoolean(int value) {
        return value != 0;
    }

    @Override
    public boolean isOperational(String testString, long testTime) {
        try {
            return this.rdbmsStoreUtils.testInsert(this.getConnection(), testString, testTime) && this.rdbmsStoreUtils.testRead(this.getConnection(), testString, testTime) && this.rdbmsStoreUtils.testDelete(this.getConnection(), testString, testTime);
        }
        catch (SQLException e) {
            return false;
        }
    }

    private String getDestinationIdentifier(AndesSubscription subscription) {
        return subscription.getStorageQueue().getMessageRouterBindingKey();
    }

    private String generateSubscriptionID(AndesSubscription subscription) {
        return subscription.getSubscriberConnection().getConnectedNode() + "_" + subscription.getStorageQueue().getMessageRouterBindingKey() + "_" + subscription.getSubscriptionId();
    }

    @Override
    public void storeMembershipEvent(List<String> clusterNodes, int membershipEventType, String changedMember) throws AndesException {
        Connection connection = null;
        PreparedStatement storeMembershipEventPreparedStatement = null;
        String task = "Storing membership event: " + membershipEventType + " for member: " + changedMember;
        try {
            connection = this.getConnection();
            storeMembershipEventPreparedStatement = connection.prepareStatement("INSERT INTO MB_MEMBERSHIP (NODE_ID,CHANGE_TYPE,CHANGED_MEMBER_ID) VALUES ( ?,?,?)");
            for (String clusterNode : clusterNodes) {
                storeMembershipEventPreparedStatement.setString(1, clusterNode);
                storeMembershipEventPreparedStatement.setInt(2, membershipEventType);
                storeMembershipEventPreparedStatement.setString(3, changedMember);
                storeMembershipEventPreparedStatement.addBatch();
            }
            storeMembershipEventPreparedStatement.executeBatch();
            connection.commit();
            this.close(storeMembershipEventPreparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error storing membership change: " + membershipEventType + " for member: " + changedMember, e);
            }
            catch (Throwable throwable) {
                this.close(storeMembershipEventPreparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    @Override
    public List<MembershipEvent> readMemberShipEvents(String nodeID) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement clearMembershipEvents = null;
        ResultSet resultSet = null;
        ArrayList<Object> membershipEvents = new ArrayList<Object>();
        String task = "retrieving membership events destined to: " + nodeID;
        try {
            Object membershipEvent;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT EVENT_ID,CHANGE_TYPE,CHANGED_MEMBER_ID FROM MB_MEMBERSHIP WHERE NODE_ID=? ORDER BY EVENT_ID");
            preparedStatement.setString(1, nodeID);
            resultSet = preparedStatement.executeQuery();
            clearMembershipEvents = connection.prepareStatement("DELETE FROM MB_MEMBERSHIP WHERE EVENT_ID=?");
            while (resultSet.next()) {
                membershipEvent = new MembershipEvent(MembershipEventType.getTypeFromInt(resultSet.getInt("CHANGE_TYPE")), resultSet.getString("CHANGED_MEMBER_ID"));
                membershipEvents.add(membershipEvent);
                clearMembershipEvents.setLong(1, resultSet.getLong("EVENT_ID"));
                clearMembershipEvents.addBatch();
            }
            clearMembershipEvents.executeBatch();
            connection.commit();
            membershipEvent = membershipEvents;
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(clearMembershipEvents, task);
            this.close(connection, task);
            return membershipEvent;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(clearMembershipEvents, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    @Override
    public void clearMembershipEvents(String nodeID) throws AndesException {
        Connection connection = null;
        PreparedStatement clearMembershipEvents = null;
        String task = "Clearing all membership events for node: " + nodeID;
        try {
            connection = this.getConnection();
            clearMembershipEvents = connection.prepareStatement("DELETE FROM MB_MEMBERSHIP WHERE NODE_ID=?");
            clearMembershipEvents.setString(1, nodeID);
            clearMembershipEvents.executeUpdate();
            connection.commit();
            this.close(clearMembershipEvents, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(clearMembershipEvents, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    @Override
    public void storeClusterNotification(List<String> clusterNodes, String originatedNode, String notifiedArtifact, String clusterNotificationType, String notification, String description) throws AndesException {
        Connection connection = null;
        PreparedStatement storeMembershipEventPreparedStatement = null;
        String task = "Storing cluster notification: " + notification + " of type: " + clusterNotificationType;
        try {
            connection = this.getConnection();
            storeMembershipEventPreparedStatement = connection.prepareStatement("INSERT INTO MB_CLUSTER_EVENT (DESTINED_NODE_ID,ORIGINATED_NODE_ID,EVENT_ARTIFACT,EVENT_TYPE,EVENT_DESCRIPTION,EVENT_DETAILS) VALUES (?,?,?,?,?,?)");
            for (String destinedNode : clusterNodes) {
                storeMembershipEventPreparedStatement.setString(1, destinedNode);
                storeMembershipEventPreparedStatement.setString(2, originatedNode);
                storeMembershipEventPreparedStatement.setString(3, notifiedArtifact);
                storeMembershipEventPreparedStatement.setString(4, clusterNotificationType);
                storeMembershipEventPreparedStatement.setString(5, description);
                storeMembershipEventPreparedStatement.setString(6, notification);
                storeMembershipEventPreparedStatement.addBatch();
            }
            storeMembershipEventPreparedStatement.executeBatch();
            connection.commit();
            this.close(storeMembershipEventPreparedStatement, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error cluster notification: " + notification + " with change type: " + clusterNotificationType, e);
            }
            catch (Throwable throwable) {
                this.close(storeMembershipEventPreparedStatement, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    @Override
    public List<ClusterNotification> readClusterNotifications(String nodeID) throws AndesException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        PreparedStatement clearClusterNotificationEvents = null;
        ResultSet resultSet = null;
        ArrayList<ArrayList<ClusterNotification>> clusterNotifications = new ArrayList<ArrayList<ClusterNotification>>();
        String task = "retrieving cluster notifications destined to: " + nodeID;
        try {
            ArrayList<ClusterNotification> notification;
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT EVENT_ID,ORIGINATED_NODE_ID,EVENT_ARTIFACT,EVENT_TYPE,EVENT_DETAILS,EVENT_DESCRIPTION FROM MB_CLUSTER_EVENT WHERE DESTINED_NODE_ID=? ORDER BY EVENT_ID");
            preparedStatement.setString(1, nodeID);
            resultSet = preparedStatement.executeQuery();
            clearClusterNotificationEvents = connection.prepareStatement("DELETE FROM MB_CLUSTER_EVENT WHERE EVENT_ID=?");
            while (resultSet.next()) {
                notification = new ClusterNotification(resultSet.getString("EVENT_DETAILS"), resultSet.getString("EVENT_ARTIFACT"), resultSet.getString("EVENT_TYPE"), resultSet.getString("EVENT_DESCRIPTION"), resultSet.getString("ORIGINATED_NODE_ID"));
                clusterNotifications.add(notification);
                clearClusterNotificationEvents.setLong(1, resultSet.getLong("EVENT_ID"));
                clearClusterNotificationEvents.addBatch();
            }
            clearClusterNotificationEvents.executeBatch();
            connection.commit();
            notification = clusterNotifications;
            this.close(resultSet, task);
            this.close(preparedStatement, task);
            this.close(clearClusterNotificationEvents, task);
            this.close(connection, task);
            return notification;
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(resultSet, task);
                this.close(preparedStatement, task);
                this.close(clearClusterNotificationEvents, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }

    @Override
    public void clearClusterNotifications(String nodeID) throws AndesException {
        Connection connection = null;
        PreparedStatement clearMembershipEvents = null;
        String task = "Clearing all membership events for node: " + nodeID;
        try {
            connection = this.getConnection();
            clearMembershipEvents = connection.prepareStatement("DELETE FROM MB_CLUSTER_EVENT WHERE DESTINED_NODE_ID=?");
            clearMembershipEvents.setString(1, nodeID);
            clearMembershipEvents.executeUpdate();
            connection.commit();
            this.close(clearMembershipEvents, task);
            this.close(connection, task);
        }
        catch (SQLException e) {
            try {
                this.rollback(connection, task);
                throw this.rdbmsStoreUtils.convertSQLException("Error occurred while " + task, e);
            }
            catch (Throwable throwable) {
                this.close(clearMembershipEvents, task);
                this.close(connection, task);
                throw throwable;
            }
        }
    }
}

