/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import com.gs.collections.api.iterator.MutableLongIterator;
import com.gs.collections.impl.list.mutable.primitive.LongArrayList;
import com.gs.collections.impl.map.mutable.primitive.LongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.kernel.AndesMessage;
import org.wso2.andes.kernel.AndesMessagePart;
import org.wso2.andes.store.cache.AndesMessageCache;

public class GuavaBasedMessageCacheImpl
implements AndesMessageCache {
    private static final Logger log = Logger.getLogger(GuavaBasedMessageCacheImpl.class);
    private static final String CACHE_VALUE_REF_TYPE_STRONG = "strong";
    private static final String CACHE_VALUE_REF_TYPE_WEAK = "weak";
    private final Cache<Long, AndesMessage> cache;
    private ScheduledExecutorService maintenanceExecutor;
    private final boolean printStats;
    private static int DEFAULT_CONTENT_CHUNK_SIZE;

    public GuavaBasedMessageCacheImpl() {
        DEFAULT_CONTENT_CHUNK_SIZE = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERFORMANCE_TUNING_MAX_CONTENT_CHUNK_SIZE);
        long cacheSizeInBytes = 0x100000L * (long)((Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_CACHE_SIZE)).intValue();
        int cacheConcurrency = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_CACHE_CONCURRENCY_LEVEL);
        int cacheExpirySeconds = (Integer)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_CACHE_EXPIRY_SECONDS);
        String valueRefType = (String)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_CACHE_VALUE_REFERENCE_TYPE);
        this.printStats = (Boolean)AndesConfigurationManager.readValue(AndesConfiguration.PERSISTENCE_CACHE_PRINT_STATS);
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(cacheConcurrency).expireAfterAccess((long)cacheExpirySeconds, TimeUnit.SECONDS).maximumWeight(cacheSizeInBytes).weigher((Weigher)new Weigher<Long, AndesMessage>(){

            public int weigh(Long l, AndesMessage m) {
                return m.getMetadata().getMessageContentLength();
            }
        });
        if (this.printStats) {
            builder = builder.recordStats();
        }
        if (CACHE_VALUE_REF_TYPE_WEAK.equalsIgnoreCase(valueRefType)) {
            builder = builder.weakValues();
        }
        this.cache = builder.build();
        this.maintenanceExecutor = Executors.newSingleThreadScheduledExecutor();
        this.maintenanceExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                GuavaBasedMessageCacheImpl.this.cache.cleanUp();
                if (GuavaBasedMessageCacheImpl.this.printStats) {
                    log.info((Object)("cache stats:" + GuavaBasedMessageCacheImpl.this.cache.stats().toString()));
                }
            }
        }, 2L, 2L, TimeUnit.MINUTES);
    }

    @Override
    public void addToCache(AndesMessage message) {
        this.cache.put((Object)message.getMetadata().getMessageID(), (Object)message);
    }

    @Override
    public void removeFromCache(LongArrayList messagesToRemove) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        MutableLongIterator iterator = messagesToRemove.longIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.cache.invalidateAll(arrayList);
    }

    @Override
    public void removeFromCache(long messageToRemove) {
        this.cache.invalidate((Object)messageToRemove);
    }

    @Override
    public AndesMessage getMessageFromCache(long messageId) {
        return (AndesMessage)this.cache.getIfPresent((Object)messageId);
    }

    @Override
    public void fillContentFromCache(LongArrayList messageIDList, LongObjectHashMap<List<AndesMessagePart>> contentList) {
        MutableLongIterator iterator = messageIDList.longIterator();
        while (iterator.hasNext()) {
            Long messageID = iterator.next();
            AndesMessage andesMessage = (AndesMessage)this.cache.getIfPresent((Object)messageID);
            if (null == andesMessage) continue;
            contentList.put(messageID, andesMessage.getContentChunkList());
            iterator.remove();
        }
    }

    @Override
    public AndesMessagePart getContentFromCache(long messageId, int offsetValue) {
        AndesMessage cachedMessage = this.getMessageFromCache(messageId);
        AndesMessagePart part = null;
        if (null != cachedMessage) {
            part = this.getMessageFromCache(messageId).getContentChunkList().get(offsetValue / DEFAULT_CONTENT_CHUNK_SIZE);
        }
        return part;
    }
}

