/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.store;

import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.AMQException;
import org.wso2.andes.amqp.QpidAndesBridge;
import org.wso2.andes.kernel.AndesException;
import org.wso2.andes.kernel.slot.Slot;
import org.wso2.andes.server.store.StorableMessageMetaData;
import org.wso2.andes.server.store.StoredMessage;
import org.wso2.andes.server.store.TransactionLog;

public class StoredAMQPMessage
implements StoredMessage {
    private static Log log = LogFactory.getLog(StoredAMQPMessage.class);
    private final long _messageId;
    private StorableMessageMetaData metaData;
    private String channelID;
    private String exchange;
    private Slot slot;

    public StoredAMQPMessage(long messageId, StorableMessageMetaData metaData) {
        this._messageId = messageId;
        this.metaData = metaData;
    }

    public StorableMessageMetaData getMetaData() {
        if (this.metaData == null) {
            try {
                QpidAndesBridge.getMessageMetaData(this._messageId);
            }
            catch (AMQException e) {
                log.error((Object)("Error while getting message metaData for message ID " + this._messageId));
            }
        }
        return this.metaData;
    }

    @Override
    public long getMessageNumber() {
        return this._messageId;
    }

    @Override
    public void addContent(int offsetInMessage, ByteBuffer src) {
    }

    @Override
    public void duplicateMessageContent(long messageId, long messageIdOfClone) throws AndesException {
    }

    @Override
    public int getContent(int offsetInMessage, ByteBuffer dst) {
        int c = 0;
        try {
            c = QpidAndesBridge.getMessageContentChunk(this._messageId, offsetInMessage, dst);
        }
        catch (AMQException e) {
            log.error((Object)("Error while getting message content chunk messageID=" + this._messageId + " offset=" + offsetInMessage), (Throwable)e);
        }
        return c;
    }

    @Override
    public TransactionLog.StoreFuture flushToStore() {
        throw new UnsupportedOperationException();
    }

    public String getChannelID() {
        return this.channelID;
    }

    public void setChannelID(String channelID) {
        this.channelID = channelID;
    }

    @Override
    public void remove() {
    }

    @Override
    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getExchange() {
        return this.exchange;
    }

    @Override
    public Slot getSlot() {
        return this.slot;
    }

    @Override
    public void setSlot(Slot slot) {
        this.slot = slot;
    }
}

